/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.IToBeBuiltComputerContribution;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.Pair;

@Singleton
public class ToBeBuiltComputer {
    @Inject
    private IBuilderState builderState;
    @Inject
    private IStorage2UriMapper mapper;
    @Inject
    private UriValidator uriValidator;
    @Inject
    private QueuedBuildData queuedBuildData;
    private IToBeBuiltComputerContribution contribution;
    private static final int MONITOR_CHUNK_SIZE = 100;

    @Inject
    private void initializeContributions(ISharedStateContributionRegistry registry) {
        this.contribution = this.getContribution((ImmutableList<? extends IToBeBuiltComputerContribution>)registry.getContributedInstances(IToBeBuiltComputerContribution.class));
    }

    private IToBeBuiltComputerContribution getContribution(ImmutableList<? extends IToBeBuiltComputerContribution> contributedInstances) {
        switch (contributedInstances.size()) {
            case 0: {
                return new NullContribution();
            }
            case 1: {
                return (IToBeBuiltComputerContribution)contributedInstances.get(0);
            }
        }
        return new CompositeContribution(contributedInstances);
    }

    public ToBeBuilt removeProject(IProject project, IProgressMonitor monitor) {
        ToBeBuilt toBeBuilt = this.doRemoveProject(project, monitor);
        this.contribution.removeProject(toBeBuilt, project, monitor);
        return toBeBuilt;
    }

    protected ToBeBuilt doRemoveProject(IProject project, IProgressMonitor monitor) {
        this.queuedBuildData.reset(project);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(Iterables.size((Iterable)this.builderState.getAllResourceDescriptions()) / 100 + 1));
        ToBeBuilt result = new ToBeBuilt();
        Iterable allResourceDescriptions = this.builderState.getAllResourceDescriptions();
        int i = 0;
        for (IResourceDescription description : allResourceDescriptions) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Iterable storages = this.mapper.getStorages(description.getURI());
            boolean onlyOnThisProject = true;
            Iterator iterator = storages.iterator();
            while (iterator.hasNext() && onlyOnThisProject) {
                Pair storage2Project = (Pair)iterator.next();
                IProject second = (IProject)storage2Project.getSecond();
                boolean isSameProject = project.equals((Object)second);
                boolean bl = onlyOnThisProject = isSameProject || second == null || !second.isAccessible();
            }
            if (onlyOnThisProject) {
                result.getToBeDeleted().add(description.getURI());
            }
            if (++i % 100 != 0) continue;
            progress.worked(1);
        }
        return result;
    }

    public ToBeBuilt updateProjectNewResourcesOnly(IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ToBeBuiltComputer_CollectingResources, (int)1);
        progress.subTask(Messages.ToBeBuiltComputer_CollectingResources);
        ToBeBuilt toBeBuilt = this.updateProject(project, (IProgressMonitor)progress.split(1));
        Iterable existingURIs = Iterables.transform((Iterable)this.builderState.getAllResourceDescriptions(), (Function)new Function<IResourceDescription, URI>(){

            public URI apply(IResourceDescription from) {
                return from.getURI();
            }
        });
        for (URI existingURI : existingURIs) {
            toBeBuilt.getToBeDeleted().remove(existingURI);
            toBeBuilt.getToBeUpdated().remove(existingURI);
        }
        return toBeBuilt;
    }

    public ToBeBuilt updateProject(IProject project, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ToBeBuiltComputer_CollectingResources, (int)10);
        progress.subTask(Messages.ToBeBuiltComputer_CollectingResources);
        final ToBeBuilt toBeBuilt = this.doRemoveProject(project, (IProgressMonitor)progress.split(8));
        if (!project.isAccessible()) {
            return toBeBuilt;
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        final SubMonitor childMonitor = progress.split(1);
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (resource instanceof IStorage) {
                    return ToBeBuiltComputer.this.updateStorage((IProgressMonitor)childMonitor, toBeBuilt, (IStorage)resource);
                }
                if (resource instanceof IFolder) {
                    return ToBeBuiltComputer.this.isHandled((IFolder)resource);
                }
                return true;
            }
        });
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.contribution.updateProject(toBeBuilt, project, (IProgressMonitor)progress.split(1));
        return toBeBuilt;
    }

    public boolean updateStorage(IProgressMonitor monitor, ToBeBuilt toBeBuilt, IStorage storage) {
        if (this.contribution.updateStorage(toBeBuilt, storage, monitor)) {
            return true;
        }
        if (!this.isHandled(storage)) {
            return true;
        }
        URI uri = this.getUri(storage);
        if (uri != null) {
            toBeBuilt.getToBeUpdated().add(uri);
        }
        return true;
    }

    public boolean removeStorage(IProgressMonitor monitor, ToBeBuilt toBeBuilt, IStorage storage) {
        if (this.contribution.removeStorage(toBeBuilt, storage, monitor)) {
            return true;
        }
        if (!this.isHandled(storage)) {
            return true;
        }
        URI uri = this.getUri(storage);
        if (uri != null) {
            toBeBuilt.getToBeDeleted().add(uri);
        }
        return true;
    }

    protected boolean isHandled(IStorage storage) {
        boolean possiblyManaged = this.contribution.isPossiblyHandled(storage);
        return (possiblyManaged || storage instanceof IFile) && this.uriValidator.isPossiblyManaged(storage);
    }

    protected boolean isHandled(IFolder folder) {
        return !this.contribution.isRejected(folder);
    }

    protected URI getUri(IStorage file) {
        URI uri = this.mapper.getUri(file);
        return uri != null && this.isValid(uri, file) ? uri : null;
    }

    protected boolean isValid(URI uri, IStorage storage) {
        return this.uriValidator.canBuild(uri, storage);
    }

    protected Set<IProject> getInterestingProjects(IProject project) throws CoreException {
        LinkedHashSet<IProject> result = new LinkedHashSet<IProject>(Arrays.asList(project.getReferencedProjects()));
        this.contribution.addInterestingProjects(project, result);
        return result;
    }

    public static class CompositeContribution
    implements IToBeBuiltComputerContribution {
        private ImmutableList<? extends IToBeBuiltComputerContribution> contributions;

        protected CompositeContribution(ImmutableList<? extends IToBeBuiltComputerContribution> contributions) {
            this.contributions = contributions;
        }

        @Override
        public void removeProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) {
            int i = 0;
            int size = this.contributions.size();
            while (i < size) {
                ((IToBeBuiltComputerContribution)this.contributions.get(i)).removeProject(toBeBuilt, project, monitor);
                ++i;
            }
        }

        @Override
        public void updateProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) throws CoreException {
            int i = 0;
            while (i < this.contributions.size()) {
                ((IToBeBuiltComputerContribution)this.contributions.get(i)).updateProject(toBeBuilt, project, monitor);
                ++i;
            }
        }

        @Override
        public boolean removeStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
            int i = 0;
            while (i < this.contributions.size()) {
                if (((IToBeBuiltComputerContribution)this.contributions.get(i)).removeStorage(toBeBuilt, storage, monitor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean updateStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
            int i = 0;
            while (i < this.contributions.size()) {
                if (((IToBeBuiltComputerContribution)this.contributions.get(i)).updateStorage(toBeBuilt, storage, monitor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean isPossiblyHandled(IStorage storage) {
            boolean result = false;
            int i = 0;
            while (i < this.contributions.size() && !result) {
                result = ((IToBeBuiltComputerContribution)this.contributions.get(i)).isPossiblyHandled(storage);
                ++i;
            }
            return result;
        }

        @Override
        public boolean isRejected(IFolder folder) {
            int i = 0;
            while (i < this.contributions.size()) {
                if (((IToBeBuiltComputerContribution)this.contributions.get(i)).isRejected(folder)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public void addInterestingProjects(IProject thisProject, Set<IProject> result) {
            int i = 0;
            while (i < this.contributions.size()) {
                ((IToBeBuiltComputerContribution)this.contributions.get(i)).addInterestingProjects(thisProject, result);
                ++i;
            }
        }
    }

    public static class NullContribution
    implements IToBeBuiltComputerContribution {
        @Override
        public void removeProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) {
        }

        @Override
        public void updateProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) throws CoreException {
        }

        @Override
        public boolean removeStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
            return false;
        }

        @Override
        public boolean updateStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
            return false;
        }

        @Override
        public boolean isPossiblyHandled(IStorage storage) {
            return false;
        }

        @Override
        public boolean isRejected(IFolder folder) {
            return false;
        }
    }
}

