/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval;

import java.io.Closeable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.fordiac.ide.model.eval.DefaultEvaluatorDebugger;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorDebugger;
import org.eclipse.fordiac.ide.model.eval.EvaluatorMonitor;
import org.eclipse.fordiac.ide.model.eval.EvaluatorThread;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorCountingEventQueue;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;

public abstract class AbstractEvaluator
implements Evaluator {
    private final Variable<?> context;
    private final Evaluator parent;

    protected AbstractEvaluator(Variable<?> context, Evaluator parent) {
        this.context = context;
        this.parent = parent;
    }

    @Override
    public Variable<?> getContext() {
        return this.context;
    }

    @Override
    public Evaluator getParent() {
        return this.parent;
    }

    protected <T> T trap(T context) throws InterruptedException {
        AbstractEvaluator.currentDebugger().trap(context, this);
        return context;
    }

    protected void info(String message) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.info(message));
    }

    protected void warn(String message) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.warn(message));
    }

    protected void error(String message) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.error(message));
    }

    protected void error(String message, Throwable t) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.error(message, t));
    }

    protected void update(Collection<? extends Variable<?>> variables) {
        AbstractEvaluator.currentMonitors().forEach(monitor -> monitor.update(variables, this));
    }

    public static EvaluatorDebugger currentDebugger() {
        Thread thread = Thread.currentThread();
        if (thread instanceof EvaluatorThread) {
            EvaluatorThread evaluatorThread = (EvaluatorThread)thread;
            return evaluatorThread.getExecutor().getDebugger();
        }
        return DefaultEvaluatorDebugger.INSTANCE;
    }

    public static Set<EvaluatorMonitor> currentMonitors() {
        Thread thread = Thread.currentThread();
        if (thread instanceof EvaluatorThread) {
            EvaluatorThread evaluatorThread = (EvaluatorThread)thread;
            return evaluatorThread.getExecutor().getMonitorSet();
        }
        return Collections.emptySet();
    }

    public static Map<String, Object> currentContext() {
        Thread thread = Thread.currentThread();
        if (thread instanceof EvaluatorThread) {
            EvaluatorThread evaluatorThread = (EvaluatorThread)thread;
            return evaluatorThread.getExecutor().getContext();
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Closeable> getSharedResources() {
        void evaluatorThread;
        Thread thread = Thread.currentThread();
        if (!(thread instanceof EvaluatorThread)) {
            throw new IllegalStateException("Cannot get shared resources without evaluator thread");
        }
        EvaluatorThread evaluatorThread2 = (EvaluatorThread)thread;
        return evaluatorThread.getExecutor().getSharedResources();
    }

    public static Clock currentMonotonicClock() {
        Thread thread = Thread.currentThread();
        if (thread instanceof EvaluatorThread) {
            EvaluatorThread evaluatorThread = (EvaluatorThread)thread;
            return evaluatorThread.getExecutor().getMonotonicClock();
        }
        return MonotonicClock.UTC;
    }

    /*
     * WARNING - void declaration
     */
    public static void setMonotonicClock(Clock clock) {
        void evaluatorThread;
        Thread thread = Thread.currentThread();
        if (!(thread instanceof EvaluatorThread)) {
            throw new IllegalStateException("Cannot set clock without evaluator thread");
        }
        EvaluatorThread evaluatorThread2 = (EvaluatorThread)thread;
        evaluatorThread.getExecutor().setMonotonicClock(clock);
    }

    public static Clock currentRealtimeClock() {
        Thread thread = Thread.currentThread();
        if (thread instanceof EvaluatorThread) {
            EvaluatorThread evaluatorThread = (EvaluatorThread)thread;
            return evaluatorThread.getExecutor().getRealtimeClock();
        }
        return Clock.systemUTC();
    }

    /*
     * WARNING - void declaration
     */
    public static void setRealtimeClock(Clock clock) {
        void evaluatorThread;
        Thread thread = Thread.currentThread();
        if (!(thread instanceof EvaluatorThread)) {
            throw new IllegalStateException("Cannot set clock without evaluator thread");
        }
        EvaluatorThread evaluatorThread2 = (EvaluatorThread)thread;
        evaluatorThread.getExecutor().setRealtimeClock(clock);
    }

    public static class IntervalClock
    extends Clock {
        private final Instant offset;
        private final Duration interval;
        private final ZoneId zone;
        private final FBEvaluatorCountingEventQueue queue;
        private final long queueOffset;

        public IntervalClock(Instant offset, Duration interval, ZoneId zone, FBEvaluatorCountingEventQueue queue, long queueOffset) {
            this.offset = Objects.requireNonNull(offset);
            this.interval = Objects.requireNonNull(interval);
            this.zone = Objects.requireNonNull(zone);
            this.queue = Objects.requireNonNull(queue);
            this.queueOffset = queueOffset;
        }

        @Override
        public Instant instant() {
            return this.instant(this.queue.getTotalInputCount().get());
        }

        private Instant instant(long totalCount) {
            return this.offset.plus(this.interval.multipliedBy(totalCount - this.queueOffset));
        }

        @Override
        public Clock withZone(ZoneId zone) {
            long totalCount = this.queue.getTotalInputCount().get();
            return new IntervalClock(this.instant(totalCount), this.interval, zone, this.queue, totalCount);
        }

        public static Clock startingAt(Clock clock, Duration interval, FBEvaluatorCountingEventQueue queue) {
            long totalCount = queue.getTotalInputCount().get();
            return new IntervalClock(clock != null ? clock.instant() : Instant.EPOCH, interval, clock != null ? clock.getZone() : ZoneOffset.UTC, queue, totalCount);
        }

        public Instant getStart() {
            return this.offset;
        }

        public Duration getInterval() {
            return this.interval;
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        public FBEvaluatorCountingEventQueue getQueue() {
            return this.queue;
        }

        public long getQueueOffset() {
            return this.queueOffset;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.offset, this.interval, this.zone, this.queue, this.queueOffset);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntervalClock other = (IntervalClock)obj;
            return Objects.equals(this.offset, other.offset) && Objects.equals(this.interval, other.interval) && Objects.equals(this.zone, other.zone) && Objects.equals(this.queue, other.queue) && this.queueOffset == other.queueOffset;
        }

        public String toString() {
            return String.format("%s [offset=%s, interval=%s, zone=%s]", this.getClass().getName(), this.offset, this.interval, this.zone);
        }
    }

    public static class MonotonicClock
    extends Clock {
        public static final MonotonicClock UTC = new MonotonicClock(ZoneOffset.UTC);
        private final ZoneId zone;

        public MonotonicClock(ZoneId zone) {
            this.zone = zone;
        }

        @Override
        public Instant instant() {
            long nanoTime = System.nanoTime();
            return Instant.ofEpochSecond(nanoTime / 1000000000L, nanoTime % 1000000000L);
        }

        @Override
        public Clock withZone(ZoneId zone) {
            return new MonotonicClock(zone);
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        @Override
        public int hashCode() {
            return this.zone.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof MonotonicClock)) {
                return false;
            }
            MonotonicClock monotonicClock = (MonotonicClock)obj;
            return Objects.equals(this.zone, other.zone);
        }

        public String toString() {
            return String.format("%s [zone=%s]", this.getClass().getName(), this.zone);
        }
    }
}

