/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.Subrange;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableEvaluator;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpressionSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTypeDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class VarDeclarationEvaluator
extends StructuredTextEvaluator
implements VariableEvaluator {
    private final VarDeclaration varDeclaration;
    private LibraryElement resultType;
    private STTypeDeclaration parseResultType;
    private STInitializerExpressionSource parseResult;

    public VarDeclarationEvaluator(VarDeclaration varDeclaration, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(varDeclaration.getName(), context, variables, parent);
        this.varDeclaration = varDeclaration;
    }

    public void prepare() {
        this.prepareResultType();
        this.prepareInitialValue();
    }

    protected void prepareResultType() {
        if (this.parseResultType == null && this.varDeclaration.isArray()) {
            ArrayList errors = new ArrayList();
            ArrayList warnings = new ArrayList();
            ArrayList infos = new ArrayList();
            this.parseResultType = StructuredTextParseUtil.parseType((VarDeclaration)this.varDeclaration, errors, warnings, infos);
            errors.forEach(arg_0 -> ((VarDeclarationEvaluator)this).error(arg_0));
            warnings.forEach(arg_0 -> ((VarDeclarationEvaluator)this).warn(arg_0));
            infos.forEach(arg_0 -> ((VarDeclarationEvaluator)this).info(arg_0));
            if (this.parseResultType == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
        }
    }

    protected void prepareInitialValue() {
        if (this.parseResult == null && VariableOperations.hasDeclaredInitialValue((VarDeclaration)this.varDeclaration)) {
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            ArrayList<String> infos = new ArrayList<String>();
            this.parseResult = this.parseInitialValue(errors, warnings, infos);
            errors.forEach(arg_0 -> ((VarDeclarationEvaluator)this).error(arg_0));
            warnings.forEach(arg_0 -> ((VarDeclarationEvaluator)this).warn(arg_0));
            infos.forEach(arg_0 -> ((VarDeclarationEvaluator)this).info(arg_0));
            if (this.parseResult == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
        }
    }

    protected STInitializerExpressionSource parseInitialValue(List<String> errors, List<String> warnings, List<String> infos) {
        try {
            this.evaluateResultType();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        return StructuredTextParseUtil.parse((String)this.varDeclaration.getValue().getValue(), (URI)(this.varDeclaration.eResource() != null ? this.varDeclaration.eResource().getURI() : null), (LibraryElement)this.resultType, (LibraryElement)((LibraryElement)EcoreUtil2.getContainerOfType((EObject)this.varDeclaration, LibraryElement.class)), null, errors, warnings, infos);
    }

    public void cleanup() {
        this.parseResult = null;
        this.parseResultType = null;
        this.resultType = null;
    }

    public Value evaluate() throws EvaluatorException, InterruptedException {
        return this.evaluateVariable().getValue();
    }

    public Variable<?> evaluateVariable() throws EvaluatorException, InterruptedException {
        this.prepareInitialValue();
        Variable result = VariableOperations.newVariable((String)this.varDeclaration.getName(), (LibraryElement)this.evaluateResultType());
        if (this.parseResult != null && this.parseResult.getInitializerExpression() != null) {
            this.evaluateInitializerExpression(result, ((STInitializerExpressionSource)this.trap(this.parseResult)).getInitializerExpression());
        }
        return result;
    }

    public boolean validateVariable(List<String> errors, List<String> warnings, List<String> infos) throws EvaluatorException, InterruptedException {
        if (VariableOperations.hasDeclaredInitialValue((VarDeclaration)this.varDeclaration)) {
            return this.parseInitialValue(errors, warnings, infos) != null;
        }
        return true;
    }

    public LibraryElement evaluateResultType() throws EvaluatorException, InterruptedException {
        if (this.resultType == null) {
            this.prepareResultType();
            this.resultType = this.parseResultType != null ? this.evaluateTypeDeclaration(this.parseResultType) : this.varDeclaration.getType();
        }
        return this.resultType;
    }

    public boolean validateResultType(List<String> errors, List<String> warnings, List<String> infos) throws EvaluatorException, InterruptedException {
        if (this.varDeclaration.isArray()) {
            return StructuredTextParseUtil.parseType((VarDeclaration)this.varDeclaration, errors, warnings, infos) != null;
        }
        return true;
    }

    protected LibraryElement evaluateTypeDeclaration(STTypeDeclaration declaration) throws EvaluatorException, InterruptedException {
        DataType type;
        DataType dataType;
        DataType dataType2 = dataType = declaration.getType();
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyStringType.class, DataType.class}, (Object)dataType2, n)) {
                case 0: {
                    AnyStringType anyStringType = (AnyStringType)dataType;
                    if (declaration.getMaxLength() == null) {
                        dataType2 = dataType;
                        n = 1;
                        continue block4;
                    }
                    DataType dataType3 = STCoreUtil.newStringType((AnyStringType)anyStringType, (int)ValueOperations.asInteger((Value)this.evaluateExpression(declaration.getMaxLength())));
                    break block4;
                }
                default: {
                    DataType dataType4;
                    DataType dataType3 = dataType4 = dataType;
                    break block4;
                }
                case -1: {
                    DataType dataType3 = type = null;
                }
            }
            break;
        }
        if (declaration.isArray()) {
            if (declaration.getRanges().isEmpty()) {
                return STCoreUtil.newArrayType((DataType)type, declaration.getCount().stream().map(unused -> DataFactory.eINSTANCE.createSubrange()).toList());
            }
            ArrayList<Subrange> subranges = new ArrayList<Subrange>(declaration.getRanges().size());
            for (STExpression range : declaration.getRanges()) {
                subranges.add(this.evaluateSubrange(range));
            }
            return STCoreUtil.newArrayType((DataType)type, subranges);
        }
        return type;
    }

    public Set<String> getDependencies() {
        return Stream.of(this.getTypeDependencies(), this.getInitialValueDependencies()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    protected Set<String> getTypeDependencies() {
        if (this.varDeclaration.getBlockFBNetworkElement() == null) {
            this.prepareResultType();
            if (this.parseResultType != null) {
                return StructuredTextParseUtil.collectUsedTypes((EObject)this.parseResultType);
            }
            return Set.of(PackageNameHelper.getFullTypeName((LibraryElement)this.varDeclaration.getType()));
        }
        return Collections.emptySet();
    }

    protected Set<String> getInitialValueDependencies() {
        this.prepareInitialValue();
        if (this.parseResult != null) {
            return StructuredTextParseUtil.collectUsedTypes((EObject)this.parseResult);
        }
        return Collections.emptySet();
    }

    public Object getSourceElement() {
        return this.varDeclaration;
    }
}

