/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.scope;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.scope.AbstractComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FilterComparisonScope
extends AbstractComparisonScope {
    protected Predicate<? super EObject> eObjectContentFilter = Predicates.alwaysTrue();
    protected Predicate<? super EObject> resourceContentFilter = Predicates.alwaysTrue();
    protected Predicate<? super Resource> resourceSetContentFilter = Predicates.alwaysTrue();

    public FilterComparisonScope(Notifier left, Notifier right, Notifier origin) {
        super(left, right, origin);
    }

    @Override
    public Iterator<? extends Resource> getCoveredResources(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return Collections.emptyIterator();
        }
        Iterator allResources = resourceSet.getResources().iterator();
        UnmodifiableIterator filter = Iterators.filter((Iterator)allResources, this.resourceSetContentFilter);
        URIInitializingIterator uriInitializingIt = new URIInitializingIterator(filter);
        return Iterators.unmodifiableIterator(uriInitializingIt);
    }

    @Override
    public Iterator<? extends EObject> getCoveredEObjects(Resource resource) {
        if (resource == null) {
            return Collections.emptyIterator();
        }
        TreeIterator properContent = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
        UnmodifiableIterator filter = Iterators.filter((Iterator)properContent, this.resourceContentFilter);
        URIInitializingIterator uriInitializingIt = new URIInitializingIterator(resource, filter);
        return Iterators.unmodifiableIterator(uriInitializingIt);
    }

    @Override
    public Iterator<? extends EObject> getChildren(EObject eObject) {
        if (eObject == null) {
            return Collections.emptyIterator();
        }
        TreeIterator properContent = EcoreUtil.getAllProperContents((EObject)eObject, (boolean)false);
        UnmodifiableIterator filter = Iterators.filter((Iterator)properContent, this.eObjectContentFilter);
        URIInitializingIterator uriInitializingIt = new URIInitializingIterator(eObject, filter);
        return Iterators.unmodifiableIterator(uriInitializingIt);
    }

    public void setEObjectContentFilter(Predicate<? super EObject> newContentFilter) {
        this.eObjectContentFilter = newContentFilter;
    }

    public void setResourceContentFilter(Predicate<? super EObject> resourceContentFilter) {
        this.resourceContentFilter = resourceContentFilter;
    }

    public void setResourceSetContentFilter(Predicate<? super Resource> resourceSetContentFilter) {
        this.resourceSetContentFilter = resourceSetContentFilter;
    }

    protected <T> void addUri(T obj) {
        if (obj instanceof Resource) {
            this.addUri((Resource)obj);
        } else if (obj instanceof EObject) {
            this.addUri((EObject)obj);
        }
    }

    protected void addUri(EObject eObject) {
        Resource res = eObject.eResource();
        if (res != null) {
            this.getResourceURIs().add(res.getURI().toString());
        }
        this.getNsURIs().add(eObject.eClass().getEPackage().getNsURI());
    }

    protected void addUri(Resource resource) {
        this.getResourceURIs().add(resource.getURI().toString());
    }

    private class URIInitializingIterator<T>
    extends ForwardingIterator<T> {
        private Iterator<T> delegate;

        URIInitializingIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        URIInitializingIterator(Resource resource, Iterator<T> delegate) {
            this.delegate = delegate;
            FilterComparisonScope.this.addUri(resource);
        }

        URIInitializingIterator(EObject eObject, Iterator<T> delegate) {
            this.delegate = delegate;
            FilterComparisonScope.this.addUri(eObject);
        }

        protected Iterator<T> delegate() {
            return this.delegate;
        }

        public T next() {
            Object obj = super.next();
            FilterComparisonScope.this.addUri(obj);
            return (T)obj;
        }
    }
}

