/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.CheckableStructTreeNode;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.gef.commands.Command;

public class AddDemuxPortCommand
extends Command
implements ScopedCommand {
    private Demultiplexer type;
    private final String varName;
    private Demultiplexer oldMux;
    private ChangeStructCommand cmd;
    private final CheckableStructTreeNode node;

    public AddDemuxPortCommand(Demultiplexer type, CheckableStructTreeNode node) {
        this.node = Objects.requireNonNull(node);
        this.type = Objects.requireNonNull(type);
        this.varName = node.getPinName();
    }

    public void execute() {
        this.node.updateNode(true);
        String newVisibleChildren = ((CheckableStructTreeNode)this.node.getTree().getRoot()).visibleToString();
        this.cmd = new ChangeStructCommand(this.type, newVisibleChildren);
        if (this.cmd.canExecute()) {
            this.cmd.execute();
        }
        this.oldMux = this.type;
        this.type = (Demultiplexer)this.cmd.getNewMux();
    }

    public boolean canExecute() {
        if (this.varName == null) {
            return false;
        }
        return this.type.getMemberVars().stream().map(MemberVarDeclaration.class::cast).noneMatch(member -> this.node.getPinName().equals(member.getName()));
    }

    public void redo() {
        this.node.updateNode(true);
        this.cmd.redo();
        this.type = (Demultiplexer)this.cmd.getNewMux();
    }

    public void undo() {
        this.node.updateNode(false);
        this.type = this.oldMux;
        this.cmd.undo();
    }

    public Demultiplexer getType() {
        return this.type;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.type.getFbNetwork() != null) {
            return Set.of(this.type.getFbNetwork());
        }
        return Set.of(this.type);
    }
}

