/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui;

import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.fordiac.ide.debug.LaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public abstract class LaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        this.launch(this.getLaunchableResource(selection), mode);
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(this.getLaunchableResource(editor), mode);
    }

    public void launch(IResource resource, String mode) {
        if (resource == null) {
            return;
        }
        try {
            ILaunchConfiguration[] configurations = this.getLaunchConfgurations(resource);
            if (configurations == null) {
                return;
            }
            if (configurations.length == 0) {
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationId());
                ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, manager.generateLaunchConfigurationName(resource.getName()));
                this.initializeDefaultLaunchConfiguration(configuration, resource, mode);
                configuration.doSave();
                this.launch(resource, (ILaunchConfiguration)configuration, mode);
            } else {
                this.launch(resource, configurations[0], mode);
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public abstract void launch(IResource var1, ILaunchConfiguration var2, String var3);

    public void initializeDefaultLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration, IResource resource, String mode) {
        configuration.setAttribute("org.eclipse.fordiac.ide.debug.resource", resource.getFullPath().toString());
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.getLaunchConfgurations(this.getLaunchableResource(selection));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return this.getLaunchConfgurations(this.getLaunchableResource(editorpart));
    }

    protected ILaunchConfiguration[] getLaunchConfgurations(IResource resource) {
        if (resource != null) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationId());
            try {
                return (ILaunchConfiguration[])Stream.of(manager.getLaunchConfigurations(type)).filter(configuration -> LaunchShortcut.isRelevantLaunchConfiguration(configuration, resource)).toArray(ILaunchConfiguration[]::new);
            }
            catch (CoreException e) {
                FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
            }
        }
        return new ILaunchConfiguration[0];
    }

    protected static boolean isRelevantLaunchConfiguration(ILaunchConfiguration configuration, IResource resource) {
        try {
            IResource targetResource = LaunchConfigurationAttributes.getResource((ILaunchConfiguration)configuration);
            return resource.equals((Object)targetResource);
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
            return false;
        }
    }

    public IResource getLaunchableResource(ISelection selection) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            IResource resource = (IResource)object;
            return resource;
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        IEditorInput iEditorInput = editorpart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)iEditorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }

    public abstract String getLaunchConfigurationId();
}

