/*
 * Copyright (c) 2008 INRIA
 *
 * SPDX-License-Identifier: GPL-2.0-only
 *
 * Authors: Mathieu Lacage <mathieu.lacage@sophia.inria.fr>
 */
#ifndef BOOLEAN_H
#define BOOLEAN_H

#include "attribute-helper.h"
#include "attribute.h"

/**
 * \file
 * \ingroup attribute_Boolean
 * ns3::BooleanValue attribute value declarations.
 */

namespace ns3
{

// Doxygen for this class is auto-generated by
// utils/print-introspected-doxygen.h
class BooleanValue : public AttributeValue
{
  public:
    BooleanValue();
    BooleanValue(const bool& value);
    void Set(bool value);
    bool Get() const;
    template <typename T>
    bool GetAccessor(T& v) const;

    /**
     * Functor returning the value.
     * \returns The value.
     */
    operator bool() const;

    Ptr<AttributeValue> Copy() const override;
    std::string SerializeToString(Ptr<const AttributeChecker> checker) const override;
    bool DeserializeFromString(std::string value, Ptr<const AttributeChecker> checker) override;

  private:
    bool m_value;
};

template <typename T>
bool
BooleanValue::GetAccessor(T& v) const
{
    v = T(m_value);
    return true;
}

/**
 * \ingroup attribute_Boolean
 * Output streamer.
 *
 * The value is printed as "true" or "false".
 *
 * \param [in,out] os The stream.
 * \param [in] value The BooleanValue to print.
 * \returns The stream.
 */
std::ostream& operator<<(std::ostream& os, const BooleanValue& value);

ATTRIBUTE_CHECKER_DEFINE(Boolean);
ATTRIBUTE_ACCESSOR_DEFINE(Boolean);

} // namespace ns3

#endif /* BOOLEAN_H */
