=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class PkiTidyStatusResponse
    # The number of revoked acme accounts removed
    attr_accessor :acme_account_deleted_count

    # The number of unused acme accounts revoked
    attr_accessor :acme_account_revoked_count

    # Safety buffer after creation after which accounts lacking orders are revoked
    attr_accessor :acme_account_safety_buffer

    # The number of expired, unused acme orders removed
    attr_accessor :acme_orders_deleted_count

    # The number of certificate storage entries deleted
    attr_accessor :cert_store_deleted_count

    attr_accessor :cross_revoked_cert_deleted_count

    # The number of revoked certificate entries deleted
    attr_accessor :current_cert_store_count

    # The number of revoked certificate entries deleted
    attr_accessor :current_revoked_cert_count

    # The error message
    attr_accessor :error

    attr_accessor :internal_backend_uuid

    # Issuer safety buffer
    attr_accessor :issuer_safety_buffer

    # Time the last auto-tidy operation finished
    attr_accessor :last_auto_tidy_finished

    # Message of the operation
    attr_accessor :message

    attr_accessor :missing_issuer_cert_count

    # Duration to pause between tidying certificates
    attr_accessor :pause_duration

    attr_accessor :revocation_queue_deleted_count

    # Revocation queue safety buffer
    attr_accessor :revocation_queue_safety_buffer

    # The number of revoked certificate entries deleted
    attr_accessor :revoked_cert_deleted_count

    # Safety buffer time duration
    attr_accessor :safety_buffer

    # One of Inactive, Running, Finished, or Error
    attr_accessor :state

    # Tidy Unused Acme Accounts, and Orders
    attr_accessor :tidy_acme

    # Tidy certificate store
    attr_accessor :tidy_cert_store

    # Tidy the cross-cluster revoked certificate store
    attr_accessor :tidy_cross_cluster_revoked_certs

    # Tidy expired issuers
    attr_accessor :tidy_expired_issuers

    attr_accessor :tidy_move_legacy_ca_bundle

    attr_accessor :tidy_revocation_queue

    # Tidy revoked certificate issuer associations
    attr_accessor :tidy_revoked_cert_issuer_associations

    # Tidy revoked certificates
    attr_accessor :tidy_revoked_certs

    # Time the operation finished
    attr_accessor :time_finished

    # Time the operation started
    attr_accessor :time_started

    # Total number of acme accounts iterated over
    attr_accessor :total_acme_account_count

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'acme_account_deleted_count' => :'acme_account_deleted_count',
        :'acme_account_revoked_count' => :'acme_account_revoked_count',
        :'acme_account_safety_buffer' => :'acme_account_safety_buffer',
        :'acme_orders_deleted_count' => :'acme_orders_deleted_count',
        :'cert_store_deleted_count' => :'cert_store_deleted_count',
        :'cross_revoked_cert_deleted_count' => :'cross_revoked_cert_deleted_count',
        :'current_cert_store_count' => :'current_cert_store_count',
        :'current_revoked_cert_count' => :'current_revoked_cert_count',
        :'error' => :'error',
        :'internal_backend_uuid' => :'internal_backend_uuid',
        :'issuer_safety_buffer' => :'issuer_safety_buffer',
        :'last_auto_tidy_finished' => :'last_auto_tidy_finished',
        :'message' => :'message',
        :'missing_issuer_cert_count' => :'missing_issuer_cert_count',
        :'pause_duration' => :'pause_duration',
        :'revocation_queue_deleted_count' => :'revocation_queue_deleted_count',
        :'revocation_queue_safety_buffer' => :'revocation_queue_safety_buffer',
        :'revoked_cert_deleted_count' => :'revoked_cert_deleted_count',
        :'safety_buffer' => :'safety_buffer',
        :'state' => :'state',
        :'tidy_acme' => :'tidy_acme',
        :'tidy_cert_store' => :'tidy_cert_store',
        :'tidy_cross_cluster_revoked_certs' => :'tidy_cross_cluster_revoked_certs',
        :'tidy_expired_issuers' => :'tidy_expired_issuers',
        :'tidy_move_legacy_ca_bundle' => :'tidy_move_legacy_ca_bundle',
        :'tidy_revocation_queue' => :'tidy_revocation_queue',
        :'tidy_revoked_cert_issuer_associations' => :'tidy_revoked_cert_issuer_associations',
        :'tidy_revoked_certs' => :'tidy_revoked_certs',
        :'time_finished' => :'time_finished',
        :'time_started' => :'time_started',
        :'total_acme_account_count' => :'total_acme_account_count'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'acme_account_deleted_count' => :'Integer',
        :'acme_account_revoked_count' => :'Integer',
        :'acme_account_safety_buffer' => :'Integer',
        :'acme_orders_deleted_count' => :'Integer',
        :'cert_store_deleted_count' => :'Integer',
        :'cross_revoked_cert_deleted_count' => :'Integer',
        :'current_cert_store_count' => :'Integer',
        :'current_revoked_cert_count' => :'Integer',
        :'error' => :'String',
        :'internal_backend_uuid' => :'String',
        :'issuer_safety_buffer' => :'Integer',
        :'last_auto_tidy_finished' => :'String',
        :'message' => :'String',
        :'missing_issuer_cert_count' => :'Integer',
        :'pause_duration' => :'String',
        :'revocation_queue_deleted_count' => :'Integer',
        :'revocation_queue_safety_buffer' => :'Integer',
        :'revoked_cert_deleted_count' => :'Integer',
        :'safety_buffer' => :'Integer',
        :'state' => :'String',
        :'tidy_acme' => :'Boolean',
        :'tidy_cert_store' => :'Boolean',
        :'tidy_cross_cluster_revoked_certs' => :'Boolean',
        :'tidy_expired_issuers' => :'Boolean',
        :'tidy_move_legacy_ca_bundle' => :'Boolean',
        :'tidy_revocation_queue' => :'Boolean',
        :'tidy_revoked_cert_issuer_associations' => :'Boolean',
        :'tidy_revoked_certs' => :'Boolean',
        :'time_finished' => :'String',
        :'time_started' => :'String',
        :'total_acme_account_count' => :'Integer'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::PkiTidyStatusResponse` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::PkiTidyStatusResponse`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'acme_account_deleted_count')
        self.acme_account_deleted_count = attributes[:'acme_account_deleted_count']
      end

      if attributes.key?(:'acme_account_revoked_count')
        self.acme_account_revoked_count = attributes[:'acme_account_revoked_count']
      end

      if attributes.key?(:'acme_account_safety_buffer')
        self.acme_account_safety_buffer = attributes[:'acme_account_safety_buffer']
      end

      if attributes.key?(:'acme_orders_deleted_count')
        self.acme_orders_deleted_count = attributes[:'acme_orders_deleted_count']
      end

      if attributes.key?(:'cert_store_deleted_count')
        self.cert_store_deleted_count = attributes[:'cert_store_deleted_count']
      end

      if attributes.key?(:'cross_revoked_cert_deleted_count')
        self.cross_revoked_cert_deleted_count = attributes[:'cross_revoked_cert_deleted_count']
      end

      if attributes.key?(:'current_cert_store_count')
        self.current_cert_store_count = attributes[:'current_cert_store_count']
      end

      if attributes.key?(:'current_revoked_cert_count')
        self.current_revoked_cert_count = attributes[:'current_revoked_cert_count']
      end

      if attributes.key?(:'error')
        self.error = attributes[:'error']
      end

      if attributes.key?(:'internal_backend_uuid')
        self.internal_backend_uuid = attributes[:'internal_backend_uuid']
      end

      if attributes.key?(:'issuer_safety_buffer')
        self.issuer_safety_buffer = attributes[:'issuer_safety_buffer']
      end

      if attributes.key?(:'last_auto_tidy_finished')
        self.last_auto_tidy_finished = attributes[:'last_auto_tidy_finished']
      end

      if attributes.key?(:'message')
        self.message = attributes[:'message']
      end

      if attributes.key?(:'missing_issuer_cert_count')
        self.missing_issuer_cert_count = attributes[:'missing_issuer_cert_count']
      end

      if attributes.key?(:'pause_duration')
        self.pause_duration = attributes[:'pause_duration']
      end

      if attributes.key?(:'revocation_queue_deleted_count')
        self.revocation_queue_deleted_count = attributes[:'revocation_queue_deleted_count']
      end

      if attributes.key?(:'revocation_queue_safety_buffer')
        self.revocation_queue_safety_buffer = attributes[:'revocation_queue_safety_buffer']
      end

      if attributes.key?(:'revoked_cert_deleted_count')
        self.revoked_cert_deleted_count = attributes[:'revoked_cert_deleted_count']
      end

      if attributes.key?(:'safety_buffer')
        self.safety_buffer = attributes[:'safety_buffer']
      end

      if attributes.key?(:'state')
        self.state = attributes[:'state']
      end

      if attributes.key?(:'tidy_acme')
        self.tidy_acme = attributes[:'tidy_acme']
      end

      if attributes.key?(:'tidy_cert_store')
        self.tidy_cert_store = attributes[:'tidy_cert_store']
      end

      if attributes.key?(:'tidy_cross_cluster_revoked_certs')
        self.tidy_cross_cluster_revoked_certs = attributes[:'tidy_cross_cluster_revoked_certs']
      end

      if attributes.key?(:'tidy_expired_issuers')
        self.tidy_expired_issuers = attributes[:'tidy_expired_issuers']
      end

      if attributes.key?(:'tidy_move_legacy_ca_bundle')
        self.tidy_move_legacy_ca_bundle = attributes[:'tidy_move_legacy_ca_bundle']
      end

      if attributes.key?(:'tidy_revocation_queue')
        self.tidy_revocation_queue = attributes[:'tidy_revocation_queue']
      end

      if attributes.key?(:'tidy_revoked_cert_issuer_associations')
        self.tidy_revoked_cert_issuer_associations = attributes[:'tidy_revoked_cert_issuer_associations']
      end

      if attributes.key?(:'tidy_revoked_certs')
        self.tidy_revoked_certs = attributes[:'tidy_revoked_certs']
      end

      if attributes.key?(:'time_finished')
        self.time_finished = attributes[:'time_finished']
      end

      if attributes.key?(:'time_started')
        self.time_started = attributes[:'time_started']
      end

      if attributes.key?(:'total_acme_account_count')
        self.total_acme_account_count = attributes[:'total_acme_account_count']
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      true
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          acme_account_deleted_count == o.acme_account_deleted_count &&
          acme_account_revoked_count == o.acme_account_revoked_count &&
          acme_account_safety_buffer == o.acme_account_safety_buffer &&
          acme_orders_deleted_count == o.acme_orders_deleted_count &&
          cert_store_deleted_count == o.cert_store_deleted_count &&
          cross_revoked_cert_deleted_count == o.cross_revoked_cert_deleted_count &&
          current_cert_store_count == o.current_cert_store_count &&
          current_revoked_cert_count == o.current_revoked_cert_count &&
          error == o.error &&
          internal_backend_uuid == o.internal_backend_uuid &&
          issuer_safety_buffer == o.issuer_safety_buffer &&
          last_auto_tidy_finished == o.last_auto_tidy_finished &&
          message == o.message &&
          missing_issuer_cert_count == o.missing_issuer_cert_count &&
          pause_duration == o.pause_duration &&
          revocation_queue_deleted_count == o.revocation_queue_deleted_count &&
          revocation_queue_safety_buffer == o.revocation_queue_safety_buffer &&
          revoked_cert_deleted_count == o.revoked_cert_deleted_count &&
          safety_buffer == o.safety_buffer &&
          state == o.state &&
          tidy_acme == o.tidy_acme &&
          tidy_cert_store == o.tidy_cert_store &&
          tidy_cross_cluster_revoked_certs == o.tidy_cross_cluster_revoked_certs &&
          tidy_expired_issuers == o.tidy_expired_issuers &&
          tidy_move_legacy_ca_bundle == o.tidy_move_legacy_ca_bundle &&
          tidy_revocation_queue == o.tidy_revocation_queue &&
          tidy_revoked_cert_issuer_associations == o.tidy_revoked_cert_issuer_associations &&
          tidy_revoked_certs == o.tidy_revoked_certs &&
          time_finished == o.time_finished &&
          time_started == o.time_started &&
          total_acme_account_count == o.total_acme_account_count
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [acme_account_deleted_count, acme_account_revoked_count, acme_account_safety_buffer, acme_orders_deleted_count, cert_store_deleted_count, cross_revoked_cert_deleted_count, current_cert_store_count, current_revoked_cert_count, error, internal_backend_uuid, issuer_safety_buffer, last_auto_tidy_finished, message, missing_issuer_cert_count, pause_duration, revocation_queue_deleted_count, revocation_queue_safety_buffer, revoked_cert_deleted_count, safety_buffer, state, tidy_acme, tidy_cert_store, tidy_cross_cluster_revoked_certs, tidy_expired_issuers, tidy_move_legacy_ca_bundle, tidy_revocation_queue, tidy_revoked_cert_issuer_associations, tidy_revoked_certs, time_finished, time_started, total_acme_account_count].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
