---
stage: Manage
group: Foundations
info: Any user with at least the Maintainer role can merge updates to this content. For details, see https://docs.gitlab.com/ee/development/development_processes.html#development-guidelines-review.
---

# Frontend onboarding course

Welcome to the Frontend Onboarding Course at GitLab!
In this course, we walk you through your first professional frontend development experience, helping you gain real world skills and learn how to contribute to a large-scale codebase effectively.

Throughout the course, we'll follow a structured approach.
Each lesson focuses on solving a specific problem on GitLab, giving you hands-on experience.
You'll learn theory that you can immediately put into practice.
By working on real-world GitLab issues, you'll encounter challenges and learn how to navigate the codebase effectively while at the same time improving GitLab the product.

We believe in an interactive learning experience.
You'll have the opportunity to ask questions and seek help from the GitLab community.
We appreciate your contributions and are here to support your learning while at the same time making GitLab better.

Our teaching style prioritizes practical learning.
Lessons include an introduction to the problem, theory, live coding walkthroughs, and similar issues for you to tackle.
As you progress, the complexity of the tasks increase, helping you grow your skills.

Join us on this journey of front-end development at GitLab. Say hello in [the Discord community](https://discord.com/invite/gitlab) and let's learn and improve together.

## Lessons

- [Lesson 1](lesson_1.md)

## Structure and timings

The course is run over 6 weeks, with a required time commitment of 5-10 hours per week.

The course is free of charge, but we do ask for a commitment to complete the curriculum (including 10 merged merge requests).

After completing the course, you receive a certificate and GitLab achievement.

Each week consists of the following sessions:

- 1-hour relaxed discussion-style lesson with explanation of how GitLab frontend works. Each week features a different guest and includes an AMA portion.
- 2-hour live coding lesson with a practical task for participants to complete.
- 2 x 2-hour dedicated “Office Hours” sessions where participants can work on the task assigned in the lesson with GitLab frontend engineers. (2 sessions in different timezones as this will require participants to join synchronously)

A fortnightly 1-on-1 mentoring sessions are also available to each participant.

There are 10 places available on the course.
The date will be set after the course material has been prepared.
Complete the [Frontend Onboarding Course Application Form](https://forms.gle/39Rs4w4ZxQuByhE4A) to apply.

You may also participate in the course informally at your own pace, without the benefit of the synchronous office hours or mentoring session.
GitLab team members are happy to support you regardless.

## Curriculum summary

### Lesson 1

- What is a development environment?
  - What is the GDK?
  - Installing the GDK.
  - GDK tips and tricks.
  - Using Gitpod to run the GDK.
- Navigating the GitLab codebase.
- Writing a good merge request.
