---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Improper limitation of a pathname to a restricted directory (Path traversal)

## Description

The vulnerability can be exploited by inserting a payload into a
parameter on the URL endpoint which allows for reading arbitrary files.
This could be used to read sensitive files, access other users data, or aid in
exploitation to gain further system access.

## Remediation

User input should never be used in constructing paths or files for interacting
with the filesystem. This includes filenames supplied by user uploads or downloads.

If possible, consider hashing the filenames and reference the hashed filenames in
a database or datastore instead of directly attempting to access filenames provided
by users or other system components.

In the rare cases that the application must work with filenames, use the language
provided functionality to extract only the filename part of the supplied value.
Never attempt to use the path or directory information that comes from user input.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 22.1 | false | 22 | Active | high |

## Links

- [OWASP](https://owasp.org/www-community/attacks/Path_Traversal)
- [CWE](https://cwe.mitre.org/data/definitions/22.html)
