/* mfp.c -- fool MFJOB, a program by Eberhard Mattes.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* The DVI drivers by Eberhard Mattes are really good but they are
   far away from any standard if they cannot find a font.  Instead
   of calling MakeTeXPK in a subshell, they generate a script for the
   MFJOB utility and invoke it.  MFJOB itself first calls "mfp" and
   then "gftopk" to get the font; and all this happens with file names
   matching FAT drive restrictions!  */


#include <stdio.h>
#include <stdlib.h>
#include <process.h>


int
main (int argc, char **argv)
{
#ifndef DEBUG

  char *mf, *com;
  int res;

  for (; argv[1][0] != '&'; ++argv)
    ;

  mf = getenv ("VIRMF");
  if (!mf)
    mf = "virmf.exe";

  argv[0] = mf;

  res = spawnvp (P_WAIT, mf, argv);
  if (res == 0)
    {
      com = getenv ("COMSPEC");
      if (!com)
	exit (1);

      res = spawnlp (P_WAIT, com, com, "/c", "ren", "*.???*gf", "*.???", 0);
    }

  exit (res);

#else /* DEBUG */

  FILE *log;

  log = fopen ("mfp.log", "w");
  if (log)
    {
      while (*++argv)
	fprintf (log, "%s\n", *argv);

      fclose (log);
    }

  exit (1);

#endif /* DEBUG */
}


/*
 * local variables:
 * compile-command: "gcc -Zomf -Zcrtdll -s -o mfp.exe mfp.c mfp.def"
 * end:
 */
