/*
  pm_keys.e by Petr Mikulik, http://www.sci.muni.cz/~mikulik/
  Some my favourite key sequences are defined here.
  This file is in public domain.

  This file belongs to the "pmCSTeX for EPM" package, see 
    http://www.sci.muni.cz/~mikulik/os2/pmCSTeX.html
  or pmcstex.zip on hobbes, leo and CTAN archives.
*/


-- CTRL/Y deletes line
def C_Y = 
deleteline; .col=1


-- Alt-1  generalizes the EPM's include file function
def A_1 = 
'cstex_include S'

-- Alt-3 inserts \begin{}
def A_3 =
  getline x; replaceline( insertstr('\begin{}',x,.col-1) )
  .col=.col+7
 
-- Alt-4 inserts \end{}
def A_4 =
  getline x; replaceline( insertstr('\end{}',x,.col-1) )
  .col=.col+5

-- Alt-5 inserts \[  \]
def A_5 =
  if .col>1 then .line=.line+1; endif 
  insertline '%'
  insertline '\['
  insertline ''
  insertline '\]'
  insertline '%'
  .col=1
  .line=.line-3
  
-- Alt-6 inserts $$  $$
def A_6 =
  if .col>1 then .line=.line+1; endif 
  insertline '%'
  insertline '$$'
  insertline ''
  insertline '$$'
  insertline '%'
  .col=1
  .line=.line-3

-- Alt-W  unmarks, then calls the default EPM action for word marking, and 
-- finally puts the marked text into the clipboard
def a_w = 
if marktype()<>'' then unmark; endif
call pmark_word()
'copy2clip'


-- Alt-Z margins for e-mailed documents, TeX files and programs
def A_Z =
ma2='ma 1 1599 1'; ma3='ma 1 80 1'; ma4='ma 1 75 1'
s=entrybox('Set margins','/OK/'ma2'/'ma3'/'ma4,'ma '.margins,30,30)
if     s=4 then s=ma4
elseif s=3 then s=ma3
elseif s='' then s=ma2
endif
s


/*
Definition of the Alt-Q hotkey. It provides the following two actions:

1. quickly makes \begin{equation} ... \end{equation} environment with two
   two comment lines above and below. Thus pressing Alt-Q on this line would do:
   %
   \begin{equation}
   
   \end{equation}
   %

2. If you put the cursor over the line containing only the string 
\begin{..} or \end{..}, where XX is equation, eqnarray, align, equation*, 
eqnarray*, align*, then instead of the function 1. the text on this line
is changed to the next environment in this list. 
  Useful if you add one more equation into an \begin{equation}.

Note for future: this could be more powerful if this command would change 
both \begin{..} and \end{..} simultaneously.
*/

def A_Q = 
if (not wordpos(filetype(), 'TEX LATEX STY CLS DTX') ) then
  sayerror 'pm_keys: Alt-Q does not work on non-TeX files'
  return
  endif
getline S
B='\begin{'; E='\end{'
s1='equation}'; s2='eqnarray}'; s3='align}'
if	S=B''s1	then	S=B''s2
elseif	S=B''s2	then	S=B''s3
elseif	S=B''s3	then	S=B''s1
elseif	S=E''s1	then	S=E''s2
elseif	S=E''s2	then	S=E''s3
elseif	S=E''s3	then	S=E''s1
else 
s1='equation*}'; s2='eqnarray*}'; s3='align*}'
if	S=B''s1	then	S=B''s2
elseif	S=B''s2	then	S=B''s3
elseif	S=B''s3	then	S=B''s1
elseif	S=E''s1	then	S=E''s2
elseif	S=E''s2	then	S=E''s3
elseif	S=E''s3	then	S=E''s1
else 
  -- inserting the \begin{equation} ... \end{equation}
  if .col>1 then .line=.line+1; endif
  insertline '%'; insertline '\begin{equation}'
  insertline ''
  insertline '\end{equation}'; insertline '%'
  .line=.line-3
  .col=1
  return
endif
endif
replaceline S  -- finishing the replacement mode



-- syntax highlighting on
defload
'a_togl_hilit S'
