#ifndef lint
static char *copyright = "Copyright (C) 1985, Sven Mattisson.";
#endif

#include <stdio.h>
#include "hash.h"
#include "comtab.h"

struct hashent {
    struct command  *comp;
    struct hashent  *next;
};

#define HASHSIZE	    103

struct hashent	hashtab[HASHSIZE] = { { NULL, NULL} };

extern char *malloc ();

int
hash (s)
    char *s;
{
    int hashval;

    for (hashval = 0; *s != '\0'; s++)
        hashval += 3 * (int)(*s);
    return (hashval % HASHSIZE);
}

struct command *
lookup (s)
    char *s;
{
    struct hashent *hp;

    for (hp = &hashtab[hash(s)]; hp -> comp != NULL; hp = hp -> next) {
        if (strcmp (s, hp -> comp -> name) == 0)
	    return (hp -> comp);
	if (hp -> next == NULL)
	    break;
    }
    return (NULL);
}

struct command *
install (com)
    struct command *com;
{
    struct hashent *p, *hp = &hashtab[hash (com -> name)];

    if (hp -> comp == NULL) {
        hp -> comp = com;
	return (hp -> comp);
    }
    for (p = hp; p != NULL; p = p -> next) {
        if (strcmp (p -> comp -> name, com -> name) == 0)
	    break;
	hp = p;
    }
    if (p == NULL) {
        hp -> next = (struct hashent *) malloc (sizeof (struct hashent));
	p = hp -> next;
	if (p == NULL)
	    return (NULL);
	p -> next = NULL;
    }
    p -> comp = com;
    return (p -> comp);
}

inithashtab ()
{
    int i;

    for (i = 0; i < comtabsize; i++)
        if (install (&comtab[i]) == NULL) {
	    perror ("inithashtab");
	    exit (1);
	}
}
