/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.highprecision;

import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleComputer;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleType;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class DoubleDouble
implements DoubleDoubleType,
Comparable<DoubleDouble> {
    private final double high;
    private final double low;
    public static final DoubleDouble PI = new DoubleDouble(Math.PI, 1.2246467991473532E-16);
    public static final DoubleDouble TWO_PI = new DoubleDouble(Math.PI * 2, 2.4492935982947064E-16);
    public static final DoubleDouble PI_2 = new DoubleDouble(1.5707963267948966, 6.123233995736766E-17);
    public static final DoubleDouble E = new DoubleDouble(Math.E, 1.4456468917292502E-16);
    public static final DoubleDouble NaN = new DoubleDouble(Double.NaN, 0.0);
    public static final double EPS = 1.23259516440783E-32;
    public static final DoubleDouble TEN = new DoubleDouble(10.0, 0.0);
    public static final DoubleDouble ONE = new DoubleDouble(1.0, 0.0);
    public static final DoubleDouble ZERO = new DoubleDouble(0.0, 0.0);
    private static final int MAX_PRINT_DIGITS = 32;
    private static final String SCI_NOT_EXPONENT_CHAR = "E";
    private static final String SCI_NOT_ZERO = "0.0E0";

    public static DoubleDouble parse(String str) throws NumberFormatException {
        DoubleDouble val2;
        char signCh;
        int i = 0;
        int strlen = str.length();
        while (Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        boolean isNegative = false;
        if (i < strlen && ((signCh = str.charAt(i)) == '-' || signCh == '+')) {
            ++i;
            if (signCh == '-') {
                isNegative = true;
            }
        }
        DoubleDoubleComputer val = new DoubleDoubleComputer();
        int numDigits = 0;
        int numBeforeDec = 0;
        int exp = 0;
        while (i < strlen) {
            char ch = str.charAt(i);
            ++i;
            if (Character.isDigit(ch)) {
                double d = ch - 48;
                val.mul(10.0, 0.0);
                val.add(d, 0.0);
                ++numDigits;
                continue;
            }
            if (ch == '.') {
                numBeforeDec = numDigits;
                continue;
            }
            if (ch == 'e' || ch == 'E') {
                String expStr = str.substring(i);
                try {
                    exp = Integer.parseInt(expStr);
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("Invalid exponent " + expStr + " in string " + str);
                }
            }
            throw new NumberFormatException("Unexpected character '" + ch + "' at position " + i + " in string " + str);
        }
        int numDecPlaces = numDigits - numBeforeDec - exp;
        if (numDecPlaces == 0) {
            val2 = val.result();
        } else if (numDecPlaces > 0) {
            DoubleDouble scale = TEN.pow(numDecPlaces);
            val2 = val.div(scale).result();
        } else {
            DoubleDouble scale = TEN.pow(-numDecPlaces);
            val2 = val.mul(scale).result();
        }
        if (isNegative) {
            return val.chs().result();
        }
        return val2;
    }

    public static DoubleDouble valueOf(double x) {
        return new DoubleDouble(x, 0.0);
    }

    public static DoubleDouble valueOf(String str) throws NumberFormatException {
        return DoubleDouble.parse(str);
    }

    @Override
    public double asDouble() {
        return this.high + this.low;
    }

    public DoubleDouble ceil() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.ceil(this.high);
        double flo = 0.0;
        if (fhi == this.high) {
            flo = Math.ceil(this.low);
        }
        return new DoubleDouble(fhi, flo);
    }

    @Override
    public int compareTo(DoubleDouble other) {
        if (this.high < other.high) {
            return -1;
        }
        if (this.high > other.high) {
            return 1;
        }
        if (this.low < other.low) {
            return -1;
        }
        if (this.low > other.low) {
            return 1;
        }
        return 0;
    }

    public boolean isNaN() {
        return Double.isNaN(this.high);
    }

    @Override
    public boolean isNegative() {
        return this.high < 0.0 || this.high == 0.0 && this.low < 0.0;
    }

    @Override
    public boolean isPositive() {
        return this.high > 0.0 || this.high == 0.0 && this.low > 0.0;
    }

    @Override
    public boolean isZero() {
        return this.high == 0.0 && this.low == 0.0;
    }

    public boolean le(DoubleDouble y) {
        return this.high < y.high || this.high == y.high && this.low <= y.low;
    }

    public boolean lt(DoubleDouble y) {
        return this.high < y.high || this.high == y.high && this.low < y.low;
    }

    public String dump() {
        return "DD<" + this.high + ", " + this.low + ">";
    }

    public DoubleDouble floor() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.floor(this.high);
        double flo = 0.0;
        if (fhi == this.high) {
            flo = Math.floor(this.low);
        }
        return new DoubleDouble(fhi, flo);
    }

    public boolean ge(DoubleDouble y) {
        return this.high > y.high || this.high == y.high && this.low >= y.low;
    }

    public boolean gt(DoubleDouble y) {
        return this.high > y.high || this.high == y.high && this.low > y.low;
    }

    public int intValue() {
        return (int)this.high;
    }

    public DoubleDouble plus(DoubleDouble dd) {
        if (this.isNan()) {
            return this;
        }
        if (dd.isNaN()) {
            return dd;
        }
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this);
        computer.add(dd);
        return computer.result();
    }

    public DoubleDouble minus(DoubleDouble dd) {
        if (this.isNan()) {
            return this;
        }
        if (dd.isNaN()) {
            return dd;
        }
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this);
        computer.sub(dd);
        return computer.result();
    }

    public DoubleDouble times(DoubleDouble dd) {
        if (this.isNan()) {
            return this;
        }
        if (dd.isNaN()) {
            return dd;
        }
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this);
        computer.mul(dd);
        return computer.result();
    }

    public DoubleDouble divide(DoubleDouble dd) {
        if (this.isNan()) {
            return this;
        }
        if (dd.isNaN()) {
            return dd;
        }
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this);
        computer.div(dd);
        return computer.result();
    }

    public DoubleDouble times(double d) {
        if (this.isNan()) {
            return this;
        }
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this);
        computer.mul(d);
        return computer.result();
    }

    public DoubleDouble divide(double d) {
        if (this.isNan()) {
            return this;
        }
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this);
        computer.div(d);
        return computer.result();
    }

    public DoubleDouble inv() {
        if (this.isNan()) {
            return this;
        }
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this);
        computer.inv();
        return computer.result();
    }

    public DoubleDouble sqrt() {
        if (this.isNan()) {
            return this;
        }
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this);
        computer.sqrt();
        return computer.result();
    }

    public DoubleDouble square() {
        if (this.isNan()) {
            return this;
        }
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this);
        computer.mul(this);
        return computer.result();
    }

    public DoubleDouble negate() {
        if (this.isNaN()) {
            return this;
        }
        return new DoubleDouble(-this.high, -this.low);
    }

    public DoubleDouble abs() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isNegative()) {
            return this.negate();
        }
        return this;
    }

    public DoubleDouble pow(int exp) {
        if ((double)exp == 0.0) {
            return DoubleDouble.valueOf(1.0);
        }
        DoubleDoubleComputer r = new DoubleDoubleComputer(this);
        DoubleDoubleComputer s = new DoubleDoubleComputer(1.0);
        int n = Math.abs(exp);
        if (n > 1) {
            while (n > 0) {
                if (n % 2 == 1) {
                    s = s.mul(r);
                }
                if ((n /= 2) <= 0) continue;
                r = r.square();
            }
        } else {
            s = r;
        }
        if (exp < 0) {
            s.inv();
        }
        return s.result();
    }

    public DoubleDouble rint() {
        if (this.isNaN()) {
            return this;
        }
        DoubleDouble plus5 = this.plus(new DoubleDouble(0.5, 0.0));
        return plus5.floor();
    }

    public int signum() {
        if (this.isPositive()) {
            return 1;
        }
        if (this.isNegative()) {
            return -1;
        }
        return 0;
    }

    private static int magnitude(double x) {
        double xAbs = Math.abs(x);
        double xLog10 = Math.log(xAbs) / Math.log(10.0);
        int xMag = (int)Math.floor(xLog10);
        double xApprox = Math.pow(10.0, xMag);
        if (xApprox * 10.0 <= xAbs) {
            ++xMag;
        }
        return xMag;
    }

    private String getSpecialNumberString() {
        if (this.isZero()) {
            return "0.0";
        }
        if (this.isNaN()) {
            return "NaN ";
        }
        return null;
    }

    private String extractSignificantDigits(boolean insertDecimalPoint, int[] magnitude) {
        DoubleDouble y = this.abs();
        int mag = DoubleDouble.magnitude(y.high);
        DoubleDouble scale = TEN.pow(mag);
        if ((y = y.divide(scale)).gt(TEN)) {
            y = y.divide(TEN);
            ++mag;
        } else if (y.lt(ONE)) {
            y = y.times(TEN);
            --mag;
        }
        int decimalPointPos = mag + 1;
        StringBuilder buf = new StringBuilder();
        int numDigits = 31;
        for (int i = 0; i <= numDigits; ++i) {
            int digit;
            if (insertDecimalPoint && i == decimalPointPos) {
                buf.append('.');
            }
            if ((digit = (int)y.high) < 0 || digit > 9) {
                // empty if block
            }
            if (digit < 0) break;
            boolean rebiasBy10 = false;
            char digitChar = '\u0000';
            if (digit > 9) {
                rebiasBy10 = true;
                digitChar = '9';
            } else {
                digitChar = (char)(48 + digit);
            }
            buf.append(digitChar);
            y = y.minus(DoubleDouble.valueOf(digit)).times(TEN);
            if (rebiasBy10) {
                y = y.plus(TEN);
            }
            boolean continueExtractingDigits = true;
            int remMag = DoubleDouble.magnitude(y.high);
            if (remMag < 0 && Math.abs(remMag) >= numDigits - i) {
                continueExtractingDigits = false;
            }
            if (!continueExtractingDigits) break;
        }
        magnitude[0] = mag;
        return buf.toString();
    }

    public String toSciNotation() {
        if (this.isZero()) {
            return SCI_NOT_ZERO;
        }
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String digits = this.extractSignificantDigits(false, magnitude);
        String expStr = SCI_NOT_EXPONENT_CHAR + magnitude[0];
        if (digits.charAt(0) == '0') {
            throw new IllegalStateException("Found leading zero: " + digits);
        }
        String trailingDigits = "";
        if (digits.length() > 1) {
            trailingDigits = digits.substring(1);
        }
        String digitsWithDecimal = digits.charAt(0) + "." + trailingDigits;
        if (this.isNegative()) {
            return "-" + digitsWithDecimal + expStr;
        }
        return digitsWithDecimal + expStr;
    }

    public String toStandardNotation() {
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String sigDigits = this.extractSignificantDigits(true, magnitude);
        int decimalPointPos = magnitude[0] + 1;
        Object num = sigDigits;
        if (sigDigits.charAt(0) == '.') {
            num = "0" + sigDigits;
        } else if (decimalPointPos < 0) {
            num = "0." + DoubleDouble.stringOfChar('0', -decimalPointPos) + sigDigits;
        } else if (sigDigits.indexOf(46) == -1) {
            int numZeroes = decimalPointPos - sigDigits.length();
            String zeroes = DoubleDouble.stringOfChar('0', numZeroes);
            num = sigDigits + zeroes + ".0";
        }
        if (this.isNegative()) {
            return "-" + (String)num;
        }
        return num;
    }

    private static String stringOfChar(char ch, int len) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public String toString() {
        int mag = DoubleDouble.magnitude(this.high);
        if (mag >= -3 && mag <= 20) {
            return this.toStandardNotation();
        }
        return this.toSciNotation();
    }

    @Generated
    public DoubleDouble(double high, double low) {
        this.high = high;
        this.low = low;
    }

    @Override
    @Generated
    public double getHigh() {
        return this.high;
    }

    @Override
    @Generated
    public double getLow() {
        return this.low;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleDouble)) {
            return false;
        }
        DoubleDouble other = (DoubleDouble)o;
        if (Double.compare(this.getHigh(), other.getHigh()) != 0) {
            return false;
        }
        return Double.compare(this.getLow(), other.getLow()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $high = Double.doubleToLongBits(this.getHigh());
        result = result * 59 + (int)($high >>> 32 ^ $high);
        long $low = Double.doubleToLongBits(this.getLow());
        result = result * 59 + (int)($low >>> 32 ^ $low);
        return result;
    }
}

