## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)
library(kableExtra)

## ----envir--------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
repfun::rs_setup(D_POPDATA=repfun::adsl %>% dplyr::filter(SAFFL =='Y'), 
         D_SUBJID=c("STUDYID","USUBJID"),
         R_ADAMDATA=datdir)

## ----update, out.width="70%"--------------------------------------------------
repfun:::rfenv$G_POPDATA %>% dplyr::mutate(TRT01AN=ifelse(TRT01A=='Placebo',1,ifelse(TRT01A=='Xanomeline Low Dose',2,3)),
                     SEXN=ifelse(SEX=='F',1,ifelse(SEX=='M',2,NA)),
                     RACEN=ifelse(RACE=='AMERICAN INDIAN OR ALASKA NATIVE',1,
                                  ifelse(RACE=='BLACK OR AFRICAN AMERICAN',2,
                                         ifelse(RACE=='WHITE',3,NA))),
                     AGEGR1N=ifelse(AGEGR1=='18-64',1,ifelse(AGEGR1=='>64',2,NA))) %>% 
              repfun::ru_labels(varlabels=list('TRT01AN'='Actual Treatment for Period 01 (n)','SEXN'='Sex (n)',
                                       'RACEN'='Race (n)','AGEGR1N'='Pooled Age Group 1 (n)')) -> G_POPDATA

G_POPDATA %>% dplyr::select(STUDYID,USUBJID,SAFFL,TRT01AN,TRT01A) -> G_POPDATA1
adae <- repfun:::rfenv$adamdata$adae.rda() %>% dplyr::filter(TRTEMFL=='Y') %>% 
  dplyr::inner_join(G_POPDATA1, by=c('STUDYID','USUBJID','SAFFL','TRT01A'))

## ----cntper1------------------------------------------------------------------
aeprod <- repfun::ru_freq(adae,
                  dsetindenom=G_POPDATA1,
                  countdistinctvars=c('STUDYID','USUBJID'),
                  groupbyvarsnumer=c('TRT01AN','TRT01A','AEBODSYS','AEDECOD'),
                  anyeventvars = c('AEBODSYS','AEDECOD'),
                  anyeventvalues = c('ANY EVENT','ANY EVENT'),
                  groupbyvarsdenom=c('TRT01AN'),
                  resultstyle="NUMERPCT",
                  totalforvar=c('TRT01AN'),
                  totalid=99,
                  totaldecode='Total',
                  codedecodevarpairs=c("TRT01AN", "TRT01A"),
                  varcodelistpairs=c(""),
                  codelistnames=list(),
                  resultpctdps=2) %>% dplyr::select(TRT01AN,TRT01A,AEBODSYS,AEDECOD,NUMERCNT,
                                             DENOMCNT,PERCENT,tt_result) %>% 
                                      dplyr::arrange(TRT01AN,TRT01A,AEBODSYS,AEDECOD)

## ----results1-----------------------------------------------------------------
lbls <- sapply(aeprod,function(x){attr(x,"label")})
knitr::kable(head(aeprod,10), col.names=paste(names(lbls),lbls,sep=": "), 
             caption = "Counts and Percents for AEs by Body System and Preferred Term") %>%
    kable_styling(full_width = T) %>% column_spec(c(3,4,8), width_min = c('2in','2in','2in'))

## ----cntper2------------------------------------------------------------------
aeprod2 <- repfun::ru_freq(adae,
                   dsetindenom=G_POPDATA1,
                   countdistinctvars=c('STUDYID','USUBJID'),
                   groupbyvarsnumer=c('TRT01AN','TRT01A','AEDECOD'),
                   anyeventvars = c('AEDECOD'),
                   anyeventvalues = c('ANY EVENT'),
                   groupbyvarsdenom=c('TRT01AN'),
                   resultstyle="NUMERPCT",
                   totalforvar=c('TRT01AN'),
                   totalid=99,
                   totaldecode='Total',
                   codedecodevarpairs=c("TRT01AN", "TRT01A"),
                   varcodelistpairs=c(""),
                   codelistnames=list(),
                   resultpctdps=2) %>% dplyr::select(TRT01AN,TRT01A,AEDECOD,NUMERCNT,
                                              DENOMCNT,PERCENT,tt_result) %>% 
                                       dplyr::arrange(TRT01AN,TRT01A,AEDECOD)

## ----results2-----------------------------------------------------------------
lbls <- sapply(aeprod2,function(x){attr(x,"label")})
knitr::kable(head(aeprod2,10), col.names=paste(names(lbls),lbls,sep=": "), 
             caption = "Counts and Percents for AEs by Preferred Term Only") %>%
  kable_styling(full_width = T) %>% column_spec(c(3,7), width_min = c('2in','2in'))

## ----cntper3------------------------------------------------------------------
G_POPDATA %>% dplyr::select(STUDYID,USUBJID,SAFFL,TRT01AN,TRT01A,SEXN,SEX,
                     RACEN,RACE,AGEGR1N,AGEGR1) -> G_POPDATA2
dflst <- list()
basechar <- data.frame()
i <- 1
for(v in c('AGEGR1','SEX','RACE')){
  lbl <- attr(G_POPDATA[[v]],'label')
  dflst[[v]] <- repfun::ru_freq(G_POPDATA2, dsetindenom=G_POPDATA2, 
                        countdistinctvars=c("STUDYID", "USUBJID"),
                        groupbyvarsnumer=c("STUDYID", "TRT01AN", paste0(v,'N')),
                        anyeventvars = NULL, anyeventvalues = NULL, groupminmaxvar=NULL,
                        totalforvar=c("TRT01AN"), totalid = 99, totaldecode = 'Total',
                        groupbyvarsdenom=c("STUDYID", "TRT01AN"), resultstyle="NUMERPCT", 
                        codedecodevarpairs=c("TRT01AN", "TRT01A", paste0(v,'N'), v),
                        varcodelistpairs=c(""), codelistnames=list(), resultpctdps=0) %>% 
    {. ->> LBLS} %>%
    dplyr::mutate(tt_avid=i, tt_avnm=lbl) %>%
    rename(tt_svid=as.name(paste0(v,'N')), tt_svnm=as.name(v)) %>%
    dplyr::select(tt_avid,tt_avnm,TRT01AN,TRT01A,tt_svid,tt_svnm,NUMERCNT,
           DENOMCNT,PERCENT,tt_result) %>%
    dplyr::mutate(tt_avnm=paste0(tt_avnm,', n (%)'))
  row.names(dflst[[v]]) <- NULL
  basechar <- bind_rows(basechar,dflst[[v]])
  i <- i+1
  }
  basechar <- basechar %>% dplyr::arrange(TRT01AN,TRT01A,tt_avid,tt_avnm,tt_svid,tt_svnm)
  for (v in names(basechar)){
    if (v %in% names(LBLS)){
      attr(basechar[[v]],"label") <- attr(LBLS[[v]],"label")
    }
  }
  basechar <- repfun::ru_labels(basechar,varlabels=list('tt_svid'='Variable Order',
                                                'tt_svnm'='Variable Name',
                                                'tt_avid'='Value Order',
                                                'tt_avnm'='Value Name')) %>% 
              dplyr::arrange(tt_avid,tt_svid)

## ----results3-----------------------------------------------------------------
lbls <- sapply(basechar,function(x){attr(x,"label")})
knitr::kable(head(basechar,10), col.names=paste(names(lbls),lbls,sep=": "), 
             caption = "Counts and Percents for Demographic Data") %>%
  kable_styling(full_width = T) %>% 
  column_spec(c(2,4,6,10), width_min = c('2in','2in','3in','2in'))

