/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.VerificationField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureImportanceMap;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.Schema;
import org.jpmml.rexp.Converter;
import org.jpmml.rexp.HasFeatureImportances;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RFactorVector;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;
import org.jpmml.rexp.S4Object;

public abstract class ModelConverter<R extends RExp>
extends Converter<R> {
    public ModelConverter(R object) {
        super(object);
    }

    public abstract void encodeSchema(RExpEncoder var1);

    public abstract Model encodeModel(Schema var1);

    public Model encode(Schema schema) {
        HasFeatureImportances hasFeatureImportances;
        FeatureImportanceMap featureImportances;
        Model model = this.encodeModel(schema);
        if (this instanceof HasFeatureImportances && (featureImportances = (hasFeatureImportances = (HasFeatureImportances)((Object)this)).getFeatureImportances(schema)) != null && !featureImportances.isEmpty()) {
            ModelEncoder encoder = schema.getEncoder();
            Set entries = featureImportances.entrySet();
            for (Map.Entry entry : entries) {
                encoder.addFeatureImportance(model, (Feature)entry.getKey(), (Number)entry.getValue());
            }
        }
        return model;
    }

    @Override
    public PMML encodePMML(RExpEncoder encoder) {
        Model model;
        block8: {
            VerificationMap data;
            block10: {
                RGenericVector outputValues;
                block9: {
                    RExp model2;
                    Object object = this.getObject();
                    RGenericVector verification = null;
                    if (object instanceof S4Object) {
                        model2 = (S4Object)object;
                        verification = model2.getGenericAttribute("verification", false);
                    } else if (object instanceof RGenericVector) {
                        model2 = (RGenericVector)object;
                        verification = ((RGenericVector)model2).getGenericElement("verification", false);
                    }
                    this.encodeSchema(encoder);
                    Schema schema = encoder.createSchema();
                    model = this.encode(schema);
                    if (verification == null) break block8;
                    RDoubleVector precision = verification.getDoubleElement("precision");
                    RDoubleVector zeroThreshold = verification.getDoubleElement("zeroThreshold");
                    data = new VerificationMap((Double)precision.asScalar(), (Double)zeroThreshold.asScalar());
                    RGenericVector activeValues = verification.getGenericElement("active_values");
                    RGenericVector targetValues = verification.getGenericElement("target_values", false);
                    outputValues = verification.getGenericElement("output_values", false);
                    if (activeValues != null) {
                        data.putInputData(this.encodeActiveValues(activeValues));
                    }
                    if (targetValues == null || outputValues != null) break block9;
                    ScalarLabel scalarLabel = (ScalarLabel)schema.getLabel();
                    String name = scalarLabel.getName();
                    Set verificationFields = data.keySet();
                    Iterator verificationFieldIt = verificationFields.iterator();
                    while (verificationFieldIt.hasNext()) {
                        VerificationField verificationField = (VerificationField)verificationFieldIt.next();
                        if (!verificationField.requireField().equals(name)) continue;
                        verificationFieldIt.remove();
                    }
                    data.putResultData(this.encodeTargetValues(targetValues, scalarLabel));
                    break block10;
                }
                if (outputValues == null) break block8;
                data.putResultData(this.encodeOutputValues(outputValues));
            }
            model.setModelVerification(ModelUtil.createModelVerification((Map)data));
        }
        PMML pmml = encoder.encodePMML(model);
        return pmml;
    }

    protected Map<VerificationField, List<?>> encodeActiveValues(RGenericVector dataFrame) {
        return ModelConverter.encodeVerificationData(dataFrame);
    }

    protected Map<VerificationField, List<?>> encodeTargetValues(RGenericVector dataFrame, ScalarLabel scalarLabel) {
        List<RExp> columns = dataFrame.getValues();
        String name = scalarLabel.getName();
        return ModelConverter.encodeVerificationData(columns, Collections.singletonList(name));
    }

    protected Map<VerificationField, List<?>> encodeOutputValues(RGenericVector dataFrame) {
        return ModelConverter.encodeVerificationData(dataFrame);
    }

    protected static Map<VerificationField, List<?>> encodeVerificationData(RGenericVector dataFrame) {
        List<RExp> columns = dataFrame.getValues();
        RStringVector columnNames = dataFrame.names();
        return ModelConverter.encodeVerificationData(columns, columnNames.getDequotedValues());
    }

    protected static Map<VerificationField, List<?>> encodeVerificationData(List<? extends RExp> columns, List<String> names) {
        LinkedHashMap result = new LinkedHashMap();
        for (int i = 0; i < columns.size(); ++i) {
            List<String> values;
            String name = names.get(i);
            RVector column = (RVector)columns.get(i);
            if (column instanceof RDoubleVector) {
                Function<Double, Double> function = new Function<Double, Double>(){

                    public Double apply(Double value) {
                        if (value.isNaN()) {
                            return null;
                        }
                        return value;
                    }
                };
                values = Lists.transform(column.getValues(), (Function)function);
            } else if (column instanceof RFactorVector) {
                RFactorVector factor = (RFactorVector)column;
                values = factor.getFactorValues();
            } else {
                values = column.getValues();
            }
            VerificationField verificationField = ModelUtil.createVerificationField((String)name);
            result.put(verificationField, values);
        }
        return result;
    }

    private static class VerificationMap
    extends LinkedHashMap<VerificationField, List<?>> {
        private Double precision = null;
        private Double zeroThreshold = null;

        public VerificationMap(Double precision, Double zeroThreshold) {
            this.setPrecision(precision);
            this.setZeroThreshold(zeroThreshold);
        }

        public void putInputData(Map<VerificationField, List<?>> map) {
            this.putAll(map);
        }

        public void putResultData(Map<VerificationField, List<?>> map) {
            Double precision = this.getPrecision();
            Double zeroThreshold = this.getZeroThreshold();
            Set<VerificationField> verificationFields = map.keySet();
            for (VerificationField verificationField : verificationFields) {
                verificationField.setPrecision((Number)precision).setZeroThreshold((Number)zeroThreshold);
            }
            this.putAll(map);
        }

        public double getPrecision() {
            return this.precision;
        }

        private void setPrecision(double precision) {
            this.precision = precision;
        }

        public double getZeroThreshold() {
            return this.zeroThreshold;
        }

        private void setZeroThreshold(double zeroThreshold) {
            this.zeroThreshold = zeroThreshold;
        }
    }
}

