## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(mmtdiff)

## ----univariate---------------------------------------------------------------
# X1 ~ t(mu=0, sigma=1, nu=10)
# X2 ~ t(mu=0, sigma=1.5, nu=15)
result <- mm_tdiff_univariate(
  mu1 = 0, sigma1 = 1, nu1 = 10,
  mu2 = 0, sigma2 = 1.5, nu2 = 15
)

print(result)

# The difference Z = X1 - X2 is approximately:
# Z ~ t(mu_diff, sigma_star^2, nu_star)

## ----distributions------------------------------------------------------------
# Probability that difference is negative
p_negative <- ptdiff(0, result)
print(paste("P(X1 - X2 < 0) =", round(p_negative, 4)))

# 95% confidence interval for the difference
ci_95 <- qtdiff(c(0.025, 0.975), result)
print(paste("95% CI:", round(ci_95[1], 3), "to", round(ci_95[2], 3)))

# Generate random samples
samples <- rtdiff(1000, result)
hist(samples, breaks = 30, main = "Simulated Difference Distribution",
     xlab = "X1 - X2", probability = TRUE)

# Overlay theoretical density
x_seq <- seq(min(samples), max(samples), length.out = 100)
lines(x_seq, dtdiff(x_seq, result), col = "red", lwd = 2)

## ----multivariate-------------------------------------------------------------
result_multi <- mm_tdiff_multivariate_independent(
  mu1 = c(0, 1, 2),
  sigma1 = c(1, 1.5, 2),
  nu1 = c(10, 12, 15),
  mu2 = c(0, 0, 0),
  sigma2 = c(1.2, 1, 1.8),
  nu2 = c(15, 20, 25)
)

print(result_multi)

