/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class LocalLevel {
    public static int dim() {
        return 1;
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    public static StateComponent stateComponent(double var) {
        return new StateComponent(new Initialization(var, Double.NaN), new Dynamics(var));
    }

    public static StateComponent stateComponent(double var, double initialValue) {
        return new StateComponent(new Initialization(var, initialValue), new Dynamics(var));
    }

    @Generated
    private LocalLevel() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Initialization
    implements ISsfInitialization {
        final double var;
        final double initialValue;

        Initialization(double var, double initialValue) {
            this.var = var;
            this.initialValue = initialValue;
        }

        Initialization(double var) {
            this.var = var;
            this.initialValue = Double.NaN;
        }

        @Override
        public int getStateDim() {
            return 1;
        }

        @Override
        public boolean isDiffuse() {
            return Double.isNaN(this.initialValue);
        }

        @Override
        public int getDiffuseDim() {
            return Double.isNaN(this.initialValue) ? 1 : 0;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            if (Double.isNaN(this.initialValue)) {
                b.set(0, 0, 1.0);
            }
        }

        @Override
        public void a0(DataBlock a0) {
            if (Double.isFinite(this.initialValue)) {
                a0.set(0, this.initialValue);
            }
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            pf0.set(0, 0, this.var);
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            if (Double.isNaN(this.initialValue)) {
                pi0.set(0, 0, 1.0);
            }
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final double var;
        private final double std;

        Dynamics(double var) {
            this.var = var;
            this.std = var <= 0.0 ? 0.0 : Math.sqrt(var);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.set(0, 0, this.var);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public void S(int pos, FastMatrix sm) {
            sm.set(0, 0, this.std);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.add(0, this.std * u.get(0));
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.set(0, this.std * x.get(0));
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.set(0, 0, 1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
        }

        @Override
        public void TVT(int pos, FastMatrix v) {
        }

        @Override
        public void XT(int pos, DataBlock x) {
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(0, 0, this.var);
        }
    }
}

