/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.dictionaries;

import java.util.stream.Stream;

public interface Dictionary {
    public static final char SEP = '.';

    public static String fullName(String name, EntryType type) {
        return switch (type.ordinal()) {
            case 1 -> name + "(?)";
            case 2 -> name + "(*)";
            default -> name;
        };
    }

    public Stream<? extends Entry> entries();

    default public Stream<String> keys() {
        return this.entries().map(item -> item.getName());
    }

    default public Stream<String> keys(Class tclass) {
        return this.entries().filter(item -> tclass.isAssignableFrom(item.getClass())).map(item -> item.getName());
    }

    public static String concatenate(String ... st) {
        if (st == null) {
            throw new NullPointerException("st is marked non-null but is null");
        }
        if (st.length == 1) {
            return st[0];
        }
        StringBuilder builder = new StringBuilder();
        builder.append(st[0]);
        for (int i = 1; i < st.length; ++i) {
            builder.append('.').append(st[i]);
        }
        return builder.toString();
    }

    public static enum EntryType {
        Normal,
        Parametric,
        Array;

    }

    public static interface Entry {
        public String getName();

        public String getDescription();

        public String getDetail();

        public Class getOutputClass();

        public EntryType getType();

        default public String fullName() {
            return Dictionary.fullName(this.getName(), this.getType());
        }

        default public String display() {
            return this.fullName() + '\t' + this.getDescription() + '\t' + this.getOutputClass().getCanonicalName();
        }
    }
}

