/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.neural_network.NeuralInputs;
import org.dmg.pmml.neural_network.NeuralLayer;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.neural_network.NeuralOutputs;
import org.dmg.pmml.neural_network.Neuron;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.FortranMatrixUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.neural_network.NeuralNetworkUtil;
import org.jpmml.rexp.DecorationUtil;
import org.jpmml.rexp.Formula;
import org.jpmml.rexp.FormulaUtil;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.ModelFrameFormulaContext;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RStringVector;

public class ElmConverter
extends ModelConverter<RGenericVector> {
    public ElmConverter(RGenericVector elm) {
        super(elm);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector elm = (RGenericVector)this.getObject();
        RGenericVector model = DecorationUtil.getGenericElement(elm, "model");
        RExp terms = model.getAttribute("terms");
        RStringVector columns = terms.getStringAttribute("columns");
        ModelFrameFormulaContext context = new ModelFrameFormulaContext(model);
        Formula formula = FormulaUtil.createFormula(terms, context, encoder);
        FormulaUtil.setLabel(formula, terms, null, encoder);
        List<String> names = FormulaUtil.removeSpecialSymbol(columns.getValues(), "(Intercept)", 0);
        FormulaUtil.addFeatures(formula, names, true, encoder);
    }

    public NeuralNetwork encodeModel(Schema schema) {
        RGenericVector elm = (RGenericVector)this.getObject();
        RDoubleVector inpweight = elm.getDoubleElement("inpweight");
        RDoubleVector biashid = elm.getDoubleElement("biashid");
        RDoubleVector outweight = elm.getDoubleElement("outweight");
        RStringVector actfun = elm.getStringElement("actfun");
        RDoubleVector nhid = elm.getDoubleElement("nhid");
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        switch ((String)actfun.asScalar()) {
            case "purelin": {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        NeuralInputs neuralInputs = NeuralNetworkUtil.createNeuralInputs((List)features, (DataType)DataType.DOUBLE);
        List entities = neuralInputs.getNeuralInputs();
        ArrayList<NeuralLayer> neuralLayers = new ArrayList<NeuralLayer>(2);
        NeuralLayer hiddenNeuralLayer = new NeuralLayer();
        int rows = ValueUtil.asInt((Number)((Number)nhid.asScalar()));
        int columns = features.size();
        for (int row = 0; row < rows; ++row) {
            List weights = FortranMatrixUtil.getRow(inpweight.getValues(), (int)rows, (int)columns, (int)row);
            Double bias = !biashid.isEmpty() ? biashid.getValue(row) : null;
            Neuron neuron = NeuralNetworkUtil.createNeuron((List)entities, (List)weights, (Number)bias).setId("hidden/" + String.valueOf(row + 1));
            hiddenNeuralLayer.addNeurons(new Neuron[]{neuron});
        }
        neuralLayers.add(hiddenNeuralLayer);
        entities = hiddenNeuralLayer.getNeurons();
        NeuralLayer outputNeuralLayer = new NeuralLayer();
        columns = 1;
        for (int column = 0; column < columns; ++column) {
            List weights = FortranMatrixUtil.getColumn(outweight.getValues(), (int)rows, (int)columns, (int)column);
            Number bias = null;
            Neuron neuron = NeuralNetworkUtil.createNeuron((List)entities, (List)weights, bias).setId("output/" + String.valueOf(column + 1));
            outputNeuralLayer.addNeurons(new Neuron[]{neuron});
        }
        neuralLayers.add(outputNeuralLayer);
        entities = outputNeuralLayer.getNeurons();
        NeuralOutputs neuralOutputs = NeuralNetworkUtil.createRegressionNeuralOutputs((List)entities, (Label)((ContinuousLabel)label));
        NeuralNetwork neuralNetwork = new NeuralNetwork(MiningFunction.REGRESSION, NeuralNetwork.ActivationFunction.IDENTITY, ModelUtil.createMiningSchema((Label)label), neuralInputs, neuralLayers).setNeuralOutputs(neuralOutputs);
        return neuralNetwork;
    }
}

