## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 5
)
library(dplyr)
library(mccount)

## ----dong-example-------------------------------------------------------------
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2)
 )

# Calculating MCC using both estimators
mcc_eq <- mcc(
  df,
  id_var = "id",
  time_var = "time",
  cause_var = "cause",
  method = "equation"
)

mcc_sci <- mcc(
  df,
  id_var = "id",
  time_var = "time",
  cause_var = "cause",
  method = "sci"
)

## -----------------------------------------------------------------------------
# Dong-Yasui estimator
mcc_details(mcc_eq)

# Sum of cumulative incidences estimator
mcc_details(mcc_sci)

