/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractBinSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public class ComplementSet
extends AbstractBinSetSConstraint {
    int minvalue;
    int maxvalue;

    public ComplementSet(SetVar v0, SetVar v1) {
        super(v0, v1);
        this.minvalue = Math.min(v0.getEnveloppeInf(), v1.getEnveloppeInf());
        this.maxvalue = Math.max(v0.getEnveloppeSup(), v1.getEnveloppeSup());
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiated() && this.v1.isInstantiated()) {
            if (!this.isSatisfied()) {
                this.fail();
            }
        } else {
            int val;
            DisposableIntIterator itker = this.v0.getDomain().getKernelIterator();
            while (itker.hasNext()) {
                val = itker.next();
                this.v1.remFromEnveloppe(val, this, true);
            }
            itker = this.v1.getDomain().getKernelIterator();
            while (itker.hasNext()) {
                val = itker.next();
                this.v0.remFromEnveloppe(val, this, true);
            }
            for (val = this.minvalue; val <= this.maxvalue; ++val) {
                if (this.v0.isInDomainEnveloppe(val) || this.v1.isInDomainEnveloppe(val)) continue;
                this.fail();
            }
        }
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        SetVar ov = varIdx == 0 ? this.v1 : this.v0;
        ov.remFromEnveloppe(x, this, true);
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        SetVar ov = varIdx == 0 ? this.v1 : this.v0;
        ov.addToKernel(x, this, true);
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    @Override
    public boolean isSatisfied() {
        for (int val = this.minvalue; val <= this.maxvalue; ++val) {
            if ((!this.v0.isInDomainKernel(val) || !this.v1.isInDomainKernel(val)) && (this.v0.isInDomainKernel(val) || this.v1.isInDomainKernel(val))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "complement(" + this.v0 + ") == " + this.v1;
    }

    @Override
    public String pretty() {
        return "complement(" + this.v0.pretty() + ") == " + this.v1.pretty();
    }
}

