/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.x11;

import jdplus.toolkit.base.api.data.DoubleSeq;

public final class MsrTable {
    private static final double[] C = new double[]{1.0, 1.02584, 1.01779, 1.01383, 1.0, 3.0, 1.55291, 1.30095};
    private final double[] rs;
    private final double[] ri;
    private final int[] n;

    public static MsrTable of(DoubleSeq ss, DoubleSeq is, int period, int firstPeriod, boolean mul) {
        double[] rs = new double[period];
        double[] ri = new double[period];
        int[] n = new int[period];
        int m = ss.length();
        for (int i = 0; i < period; ++i) {
            int start = i >= firstPeriod ? i - firstPeriod : period + i - firstPeriod;
            double ci = 0.0;
            double cs = 0.0;
            int nc = 0;
            int jprev = start;
            for (int j = start + period; j < m; j += period) {
                double x0 = is.get(jprev);
                double x1 = is.get(j);
                double d = x1 - x0;
                if (mul) {
                    d /= x0;
                }
                ci += Math.abs(d);
                x0 = ss.get(jprev);
                x1 = ss.get(j);
                d = x1 - x0;
                if (mul) {
                    d /= x0;
                }
                cs += Math.abs(d);
                ++nc;
                jprev = j;
            }
            ri[i] = ci / (double)nc * MsrTable.fis(nc);
            rs[i] = cs / (double)nc * MsrTable.cs(nc);
            n[i] = nc;
        }
        return new MsrTable(rs, ri, n);
    }

    private static double cs(int n) {
        if (n < 2) {
            return 1.0;
        }
        if (n < 6) {
            return C[n + 2];
        }
        return (double)n * 1.732051 / (8.485281 + (double)(n - 6) * 1.732051);
    }

    private static double fis(int n) {
        if (n < 2) {
            return 1.0;
        }
        if (n < 6) {
            return C[n - 2];
        }
        return (double)n * 12.247449 / (73.239334 + (double)(n - 6) * 12.247449);
    }

    private MsrTable(double[] rs, double[] ri, int[] n) {
        this.rs = rs;
        this.ri = ri;
        this.n = n;
    }

    public int getCount() {
        return this.ri.length;
    }

    public double getGlobalMsr() {
        double gri = 0.0;
        double grs = 0.0;
        for (int i = 0; i < this.ri.length; ++i) {
            gri += this.ri[i] * (double)this.n[i];
            grs += this.rs[i] * (double)this.n[i];
        }
        return gri / grs;
    }

    public double[] getMeanIrregularEvolutions() {
        return this.ri;
    }

    public double[] getMeanSeasonalEvolutions() {
        return this.rs;
    }

    public double getMsr(int idx) {
        return this.ri[idx] / this.rs[idx];
    }
}

