/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.calendars;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarDefinition;
import jdplus.toolkit.base.xml.legacy.calendars.CalendarAdapter;
import jdplus.toolkit.base.xml.legacy.calendars.CalendarAdapterLoader;
import jdplus.toolkit.base.xml.legacy.calendars.XmlCalendar;

public class CalendarAdapters {
    private static final AtomicReference<CalendarAdapters> defadapters = new AtomicReference();
    private final List<CalendarAdapter> adapters = new ArrayList<CalendarAdapter>();

    public static final CalendarAdapters getDefault() {
        defadapters.compareAndSet(null, CalendarAdapters.make());
        return defadapters.get();
    }

    public CalendarAdapters() {
        this.load();
    }

    public static final void setDefault(CalendarAdapters adapters) {
        defadapters.set(adapters);
    }

    private static CalendarAdapters make() {
        CalendarAdapters adapters = new CalendarAdapters();
        return adapters;
    }

    private void load() {
        this.adapters.addAll(new CalendarAdapterLoader().get());
    }

    public List<Class> getXmlClasses() {
        return this.adapters.stream().map(adapter -> adapter.getXmlType()).collect(Collectors.toList());
    }

    public CalendarDefinition unmarshal(XmlCalendar xvar) {
        for (CalendarAdapter adapter : this.adapters) {
            if (!adapter.getXmlType().isInstance(xvar)) continue;
            try {
                return (CalendarDefinition)adapter.unmarshal(xvar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public XmlCalendar marshal(CalendarDefinition ivar) {
        for (CalendarAdapter adapter : this.adapters) {
            if (!adapter.getValueType().isInstance(ivar)) continue;
            try {
                return (XmlCalendar)adapter.marshal(ivar);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }
}

