/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import standalone_spreadsheet.org.dhatim.fastexcel.XmlEscapeHelper;

class Writer {
    private final OutputStream os;
    private final StringBuilder sb;

    Writer(OutputStream os) {
        this.os = os;
        this.sb = new StringBuilder(524288);
    }

    Writer append(String s) throws IOException {
        return this.append(s, false);
    }

    Writer appendEscaped(String s) throws IOException {
        return this.append(s, true);
    }

    private Writer append(String s, boolean escape) throws IOException {
        if (escape) {
            this.sb.append(XmlEscapeHelper.escape(s));
        } else {
            this.sb.append(s);
        }
        this.check();
        return this;
    }

    private void check() throws IOException {
        if (this.sb.capacity() - this.sb.length() < 1024) {
            this.flush();
        }
    }

    Writer append(char c) throws IOException {
        this.sb.append(c);
        this.check();
        return this;
    }

    Writer append(int n) throws IOException {
        this.sb.append(n);
        this.check();
        return this;
    }

    Writer append(long n) throws IOException {
        this.sb.append(n);
        this.check();
        return this;
    }

    Writer append(double n) throws IOException {
        this.sb.append(n);
        this.check();
        return this;
    }

    void flush() throws IOException {
        this.os.write(this.sb.toString().getBytes(StandardCharsets.UTF_8));
        this.sb.setLength(0);
    }
}

