/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.IOException;
import standalone_spreadsheet.org.dhatim.fastexcel.DataValidation;
import standalone_spreadsheet.org.dhatim.fastexcel.DataValidationErrorStyle;
import standalone_spreadsheet.org.dhatim.fastexcel.Range;
import standalone_spreadsheet.org.dhatim.fastexcel.Writer;

public class ListDataValidation
implements DataValidation {
    private static final String TYPE = "list";
    private final Range range;
    private final Range listRange;
    private boolean allowBlank = true;
    private boolean showDropdown = true;
    private DataValidationErrorStyle errorStyle = DataValidationErrorStyle.INFORMATION;
    private boolean showErrorMessage = false;
    private String errorTitle;
    private String error;

    ListDataValidation(Range range, Range listRange) {
        this.range = range;
        this.listRange = listRange;
    }

    public ListDataValidation allowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
        return this;
    }

    public ListDataValidation showDropdown(boolean showDropdown) {
        this.showDropdown = showDropdown;
        return this;
    }

    public ListDataValidation errorStyle(DataValidationErrorStyle errorStyle) {
        this.errorStyle = errorStyle;
        return this;
    }

    public ListDataValidation showErrorMessage(boolean showErrorMessage) {
        this.showErrorMessage = showErrorMessage;
        return this;
    }

    public ListDataValidation errorTitle(String errorTitle) {
        this.errorTitle = errorTitle;
        return this;
    }

    public ListDataValidation error(String error) {
        this.error = error;
        return this;
    }

    @Override
    public void write(Writer w) throws IOException {
        w.append("<dataValidation sqref=\"").append(this.range.toString()).append("\" type=\"").append(TYPE).append("\" allowBlank=\"").append(String.valueOf(this.allowBlank)).append("\" showDropDown=\"").append(String.valueOf(!this.showDropdown)).append("\" errorStyle=\"").append(this.errorStyle.toString()).append("\" showErrorMessage=\"").append(String.valueOf(this.showErrorMessage)).append("\" errorTitle=\"").append(this.errorTitle).append("\" error=\"").append(this.error).append("\"><formula1>'").appendEscaped(this.listRange.getWorksheet().getName()).append("'!").append(this.listRange.toAbsoluteString()).append("</formula1></dataValidation>");
    }
}

