/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.internal.io.text;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import standalone_spreadsheet.internal.io.text.FileSystemExceptions;
import standalone_spreadsheet.nbbrd.io.WrappedIOException;

public final class LegacyFiles {
    @NonNull
    public static InputStream newInputStream(@NonNull File source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return Files.newInputStream(FileSystemExceptions.checkSource(LegacyFiles.toPathOrRaiseIO(source)), new OpenOption[0]);
    }

    @NonNull
    public static OutputStream newOutputStream(@NonNull File target) throws IOException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return Files.newOutputStream(FileSystemExceptions.checkTarget(LegacyFiles.toPathOrRaiseIO(target)), new OpenOption[0]);
    }

    @NonNull
    public static Path toPathOrRaiseIO(@NonNull File source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try {
            return source.toPath();
        }
        catch (InvalidPathException ex) {
            throw WrappedIOException.wrap(ex);
        }
    }

    public static String toSystemId(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return file.toURI().toASCIIString();
    }

    public static @Nullable File fromSystemId(@NonNull String systemId) {
        if (systemId == null) {
            throw new NullPointerException("systemId is marked non-null but is null");
        }
        if (systemId.startsWith("file:/")) {
            try {
                return Paths.get(new URI(systemId)).toFile();
            }
            catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Generated
    private LegacyFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

