data{
  int N;                                 // number of patients who have been enrolled or in the enrollment process (N = M(T1)+1 in the paper)
  real<lower=0> t[N];                    // observed interarrival time zeta (the last one is administratively censored by T_1)
  real<lower=0> alpha;                              // alpha_mu in the paper
  real<lower=0> beta;                               // beta_mu in the paper
  int<lower=0, upper=1> status[N];       // status of enrollment (1 if already enrolled, 0 if administratively censored)
}

parameters{
  real<lower=0> mu;                       // rate parameter of the exponential distribution
}

model{
 mu ~ gamma(alpha,beta);
    for(i in 1:N){
    if(status[i] == 1){
      target += exponential_lpdf(t[i]|mu);
    } else if(status[i] == 0){
      target += exponential_lccdf(t[i]|mu);
    }
    }
}
