/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import java.util.ListIterator;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiLabelLearner;
import moa.classifiers.core.driftdetection.ChangeDetector;
import moa.classifiers.rules.core.anomalydetection.AnomalyDetector;
import moa.classifiers.rules.core.anomalydetection.OddsRatioScore;
import moa.classifiers.rules.featureranking.FeatureRanking;
import moa.classifiers.rules.featureranking.NoFeatureRanking;
import moa.classifiers.rules.featureranking.messages.ChangeDetectedMessage;
import moa.classifiers.rules.multilabel.attributeclassobservers.NominalStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NumericStatisticsObserver;
import moa.classifiers.rules.multilabel.core.MultiLabelRule;
import moa.classifiers.rules.multilabel.core.MultiLabelRuleSet;
import moa.classifiers.rules.multilabel.core.ObserverMOAObject;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.classifiers.rules.multilabel.core.voting.ErrorWeightedVoteMultiLabel;
import moa.classifiers.rules.multilabel.errormeasurers.MultiLabelErrorMeasurer;
import moa.classifiers.rules.multilabel.functions.MultiLabelPerceptronClassification;
import moa.classifiers.rules.multilabel.inputselectors.InputAttributesSelector;
import moa.classifiers.rules.multilabel.inputselectors.SelectAllInputs;
import moa.classifiers.rules.multilabel.instancetransformers.NoInstanceTransformation;
import moa.classifiers.rules.multilabel.outputselectors.OutputAttributesSelector;
import moa.classifiers.rules.multilabel.outputselectors.SelectAllOutputs;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.options.ClassOption;

public abstract class AMRulesMultiLabelLearner
extends AbstractMultiLabelLearner
implements MultiLabelLearner {
    private static final long serialVersionUID = 1L;
    protected MultiLabelRuleSet ruleSet;
    protected MultiLabelRule defaultRule;
    protected int ruleNumberID = 1;
    protected double[] statistics;
    protected ObserverMOAObject observer;
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "Hoeffding Bound Parameter. The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Hoeffding Bound Parameter. Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "Hoeffding Bound Parameter. The number of instances a leaf should observe between split attempts.", 200, 1, Integer.MAX_VALUE);
    public ClassOption learnerOption;
    public FlagOption unorderedRulesOption = new FlagOption("setUnorderedRulesOn", 'U', "unorderedRules.");
    public FlagOption dropOldRuleAfterExpansionOption = new FlagOption("dropOldRuleAfterExpansion", 'D', "Drop old rule if it expanded (by default the rule is kept for the set of outputs not selected for expansion.)");
    public ClassOption changeDetector = new ClassOption("changeDetector", 'H', "Change Detector.", ChangeDetector.class, "PageHinkleyDM -d 0.05 -l 35.0");
    public ClassOption anomalyDetector = new ClassOption("anomalyDetector", 'A', "Anomaly Detector.", AnomalyDetector.class, OddsRatioScore.class.getName());
    public ClassOption splitCriterionOption;
    public ClassOption errorMeasurerOption;
    public ClassOption weightedVoteOption;
    public ClassOption numericObserverOption = new ClassOption("numericObserver", 'y', "Numeric observer.", NumericStatisticsObserver.class, "MultiLabelBSTree");
    public ClassOption nominalObserverOption = new ClassOption("nominalObserver", 'z', "Nominal observer.", NominalStatisticsObserver.class, "MultiLabelNominalAttributeObserver");
    public IntOption VerbosityOption = new IntOption("verbosity", 'v', "Output Verbosity Control Level. 1 (Less) to 5 (More)", 1, 1, 5);
    public ClassOption outputSelectorOption = new ClassOption("outputSelector", 'O', "Output attributes selector", OutputAttributesSelector.class, SelectAllOutputs.class.getName());
    public ClassOption inputSelectorOption = new ClassOption("inputSelector", 'I', "Input attributes selector", InputAttributesSelector.class, SelectAllInputs.class.getName());
    public IntOption randomSeedOption = new IntOption("randomSeedOption", 'r', "randomSeedOption", 1, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public ClassOption featureRankingOption = new ClassOption("featureRanking", 'F', "Feature ranking algorithm.", FeatureRanking.class, NoFeatureRanking.class.getName());
    private int nAttributes = 0;
    protected double attributesPercentage;
    private double numChangesDetected;
    private double numAnomaliesDetected;
    private double numInstances;
    private FeatureRanking featureRanking;

    public double getAttributesPercentage() {
        return this.attributesPercentage;
    }

    public void setAttributesPercentage(double attributesPercentage) {
        this.attributesPercentage = attributesPercentage;
    }

    public AMRulesMultiLabelLearner() {
        ((AbstractMultiLabelLearner)this).randomSeedOption = this.randomSeedOption;
        this.attributesPercentage = 100.0;
    }

    public AMRulesMultiLabelLearner(double attributesPercentage) {
        this();
        this.attributesPercentage = attributesPercentage;
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance inst) {
        ErrorWeightedVoteMultiLabel vote = this.getVotes(inst);
        Prediction pred = vote.getPrediction();
        if (vote != null) {
            if ((MultiLabelLearner)this.getPreparedClassOption(this.learnerOption) instanceof MultiLabelPerceptronClassification) {
                for (int i = 0; i < pred.size(); ++i) {
                    pred.setVote(i, 0, pred.getVote(i, 0) < 0.5 ? 1.0 : 0.0);
                }
            }
            return pred;
        }
        return null;
    }

    public ErrorWeightedVoteMultiLabel getVotes(MultiLabelInstance instance) {
        ErrorWeightedVoteMultiLabel errorWeightedVote = this.newErrorWeightedVote();
        this.VerboseToConsole(instance);
        for (MultiLabelRule rule : this.ruleSet) {
            if (!rule.isCovering(instance)) continue;
            Prediction vote = rule.getPredictionForInstance(instance);
            if (vote != null) {
                double[] errors = rule.getCurrentErrors();
                if (errors == null) {
                    errors = this.defaultRuleErrors(vote);
                }
                this.debug("Rule No" + rule.getRuleNumberID() + " Vote: " + vote.toString() + " Error: " + errors + " Y: " + instance.classValue(), 3);
                errorWeightedVote.addVote(vote, errors);
            }
            if (this.unorderedRulesOption.isSet()) continue;
            break;
        }
        if (!errorWeightedVote.coversAllOutputs()) {
            Prediction defaultVote;
            Prediction vote = errorWeightedVote.getPrediction();
            if (vote == null) {
                vote = new MultiLabelPrediction(instance.numberOutputTargets());
            }
            if ((defaultVote = this.defaultRule.getPredictionForInstance(instance)) != null) {
                double[] defaultErrors = this.defaultRule.getCurrentErrors();
                if (defaultErrors == null) {
                    defaultErrors = this.defaultRuleErrors(defaultVote);
                }
                double[] fixErrors = new double[vote.numOutputAttributes()];
                MultiLabelPrediction fixVote = new MultiLabelPrediction(vote.numOutputAttributes());
                for (int i = 0; i < vote.numOutputAttributes(); ++i) {
                    if (vote.hasVotesForAttribute(i)) continue;
                    fixVote.setVotes(i, defaultVote.getVotes(i));
                    fixErrors[i] = defaultErrors[i];
                }
                errorWeightedVote.addVote(fixVote, fixErrors);
                this.debug("Default Rule Vote " + defaultVote.toString() + "\n Error " + defaultErrors + "  Y: " + instance, 3);
            }
        }
        errorWeightedVote.computeWeightedVote();
        return errorWeightedVote;
    }

    protected double[] defaultRuleErrors(Prediction vote) {
        double[] errors = new double[vote.numOutputAttributes()];
        for (int i = 0; i < vote.numOutputAttributes(); ++i) {
            if (!vote.hasVotesForAttribute(i)) continue;
            errors[i] = Double.MAX_VALUE;
        }
        return errors;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance instance) {
        if (this.nAttributes == 0) {
            this.nAttributes = instance.numInputAttributes();
        }
        this.numInstances += instance.weight();
        this.debug("Train", 3);
        this.debug("N\u00ba instance " + this.numInstances + " - " + instance.toString(), 3);
        boolean rulesCoveringInstance = false;
        ListIterator<MultiLabelRule> ruleIterator = this.ruleSet.listIterator();
        while (ruleIterator.hasNext()) {
            MultiLabelRule rule = (MultiLabelRule)ruleIterator.next();
            if (!rule.isCovering(instance)) continue;
            rulesCoveringInstance = true;
            if (!rule.updateAnomalyDetection(instance)) {
                if (rule.updateChangeDetection(instance)) {
                    this.debug("I) Drift Detected. Exa. : " + this.numInstances + " (" + rule.getWeightSeenSinceExpansion() + ") Remove Rule: " + rule.getRuleNumberID(), 1);
                    ruleIterator.remove();
                    rule.notifyAll(new ChangeDetectedMessage());
                    this.numChangesDetected += instance.weight();
                } else {
                    rule.trainOnInstance(instance);
                    if (rule.getWeightSeenSinceExpansion() % (double)this.gracePeriodOption.getValue() == 0.0 && rule.tryToExpand(this.splitConfidenceOption.getValue(), this.tieThresholdOption.getValue())) {
                        MultiLabelRule otherMultiLabelRule = rule.getNewRuleFromOtherOutputs();
                        if (!this.dropOldRuleAfterExpansionOption.isSet() && rule.hasNewRuleFromOtherOutputs()) {
                            rule.clearOtherOutputs();
                            otherMultiLabelRule.setRuleNumberID(++this.ruleNumberID);
                            this.setRuleOptions(otherMultiLabelRule);
                            ruleIterator.add(otherMultiLabelRule);
                            if (this.observer != null) {
                                otherMultiLabelRule.addObserver(this.observer);
                            }
                        }
                        this.setRuleOptions(rule);
                        this.debug("Rule Expanded:", 2);
                        this.debug(rule.toString(), 2);
                    }
                }
            } else {
                this.debug("Anomaly Detected: " + this.numInstances + " Rule: " + rule.getRuleNumberID(), 1);
                this.numAnomaliesDetected += instance.weight();
            }
            if (this.unorderedRulesOption.isSet()) continue;
            break;
        }
        if (!rulesCoveringInstance) {
            this.defaultRule.trainOnInstance(instance);
            if (this.defaultRule.getWeightSeenSinceExpansion() % (double)this.gracePeriodOption.getValue() == 0.0) {
                this.debug("Nr. examples " + this.defaultRule.getWeightSeenSinceExpansion(), 4);
                if (this.defaultRule.tryToExpand(this.splitConfidenceOption.getValue(), this.tieThresholdOption.getValue())) {
                    MultiLabelRule newDefaultRule = this.defaultRule.getNewRuleFromOtherBranch();
                    newDefaultRule.setRuleNumberID(++this.ruleNumberID);
                    this.setRuleOptions(newDefaultRule);
                    this.setRuleOptions(this.defaultRule);
                    this.ruleSet.add(this.defaultRule);
                    this.debug("Default rule expanded! New Rule:", 2);
                    this.debug(this.defaultRule.toString(), 2);
                    this.debug("New default rule:", 3);
                    this.debug(newDefaultRule.toString(), 3);
                    this.defaultRule = newDefaultRule;
                    if (this.observer != null) {
                        this.defaultRule.addObserver(this.observer);
                    }
                }
            }
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        Measurement[] m = null;
        Measurement[] mNoFeatureRanking = new Measurement[]{new Measurement("anomaly detections", this.numAnomaliesDetected), new Measurement("change detections", this.numChangesDetected), new Measurement("rules (number)", this.ruleSet.size() + 1), new Measurement("Avg #inputs/rule", this.getAverageInputs()), new Measurement("Avg #outputs/rule", this.getAverageOutputs())};
        if (this.featureRanking instanceof NoFeatureRanking) {
            m = mNoFeatureRanking;
        } else {
            m = new Measurement[mNoFeatureRanking.length + this.nAttributes];
            for (int i = 0; i < mNoFeatureRanking.length; ++i) {
                m[i] = mNoFeatureRanking[i];
            }
            DoubleVector rankings = this.featureRanking.getFeatureRankings();
            for (int i = 0; i < this.nAttributes; ++i) {
                m[i + mNoFeatureRanking.length] = new Measurement("Attribute" + i, rankings.getValue(i));
            }
        }
        return m;
    }

    protected double getAverageInputs() {
        int[] aux;
        double avg = 0.0;
        int ct = 0;
        if (this.ruleSet.size() > 0) {
            for (MultiLabelRule r : this.ruleSet) {
                int[] aux2 = r.getInputsCovered();
                if (aux2 == null) continue;
                avg += (double)aux2.length;
                ++ct;
            }
        }
        if ((aux = this.defaultRule.getInputsCovered()) != null) {
            avg += (double)aux.length;
            ++ct;
        }
        if (ct > 0) {
            avg /= (double)ct;
        }
        return avg;
    }

    protected double getAverageOutputs() {
        int[] aux;
        double avg = 0.0;
        int ct = 0;
        if (this.ruleSet.size() > 0) {
            for (MultiLabelRule r : this.ruleSet) {
                int[] aux2 = r.getOutputsCovered();
                if (aux2 == null) continue;
                avg += (double)aux2.length;
                ++ct;
            }
        }
        if ((aux = this.defaultRule.getOutputsCovered()) != null) {
            avg += (double)aux.length;
            ++ct;
        }
        if (ct > 0) {
            avg /= (double)ct;
        }
        return avg;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        if (!this.unorderedRulesOption.isSet()) {
            StringUtils.appendIndented(out, indent, "Method Ordered");
            StringUtils.appendNewline(out);
        } else {
            StringUtils.appendIndented(out, indent, "Method Unordered");
            StringUtils.appendNewline(out);
        }
        StringUtils.appendIndented(out, indent, "Number of Rules: " + (this.ruleSet.size() + 1));
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, "Default rule :");
        this.defaultRule.getDescription(out, indent);
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, "Rules in ruleSet:");
        StringUtils.appendNewline(out);
        for (MultiLabelRule rule : this.ruleSet) {
            rule.getDescription(out, indent);
            StringUtils.appendNewline(out);
        }
    }

    protected void debug(String string, int level) {
        if (this.VerbosityOption.getValue() >= level) {
            System.out.println(string);
        }
    }

    protected void VerboseToConsole(MultiLabelInstance inst) {
        if (this.VerbosityOption.getValue() >= 5) {
            System.out.println();
            System.out.println("I) Dataset: " + inst.dataset().getRelationName());
            if (!this.unorderedRulesOption.isSet()) {
                System.out.println("I) Method Ordered");
            } else {
                System.out.println("I) Method Unordered");
            }
        }
    }

    public void PrintRuleSet() {
        this.debug("Default rule :", 2);
        this.debug(this.defaultRule.toString(), 2);
        this.debug("Rules in ruleSet:", 2);
        for (MultiLabelRule rule : this.ruleSet) {
            this.debug(rule.toString(), 2);
        }
    }

    @Override
    public void resetLearningImpl() {
        this.defaultRule = this.newDefaultRule();
        this.classifierRandom.setSeed(this.randomSeed);
        MultiLabelLearner l = (MultiLabelLearner)((MultiLabelLearner)this.getPreparedClassOption(this.learnerOption)).copy();
        l.setRandomSeed(this.randomSeed);
        l.resetLearning();
        this.defaultRule.setLearner(l);
        this.defaultRule.setInstanceTransformer(new NoInstanceTransformation());
        this.setRuleOptions(this.defaultRule);
        this.ruleSet = new MultiLabelRuleSet();
        this.ruleNumberID = 1;
        this.statistics = null;
        this.featureRanking = (FeatureRanking)this.getPreparedClassOption(this.featureRankingOption);
        this.setObserver(this.featureRanking);
    }

    protected void setRuleOptions(MultiLabelRule rule) {
        rule.setSplitCriterion((MultiLabelSplitCriterion)((MultiLabelSplitCriterion)this.getPreparedClassOption(this.splitCriterionOption)).copy());
        rule.setChangeDetector(((ChangeDetector)this.getPreparedClassOption(this.changeDetector)).copy());
        rule.setAnomalyDetector(((AnomalyDetector)this.getPreparedClassOption(this.anomalyDetector)).copy());
        rule.setNumericObserverOption((NumericStatisticsObserver)((NumericStatisticsObserver)this.getPreparedClassOption(this.numericObserverOption)).copy());
        rule.setNominalObserverOption((NominalStatisticsObserver)((NominalStatisticsObserver)this.getPreparedClassOption(this.nominalObserverOption)).copy());
        rule.setErrorMeasurer((MultiLabelErrorMeasurer)((MultiLabelErrorMeasurer)this.getPreparedClassOption(this.errorMeasurerOption)).copy());
        rule.setOutputAttributesSelector((OutputAttributesSelector)((OutputAttributesSelector)this.getPreparedClassOption(this.outputSelectorOption)).copy());
        rule.setRandomGenerator(this.classifierRandom);
        rule.setAttributesPercentage(this.attributesPercentage);
        rule.setInputAttributesSelector((InputAttributesSelector)((InputAttributesSelector)this.getPreparedClassOption(this.inputSelectorOption)).copy());
    }

    protected abstract MultiLabelRule newDefaultRule();

    public ErrorWeightedVoteMultiLabel newErrorWeightedVote() {
        return (ErrorWeightedVoteMultiLabel)((Object)((ErrorWeightedVoteMultiLabel)this.getPreparedClassOption(this.weightedVoteOption)).copy());
    }

    @Override
    public void setRandomSeed(int randomSeed) {
        super.setRandomSeed(randomSeed);
        this.classifierRandom.setSeed(randomSeed);
    }

    public void setObserver(ObserverMOAObject observer) {
        this.observer = observer;
        this.defaultRule.addObserver(observer);
    }
}

