/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp;

import internal.toolkit.base.tsp.InternalTsProvider;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataSourceList;
import lombok.NonNull;

public interface HasDataSourceMutableList
extends HasDataSourceList {
    public boolean open(@NonNull DataSource var1) throws IllegalArgumentException;

    public boolean close(@NonNull DataSource var1) throws IllegalArgumentException;

    default public void closeAll() {
        this.getDataSources().forEach(this::close);
    }

    @NonNull
    public static HasDataSourceMutableList of(@NonNull String providerName, @NonNull Consumer<? super DataSource> cacheCleaner) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (cacheCleaner == null) {
            throw new NullPointerException("cacheCleaner is marked non-null but is null");
        }
        return new InternalTsProvider.DataSourceMutableListSupport(providerName, new LinkedHashSet<DataSource>(), cacheCleaner);
    }

    @NonNull
    public static HasDataSourceMutableList of(@NonNull String providerName) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        return HasDataSourceMutableList.of(providerName, InternalTsProvider.DO_NOTHING);
    }
}

