/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.real.RealConstantVariable;
import choco.kernel.model.variables.set.SetConstantVariable;
import gnu.trove.TDoubleObjectHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.HashMap;
import java.util.logging.Logger;

public final class ConstantFactory {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private static final TIntObjectHashMap<IntegerConstantVariable> INTEGER_MAP = new TIntObjectHashMap();
    private static final HashMap<int[], SetConstantVariable> SET_MAP = new HashMap();
    private static final TDoubleObjectHashMap<RealConstantVariable> REAL_MAP = new TDoubleObjectHashMap();

    protected ConstantFactory() {
    }

    public static IntegerConstantVariable getConstant(int value) {
        if (INTEGER_MAP.get(0) != null && INTEGER_MAP.get(0).getValue() != 0) {
            LOGGER.severe("$$$$$$$$$$$$$ ALARM $$$$$$$$$$$$$$$$$$$$$$$$$$");
            System.exit(-1589);
        }
        if (!INTEGER_MAP.containsKey(value)) {
            INTEGER_MAP.put(value, new IntegerConstantVariable(value));
        }
        return INTEGER_MAP.get(value);
    }

    public static SetConstantVariable getConstant(int[] values) {
        if (!SET_MAP.containsKey(values)) {
            SET_MAP.put(values, new SetConstantVariable(ConstantFactory.getConstant(values.length), values));
        }
        return SET_MAP.get(values);
    }

    public static RealConstantVariable getConstant(double value) {
        if (!REAL_MAP.containsKey(value)) {
            REAL_MAP.put(value, new RealConstantVariable(value));
        }
        return REAL_MAP.get(value);
    }
}

