/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.ComplexType;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.ComplexComputer;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import lombok.Generated;

public final class FilterUtility {
    static final double EPS = 1.0E-9;

    public static boolean checkRoots(Complex[] roots, double rmin) {
        if (roots == null || rmin < 0.0) {
            return true;
        }
        for (int i = 0; i < roots.length; ++i) {
            double n = roots[i].abs();
            if (!(1.0 / n >= rmin)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkRoots(DoubleSeq c, double rmin) {
        int nc = 1 + c.lastIndexOf(x -> x != 0.0);
        switch (nc) {
            case 0: {
                return true;
            }
            case 1: {
                double cabs = Math.abs(c.get(0));
                return cabs < rmin;
            }
            case 2: {
                double a = c.get(0);
                double b = c.get(1);
                double ro = a * a - 4.0 * b;
                if (ro > 0.0) {
                    double sro = Math.sqrt(ro);
                    double x0 = (-a + sro) / (2.0 * b);
                    double x1 = (-a - sro) / (2.0 * b);
                    return 1.0 / Math.abs(x0) < rmin && 1.0 / Math.abs(x1) < rmin;
                }
                return Math.sqrt(b) < rmin;
            }
        }
        double[] ctmp = new double[nc + 1];
        ctmp[0] = 1.0;
        c.copyTo(ctmp, 1);
        Polynomial p = Polynomial.ofInternal(ctmp);
        return FilterUtility.checkRoots(p.roots(), rmin);
    }

    public static boolean checkStability(DoubleSeq c) {
        int nc = c.length();
        if (nc == 0) {
            return true;
        }
        if (nc == 1) {
            return Math.abs(c.get(0)) < 1.0;
        }
        double[] coeff = c.toArray();
        double[] pat = new double[nc];
        double[] pu = new double[nc];
        for (int i = coeff.length - 1; i >= 0; --i) {
            pat[i] = coeff[i];
            if (Math.abs(pat[i]) >= 1.0) {
                return false;
            }
            for (int j = 0; j < i; ++j) {
                pu[j] = coeff[i - j - 1];
            }
            double den = 1.0 - pat[i] * pat[i];
            for (int j = 0; j < i / 2; ++j) {
                coeff[j] = (coeff[j] - pat[i] * pu[j]) / den;
                coeff[i - j - 1] = (coeff[i - j - 1] - pat[i] * pu[i - j - 1]) / den;
            }
            if (i % 2 == 0) continue;
            coeff[i / 2] = pu[i / 2] / (1.0 + pat[i]);
        }
        return true;
    }

    public static boolean checkStability(Polynomial p) {
        double c = p.get(0);
        if (c == 0.0) {
            return false;
        }
        double[] q = p.coefficients().toArray();
        if (c != 1.0) {
            int i = 1;
            while (i < q.length) {
                int n = i++;
                q[n] = q[n] / c;
            }
        }
        return FilterUtility.checkStability(DoubleSeq.of((double[])q, (int)1, (int)(q.length - 1)));
    }

    public static boolean stabilize(DoubleSeq.Mutable c, double rmin) {
        int nc = c.length();
        if (nc == 0) {
            return false;
        }
        if (nc == 1) {
            double c0 = c.get(0);
            double rabs = Math.abs(c0);
            if (rabs < rmin) {
                return false;
            }
            if (rabs > 1.0 / rmin) {
                c.set(0, 1.0 / c0);
            } else {
                c.set(0, c0 > 0.0 ? rmin - 1.0E-9 : -rmin + 1.0E-9);
            }
            return true;
        }
        double[] ctmp = new double[nc + 1];
        ctmp[0] = 1.0;
        c.copyTo(ctmp, 1);
        Polynomial p = Polynomial.of(ctmp);
        Polynomial sp = FilterUtility.stabilize(p, rmin);
        if (p != sp) {
            for (int i = 0; i < nc; ++i) {
                c.set(i, sp.get(1 + i));
            }
            return true;
        }
        return false;
    }

    public static Polynomial stabilize(Polynomial p, double rmin) {
        if (p == null) {
            return null;
        }
        Complex[] roots = p.roots();
        boolean changed = false;
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            double n = roots[i].abs();
            if (!(n < 1.0 / rmin)) continue;
            if (n < 1.0) {
                root = root.inv();
            }
            if (n > rmin) {
                root = root.div(rmin - 1.0E-9);
            }
            roots[i] = root;
            changed = true;
        }
        if (!changed) {
            return p;
        }
        return Polynomial.fromComplexRoots(roots);
    }

    public static double[] compact(double[] data) {
        int cur;
        for (cur = data.length - 1; cur >= 0 && data[cur] == 0.0; --cur) {
        }
        if (cur < 0) {
            return null;
        }
        if (cur == data.length - 1) {
            return data;
        }
        double[] cdata = new double[cur + 1];
        for (int i = 0; i <= cur; ++i) {
            cdata[i] = data[i];
        }
        return cdata;
    }

    public static Complex frequencyResponse(IntToDoubleFunction c, int lb, int ub, double w) {
        double cos = Math.cos(w);
        int idx = lb;
        Complex c0 = lb == 0 ? Complex.ONE : Complex.cart((double)Math.cos(w * (double)idx), (double)Math.sin(w * (double)idx));
        ComplexComputer rslt = new ComplexComputer((ComplexType)c0).mul(c.applyAsDouble(idx++));
        if (idx <= ub) {
            Complex c1 = Complex.cart((double)Math.cos(w * (double)idx), (double)Math.sin(w * (double)idx));
            rslt.addAC(c.applyAsDouble(idx++), (ComplexType)c1);
            while (idx <= ub) {
                Complex eiw = new ComplexComputer((ComplexType)c1).mul(2.0 * cos).sub((ComplexType)c0).result();
                rslt.addAC(c.applyAsDouble(idx++), (ComplexType)eiw);
                c0 = c1;
                c1 = eiw;
            }
        }
        return rslt.result();
    }

    public static double[] smooth(double[] data) {
        return FilterUtility.smooth(data, 1.0E-9, true);
    }

    public static double[] smooth(double[] data, double epsilon, boolean bcompact) {
        for (int i = 0; i < data.length; ++i) {
            if (!(Math.abs(data[i]) < epsilon)) continue;
            data[i] = 0.0;
        }
        if (bcompact) {
            return FilterUtility.compact(data);
        }
        return data;
    }

    public static DoubleSeq filter(DoubleSeq input, SymmetricFilter filter, IFiniteFilter[] afilters) {
        double[] x = new double[input.length()];
        int h = filter.getUpperBound();
        DataBlock out = DataBlock.of(x, h, x.length - h);
        filter.apply(input, (DoubleSeq.Mutable)out);
        if (afilters != null) {
            int i = 0;
            int j = h - 1;
            int k = x.length - h;
            int len = 2 * h;
            while (i < h) {
                x[j] = afilters[i].apply(input.extract(0, len).reverse());
                x[k] = afilters[i].apply(input.extract(x.length - len, len));
                ++i;
                --len;
                --j;
                ++k;
            }
        } else {
            for (int i = 0; i < h; ++i) {
                x[i] = Double.NaN;
                x[x.length - i - 1] = Double.NaN;
            }
        }
        return DoubleSeq.of((double[])x);
    }

    public static void inPlaceFilter(DoubleSeq input, DataBlock output, SymmetricFilter filter, IFiniteFilter[] afilters) {
        int h = filter.getUpperBound();
        int ilen = input.length();
        DataBlock out = output.drop(h, h);
        filter.apply(input, (DoubleSeq.Mutable)out);
        if (afilters != null) {
            int i = 0;
            int j = h - 1;
            int k = ilen - h;
            int len = 2 * h;
            while (i < h) {
                output.set(j, afilters[i].apply(input.extract(0, len).reverse()));
                output.set(k, afilters[i].apply(input.extract(ilen - len, len)));
                ++i;
                --len;
                --j;
                ++k;
            }
        } else {
            for (int i = 0; i < h; ++i) {
                output.set(i, Double.NaN);
                output.set(ilen - i - 1, Double.NaN);
            }
        }
    }

    public static DoubleSeq filter(DoubleSeq input, IFiniteFilter filter, IFiniteFilter[] leftFilters, IFiniteFilter[] rightFilters) {
        IFiniteFilter cur;
        int j;
        int i;
        double[] x = new double[input.length()];
        int l = -filter.getLowerBound();
        int u = filter.getUpperBound();
        DataBlock out = DataBlock.of(x, l, x.length - u);
        filter.apply(input, (DoubleSeq.Mutable)out);
        if (leftFilters != null) {
            i = 0;
            j = l - 1;
            while (i < l) {
                cur = leftFilters[i];
                x[j] = cur.apply(input.extract(j + cur.getLowerBound(), cur.length()));
                ++i;
                --j;
            }
        } else {
            for (i = 0; i < l; ++i) {
                x[i] = Double.NaN;
            }
        }
        if (rightFilters != null) {
            i = 0;
            j = x.length - u;
            while (i < u) {
                cur = rightFilters[i];
                x[j] = cur.apply(input.extract(j + cur.getLowerBound(), cur.length()));
                ++i;
                ++j;
            }
        } else {
            for (i = 0; i < l; ++i) {
                x[x.length - i - 1] = Double.NaN;
            }
        }
        return DoubleSeq.of((double[])x);
    }

    public static void inPlaceFilter(DoubleSeq input, DataBlock output, IFiniteFilter filter, IFiniteFilter[] leftFilters, IFiniteFilter[] rightFilters) {
        IFiniteFilter cur;
        int j;
        int i;
        int l = -filter.getLowerBound();
        int u = filter.getUpperBound();
        int ilen = input.length();
        DataBlock out = output.drop(l, u);
        filter.apply(input, (DoubleSeq.Mutable)out);
        if (leftFilters != null) {
            i = 0;
            j = l - 1;
            while (i < l) {
                cur = leftFilters[i];
                output.set(j, cur.apply(input.extract(j + cur.getLowerBound(), cur.length())));
                ++i;
                --j;
            }
        } else {
            for (i = 0; i < l; ++i) {
                output.set(i, Double.NaN);
            }
        }
        if (rightFilters != null) {
            i = 0;
            j = ilen - u;
            while (i < u) {
                cur = rightFilters[i];
                output.set(j, cur.apply(input.extract(j + cur.getLowerBound(), cur.length())));
                ++i;
                ++j;
            }
        } else {
            for (i = 0; i < l; ++i) {
                output.set(ilen - i - 1, Double.NaN);
            }
        }
    }

    @Generated
    private FilterUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

