/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.extractors;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.SaVariable;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;

public class SaRegarimaExtractor
extends InformationMapping<RegSarimaModel> {
    public Class getSourceClass() {
        return RegSarimaModel.class;
    }

    private static TsData outlier(RegSarimaModel source, ComponentType type, TsDomain domain) {
        TsData s = source.deterministicEffect(domain, v -> ModellingUtility.isOutlier((Variable)v) && SaVariable.isRegressionEffect((Variable)v, (ComponentType)type));
        return source.backTransform(s, false);
    }

    private static TsData det(RegSarimaModel source, ComponentType type, TsDomain domain, boolean lpcorr) {
        TsData s = source.deterministicEffect(domain, v -> SaVariable.isRegressionEffect((Variable)v, (ComponentType)type));
        return source.backTransform(s, lpcorr);
    }

    private static TsData reg(RegSarimaModel source, ComponentType type, TsDomain domain) {
        TsData s = source.deterministicEffect(domain, v -> ModellingUtility.isUser((Variable)v) && SaVariable.isRegressionEffect((Variable)v, (ComponentType)type));
        return source.backTransform(s, false);
    }

    public SaRegarimaExtractor() {
        this.set("out_i", TsData.class, source -> SaRegarimaExtractor.outlier(source, ComponentType.Irregular, null));
        this.setArray("out_i_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.outlier(source, ComponentType.Irregular, source.forecastDomain(i.intValue())));
        this.setArray("out_i_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.outlier(source, ComponentType.Irregular, source.backcastDomain(i.intValue())));
        this.set("out_t", TsData.class, source -> SaRegarimaExtractor.outlier(source, ComponentType.Trend, null));
        this.setArray("out_t_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.outlier(source, ComponentType.Trend, source.forecastDomain(i.intValue())));
        this.setArray("out_t_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.outlier(source, ComponentType.Trend, source.backcastDomain(i.intValue())));
        this.set("out_s", TsData.class, source -> SaRegarimaExtractor.outlier(source, ComponentType.Seasonal, null));
        this.setArray("out_s_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.outlier(source, ComponentType.Seasonal, source.forecastDomain(i.intValue())));
        this.setArray("out_s_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.outlier(source, ComponentType.Seasonal, source.backcastDomain(i.intValue())));
        this.set("reg_i", TsData.class, source -> SaRegarimaExtractor.reg(source, ComponentType.Irregular, null));
        this.setArray("reg_i_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Irregular, source.forecastDomain(i.intValue())));
        this.setArray("reg_i_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Irregular, source.backcastDomain(i.intValue())));
        this.set("reg_t", TsData.class, source -> SaRegarimaExtractor.reg(source, ComponentType.Trend, null));
        this.setArray("reg_t_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Trend, source.forecastDomain(i.intValue())));
        this.setArray("reg_t_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Trend, source.backcastDomain(i.intValue())));
        this.set("reg_s", TsData.class, source -> SaRegarimaExtractor.reg(source, ComponentType.Seasonal, null));
        this.setArray("reg_s_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Seasonal, source.forecastDomain(i.intValue())));
        this.setArray("reg_s_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Seasonal, source.backcastDomain(i.intValue())));
        this.set("reg_sa", TsData.class, source -> SaRegarimaExtractor.reg(source, ComponentType.SeasonallyAdjusted, null));
        this.setArray("reg_sa_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.SeasonallyAdjusted, source.forecastDomain(i.intValue())));
        this.setArray("reg_sa_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.SeasonallyAdjusted, source.backcastDomain(i.intValue())));
        this.set("reg_y", TsData.class, source -> SaRegarimaExtractor.reg(source, ComponentType.Series, null));
        this.setArray("reg_y_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Series, source.forecastDomain(i.intValue())));
        this.setArray("reg_y_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Series, source.backcastDomain(i.intValue())));
        this.set("reg_u", TsData.class, source -> SaRegarimaExtractor.reg(source, ComponentType.Undefined, null));
        this.setArray("reg_u_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Undefined, source.forecastDomain(i.intValue())));
        this.setArray("reg_u_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.reg(source, ComponentType.Undefined, source.backcastDomain(i.intValue())));
        this.set("det_i", TsData.class, source -> SaRegarimaExtractor.det(source, ComponentType.Irregular, null, false));
        this.setArray("det_i_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Irregular, source.forecastDomain(i.intValue()), false));
        this.setArray("det_i_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Irregular, source.backcastDomain(i.intValue()), false));
        this.set("det_t", TsData.class, source -> SaRegarimaExtractor.det(source, ComponentType.Trend, null, false));
        this.setArray("det_t_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Trend, source.forecastDomain(i.intValue()), false));
        this.setArray("det_t_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Trend, source.backcastDomain(i.intValue()), false));
        this.set("det_s", TsData.class, source -> SaRegarimaExtractor.det(source, ComponentType.Seasonal, null, true));
        this.setArray("det_s_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Seasonal, source.forecastDomain(i.intValue()), true));
        this.setArray("det_s_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Seasonal, source.backcastDomain(i.intValue()), true));
        this.set("reg_sa", TsData.class, source -> SaRegarimaExtractor.det(source, ComponentType.SeasonallyAdjusted, null, false));
        this.setArray("reg_sa_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.SeasonallyAdjusted, source.forecastDomain(i.intValue()), false));
        this.setArray("reg_sa_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.SeasonallyAdjusted, source.backcastDomain(i.intValue()), false));
        this.set("reg_y", TsData.class, source -> SaRegarimaExtractor.det(source, ComponentType.Series, null, false));
        this.setArray("reg_y_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Series, source.forecastDomain(i.intValue()), false));
        this.setArray("reg_y_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Series, source.backcastDomain(i.intValue()), false));
        this.set("reg_u", TsData.class, source -> SaRegarimaExtractor.det(source, ComponentType.Undefined, null, false));
        this.setArray("reg_u_f", -1, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Undefined, source.forecastDomain(i.intValue()), false));
        this.setArray("reg_u_b", 0, TsData.class, (source, i) -> SaRegarimaExtractor.det(source, ComponentType.Undefined, source.backcastDomain(i.intValue()), false));
        this.setArray("ylin_b", 0, TsData.class, (source, i) -> {
            TsData lf = source.linearizedBackcasts(i.intValue());
            TsData s = source.deterministicEffect(lf.getDomain(), v -> SaVariable.isRegressionEffect((Variable)v, (ComponentType)ComponentType.Undefined));
            return source.backTransform(TsData.add((TsData)lf, (TsData)s), false);
        });
        this.setArray("ylin_f", -1, TsData.class, (source, i) -> {
            TsData lf = source.linearizedForecasts(i.intValue());
            TsData s = source.deterministicEffect(lf.getDomain(), v -> SaVariable.isRegressionEffect((Variable)v, (ComponentType)ComponentType.Undefined));
            return source.backTransform(TsData.add((TsData)lf, (TsData)s), false);
        });
    }
}

