/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.real;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.branch.AbstractIntBranchingStrategy;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.search.IntBranchingDecision;
import choco.kernel.solver.search.ValIterator;
import choco.kernel.solver.variables.real.RealMath;
import choco.kernel.solver.variables.real.RealVar;

public class AssignInterval
extends AbstractIntBranchingStrategy {
    protected VarSelector<RealVar> varSelector;
    protected ValIterator<RealVar> valIterator;
    protected static final String[] LOG_DECISION_MSG = new String[]{"in first half of ", "in second half of "};

    public AssignInterval(VarSelector<RealVar> varSelector, ValIterator<RealVar> valIterator) {
        this.varSelector = varSelector;
        this.valIterator = valIterator;
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        return this.varSelector.selectVar();
    }

    @Override
    public void goDownBranch(IntBranchingDecision decision) throws ContradictionException {
        RealVar x = decision.getBranchingRealVar();
        if (decision.getBranchingValue() == 1) {
            x.intersect(RealMath.firstHalf(x));
        } else if (decision.getBranchingValue() == 2) {
            x.intersect(RealMath.secondHalf(x));
        } else {
            throw new SolverException("invalid real branching value");
        }
    }

    @Override
    public void goUpBranch(IntBranchingDecision decision) throws ContradictionException {
    }

    @Override
    public void setFirstBranch(IntBranchingDecision decision) {
        decision.setBranchingValue(this.valIterator.getFirstVal(decision.getBranchingRealVar()));
    }

    @Override
    public void setNextBranch(IntBranchingDecision decision) {
        decision.setBranchingValue(this.valIterator.getNextVal(decision.getBranchingRealVar(), decision.getBranchingValue()));
    }

    @Override
    public boolean finishedBranching(IntBranchingDecision decision) {
        return !this.valIterator.hasNextVal(decision.getBranchingRealVar(), decision.getBranchingValue());
    }

    @Override
    public String getDecisionLogMessage(IntBranchingDecision decision) {
        return LOG_DECISION_MSG[decision.getBranchIndex()] + decision.getBranchingObject();
    }
}

