/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.cp.solver.constraints.integer.MemberEnum;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractUnIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class NotMemberEnum
extends AbstractUnIntSConstraint {
    final int[] values;

    public NotMemberEnum(IntDomainVar v0, int[] values) {
        super(v0);
        this.values = values;
    }

    @Override
    public void propagate() throws ContradictionException {
        int left;
        int right = left = Integer.MIN_VALUE;
        boolean rall = true;
        for (int val : this.values) {
            if (val == right + 1) {
                right = val;
                continue;
            }
            rall &= this.v0.removeInterval(left, right, this, false);
            left = val;
            right = val;
        }
        if (rall &= this.v0.removeInterval(left, right, this, false)) {
            this.setEntailed();
        }
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return new MemberEnum(this.v0, this.values);
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer("DISJOINT(");
        sb.append(this.v0.pretty()).append(",{");
        StringUtils.pretty(this.values);
        sb.append("})");
        return sb.toString();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int val : this.values) {
            if (tuple[0] != val) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSatisfied() {
        for (int val : this.values) {
            if (!this.v0.canBeInstantiatedTo(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean isEntailed() {
        int nb = 0;
        for (int val : this.values) {
            if (!this.v0.canBeInstantiatedTo(val)) continue;
            ++nb;
        }
        if (nb == 0) {
            return true;
        }
        if (nb == this.v0.getDomainSize()) {
            return false;
        }
        return null;
    }
}

