/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector;

import choco.cp.common.util.preprocessor.AbstractAdvancedDetector;
import choco.cp.common.util.preprocessor.graph.ArrayGraph;
import choco.cp.common.util.preprocessor.graph.MaxCliques;
import choco.cp.model.CPModel;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.util.Iterator;

public abstract class AbstractGraphBasedDetector
extends AbstractAdvancedDetector {
    protected ArrayGraph diffs;
    protected CliqueIterator itc;

    protected AbstractGraphBasedDetector(CPModel model) {
        super(model);
        this.diffs = new ArrayGraph(model.getNbIntVars());
    }

    public void addEdge(Variable a, Variable b, Constraint c) {
        int idxa = a.getHook();
        int idxb = b.getHook();
        this.diffs.addEdge(idxa, idxb);
        this.diffs.storeEdge(c, idxa, idxb);
    }

    public void removeConstraint(int a, int b) {
        this.delete(this.diffs.getConstraintEdge(a, b));
    }

    public CliqueIterator cliqueIterator() {
        if (this.itc == null) {
            return new CliqueIterator();
        }
        this.itc.init();
        return this.itc;
    }

    public class CliqueIterator
    implements Iterator<IntegerVariable[]> {
        protected int idx = 0;
        protected int[][] clique;

        public CliqueIterator() {
            MaxCliques mc = new MaxCliques(AbstractGraphBasedDetector.this.diffs);
            this.clique = mc.getMaxCliques();
        }

        public void init() {
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.clique.length;
        }

        @Override
        public IntegerVariable[] next() {
            IntegerVariable[] c = new IntegerVariable[this.clique[this.idx].length];
            for (int j = 0; j < c.length; ++j) {
                c[j] = AbstractGraphBasedDetector.this.model.getIntVar(this.clique[this.idx][j]);
            }
            ++this.idx;
            return c;
        }

        @Override
        public void remove() {
            int id = this.idx - 1;
            for (int j = 0; j < this.clique[id].length; ++j) {
                for (int k = j + 1; k < this.clique[id].length; ++k) {
                    AbstractGraphBasedDetector.this.diffs.remEdge(this.clique[id][j], this.clique[id][k]);
                    AbstractGraphBasedDetector.this.removeConstraint(this.clique[id][j], this.clique[id][k]);
                }
            }
        }
    }
}

