## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(SRMERS)

## ----eval = F-----------------------------------------------------------------
# # shape detection under the fixed effect model
# shape <- FERS(y = "ySim",
#               xMain = "hormone",
#               xConf = c("age", "invwt", "race2", "race3", "race4", "race5",
#                         "season2", "season3", "season4", "smoking1", "ovum1", "diabetes1"),
#               dataset = data.sim.fixed,
#               nBasis = 5,
#               nIter = 1000)
# 
# # shape detection under the mixed effects model
# shape <- MERS(y = "ySim",
#               xMain = "hormone",
#               xConf = c("age", "invwt", "race2", "race3", "race4", "race5",
#                         "season2", "season3", "season4", "smoking1", "ovum1", "diabetes1"),
#               xRand = "cluster",
#               dataset = data.sim.mixed,
#               nBasis = 5,
#               nIter = 1000)
# 
# # mediation analysis
# medModel <- SRSplineMed(data = data.sim.med, nBasis = 5,
#                         exposure = "pesticide1",
#                         mediator = "hormone",
#                         outcome = "ySim",
#                         confounderVec = c("age", "invwt", "race2", "race3", "race4", "race5",
#                                           "season2", "season3", "season4", "smoking1", "ovum1",
#                                           "diabetes1"),
#                         shapeExp = "concave", shapeNonExp = "increasing",
#                         mValue = 0.15, varAsymp = TRUE)
# 
# # mediation analysis using linear regressions (binary exposure)
# medModel <- LRMed(data = data.sim.med,
#                   exposure = "pesticide1",
#                   mediator = "hormone",
#                   outcome = "ySim",
#                   confounderVec = c("age", "invwt", "race2", "race3", "race4", "race5",
#                                     "season2", "season3", "season4", "smoking1", "ovum1",
#                                     "diabetes1"),
#                   mValue = 0.15)
# 
# # mediation analysis using linear regressions (continuous exposure)
# medModel <- LRMed2(data = data.sim.med,
#                    exposure = "pesticide1",
#                    mediator = "hormone",
#                    outcome = "ySim",
#                    confounderVec = c("age", "invwt", "race2", "race3", "race4", "race5",
#                                      "season2", "season3", "season4", "smoking1", "ovum1",
#                                      "diabetes1"),
#                    mValue = 0.15, eValueLow = 0.1, eValueHigh = 1.1)

