/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.CLIException;
import org.jkiss.dbeaver.model.cli.model.option.InputFileOption;

public class CLIUtils {
    private static final Log log = Log.getLog(CLIUtils.class);

    @Nullable
    public static String readValueFromFileOrSystemIn(@Nullable InputFileOption filesOptions) throws CLIException {
        String value = null;
        if (filesOptions == null || filesOptions.getInputFile() == null) {
            value = CLIUtils.tryReadFromSystemIn();
        } else if (filesOptions.getInputFile() != null) {
            if (Files.notExists(filesOptions.getInputFile(), new LinkOption[0])) {
                throw new CLIException("Input file does not exist: " + String.valueOf(filesOptions.getInputFile()), 2);
            }
            try {
                value = Files.readString(filesOptions.getInputFile());
            }
            catch (IOException e) {
                throw new CLIException("Error reading GQL from input file: " + String.valueOf(filesOptions.getInputFile()), (Throwable)e, 1);
            }
        }
        return value;
    }

    @Nullable
    private static String tryReadFromSystemIn() {
        try {
            if (System.in.available() > 0) {
                return new String(System.in.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading from system in", (Throwable)e);
            return null;
        }
        return null;
    }
}

