import type { ArtixRepo } from 'artix-checkupdates';
import type { ArtoolsConf } from './artoolsconf.mts';
export interface PusherConfig {
    gpgpass?: string;
}
export type ArtixpkgRepo = ArtixRepo | 'stable' | 'gremlins' | 'goblins';
export interface Job extends Partial<ArtoolsConf> {
    source?: ArtixpkgRepo;
    repo: ArtixpkgRepo;
    increment: boolean;
    packages: string[];
}
export declare class Pusher {
    private _gitea;
    private _config;
    private _artools;
    private _createdSignfile;
    constructor(config?: PusherConfig, artoolsConf?: ArtoolsConf);
    refreshGpg(): Promise<void>;
    increment(pkg: string): Promise<void>;
    isNewPackage(pkg: string): Promise<boolean>;
    runJob(job: Job): Promise<void>;
}
export default Pusher;
