/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.ContextNamingInfoListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.res.StringManager;

public class PropertiesRoleMappingListener
implements LifecycleListener {
    private static final String WEBAPP_PROTOCOL = "webapp:";
    private static final Log log = LogFactory.getLog(PropertiesRoleMappingListener.class);
    private static final StringManager sm = StringManager.getManager(ContextNamingInfoListener.class);
    private String roleMappingFile = "webapp:/WEB-INF/role-mapping.properties";
    private String keyPrefix;

    public void setRoleMappingFile(String string) {
        Objects.requireNonNull(string, sm.getString("propertiesRoleMappingListener.roleMappingFileNull"));
        if (string.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("propertiesRoleMappingListener.roleMappingFileEmpty"));
        }
        this.roleMappingFile = string;
    }

    public String getRoleMappingFile() {
        return this.roleMappingFile;
    }

    public void setKeyPrefix(String string) {
        this.keyPrefix = string;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if (lifecycleEvent.getType().equals("configure_start")) {
            InputStream inputStream;
            Object object;
            if (!(lifecycleEvent.getLifecycle() instanceof Context)) {
                log.warn((Object)sm.getString("listener.notContext", new Object[]{lifecycleEvent.getLifecycle().getClass().getSimpleName()}));
                return;
            }
            Context context = (Context)lifecycleEvent.getLifecycle();
            if (this.roleMappingFile.startsWith(WEBAPP_PROTOCOL)) {
                object = this.roleMappingFile.substring(WEBAPP_PROTOCOL.length());
                inputStream = context.getServletContext().getResourceAsStream((String)object);
            } else {
                try {
                    inputStream = ConfigFileLoader.getInputStream((String)this.roleMappingFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    inputStream = null;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(sm.getString("propertiesRoleMappingListener.roleMappingFileFail", new Object[]{this.roleMappingFile}), iOException);
                }
            }
            if (inputStream == null) {
                throw new IllegalStateException(sm.getString("propertiesRoleMappingListener.roleMappingFileNotFound", new Object[]{this.roleMappingFile}));
            }
            object = new Properties();
            try (InputStream inputStream2 = inputStream;){
                ((Properties)object).load(inputStream2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(sm.getString("propertiesRoleMappingListener.roleMappingFileFail", new Object[]{this.roleMappingFile}), iOException);
            }
            int n = 0;
            for (Map.Entry<Object, Object> entry : ((Properties)object).entrySet()) {
                String string = (String)entry.getKey();
                if (this.keyPrefix != null) {
                    if (!string.startsWith(this.keyPrefix)) continue;
                    string = string.substring(this.keyPrefix.length());
                }
                String string2 = (String)entry.getValue();
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("propertiesRoleMappingListener.linkedRole", new Object[]{string, string2}));
                }
                context.addRoleMapping(string, string2);
                ++n;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("propertiesRoleMappingListener.linkedRoleCount", new Object[]{n}));
            }
        }
    }
}

