/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.buffer;

import com.oracle.truffle.regex.tregex.buffer.AbstractArrayBuffer;
import com.oracle.truffle.regex.util.EmptyArrays;
import java.util.Arrays;
import java.util.PrimitiveIterator;

public class LongArrayBuffer
extends AbstractArrayBuffer
implements Iterable<Long> {
    protected long[] buf;

    public LongArrayBuffer(int initialSize) {
        this.buf = new long[initialSize];
    }

    public LongArrayBuffer() {
        this(8);
    }

    public LongArrayBuffer(long[] buf) {
        this.buf = buf;
        this.length = buf.length;
    }

    @Override
    int getBufferLength() {
        return this.buf.length;
    }

    @Override
    void grow(int newSize) {
        this.buf = Arrays.copyOf(this.buf, newSize);
    }

    public long get(int i) {
        return this.buf[i];
    }

    public void set(int i, long v) {
        this.buf[i] = v;
    }

    public void add(long v) {
        if (this.length == this.buf.length) {
            this.grow(this.length == 0 ? 1 : this.length * 2);
        }
        this.buf[this.length++] = v;
    }

    public void sort() {
        Arrays.sort(this.buf, 0, this.length);
    }

    public void addAll(long[] v) {
        this.addAll(v, v.length);
    }

    public void addAll(long[] v, int vlength) {
        this.ensureCapacity(this.length + vlength);
        System.arraycopy(v, 0, this.buf, this.length, vlength);
        this.length += vlength;
    }

    public void addAll(LongArrayBuffer v) {
        this.addAll(v.buf, v.length);
    }

    public long pop() {
        return this.buf[--this.length];
    }

    public long peek() {
        return this.buf[this.length - 1];
    }

    public long[] toArray() {
        return this.isEmpty() ? EmptyArrays.LONG : Arrays.copyOf(this.buf, this.length);
    }

    public PrimitiveIterator.OfLong iterator() {
        return new LongArrayBufferIterator(this.buf, this.length);
    }

    public LongArrayBuffer copy() {
        LongArrayBuffer result = new LongArrayBuffer(this.length);
        result.addAll(this);
        return result;
    }

    public void swap(int i, int j) {
        long temp = this.buf[i];
        this.buf[i] = this.buf[j];
        this.buf[j] = temp;
    }

    private static final class LongArrayBufferIterator
    implements PrimitiveIterator.OfLong {
        private final long[] buf;
        private final int size;
        private int i = 0;

        private LongArrayBufferIterator(long[] buf, int size) {
            this.buf = buf;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public long nextLong() {
            return this.buf[this.i++];
        }
    }
}

