/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.io.Serializable;
import java.util.Arrays;
import us.fatehi.utility.Utility;

public final class NamedObjectKey
implements Serializable {
    private static final long serialVersionUID = -5008609072012459037L;
    private final String[] key;

    public NamedObjectKey(String ... key) {
        this.key = key == null || key.length == 0 ? new String[0] : Arrays.copyOf(key, key.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NamedObjectKey)) {
            return false;
        }
        NamedObjectKey other = (NamedObjectKey)obj;
        return Arrays.equals(this.key, other.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String slug() {
        if (this.key.length == 0) {
            return "";
        }
        String name = this.key[this.key.length - 1];
        return Utility.convertForComparison(name) + "_" + Integer.toHexString(this.hashCode());
    }

    public String toString() {
        return "{\"key\": \"" + String.join((CharSequence)"/", this.key) + "\"}";
    }

    public NamedObjectKey with(String name) {
        int currentLength = this.key.length;
        String[] newKey = Arrays.copyOf(this.key, currentLength + 1);
        newKey[currentLength] = name;
        return new NamedObjectKey(newKey);
    }
}

