/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.extern.decimal;

import java.math.BigInteger;
import java.util.Arrays;

public final class DenselyPackedDecimalCodec {
    static final int DIGITS_PER_GROUP = 3;
    static final int BITS_PER_GROUP = 10;
    private static final int BITS_PER_BYTE = 8;
    private static final BigInteger ONE_THOUSAND = BigInteger.valueOf(1000L);
    private static final char[] DPD_GROUP_BITS_2_DIGITS = "000001002003004005006007008009080081800801880881010011012013014015016017018019090091810811890891020021022023024025026027028029082083820821808809030031032033034035036037038039092093830831818819040041042043044045046047048049084085840841088089050051052053054055056057058059094095850851098099060061062063064065066067068069086087860861888889070071072073074075076077078079096097870871898899100101102103104105106107108109180181900901980981110111112113114115116117118119190191910911990991120121122123124125126127128129182183920921908909130131132133134135136137138139192193930931918919140141142143144145146147148149184185940941188189150151152153154155156157158159194195950951198199160161162163164165166167168169186187960961988989170171172173174175176177178179196197970971998999200201202203204205206207208209280281802803882883210211212213214215216217218219290291812813892893220221222223224225226227228229282283822823828829230231232233234235236237238239292293832833838839240241242243244245246247248249284285842843288289250251252253254255256257258259294295852853298299260261262263264265266267268269286287862863888889270271272273274275276277278279296297872873898899300301302303304305306307308309380381902903982983310311312313314315316317318319390391912913992993320321322323324325326327328329382383922923928929330331332333334335336337338339392393932933938939340341342343344345346347348349384385942943388389350351352353354355356357358359394395952953398399360361362363364365366367368369386387962963988989370371372373374375376377378379396397972973998999400401402403404405406407408409480481804805884885410411412413414415416417418419490491814815894895420421422423424425426427428429482483824825848849430431432433434435436437438439492493834835858859440441442443444445446447448449484485844845488489450451452453454455456457458459494495854855498499460461462463464465466467468469486487864865888889470471472473474475476477478479496497874875898899500501502503504505506507508509580581904905984985510511512513514515516517518519590591914915994995520521522523524525526527528529582583924925948949530531532533534535536537538539592593934935958959540541542543544545546547548549584585944945588589550551552553554555556557558559594595954955598599560561562563564565566567568569586587964965988989570571572573574575576577578579596597974975998999600601602603604605606607608609680681806807886887610611612613614615616617618619690691816817896897620621622623624625626627628629682683826827868869630631632633634635636637638639692693836837878879640641642643644645646647648649684685846847688689650651652653654655656657658659694695856857698699660661662663664665666667668669686687866867888889670671672673674675676677678679696697876877898899700701702703704705706707708709780781906907986987710711712713714715716717718719790791916917996997720721722723724725726727728729782783926927968969730731732733734735736737738739792793936937978979740741742743744745746747748749784785946947788789750751752753754755756757758759794795956957798799760761762763764765766767768769786787966967988989770771772773774775776777778779796797976977998999".toCharArray();
    private static final int[] BIN_2_DPD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 10, 11, 42, 43, 74, 75, 106, 107, 78, 79, 26, 27, 58, 59, 90, 91, 122, 123, 94, 95, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 138, 139, 170, 171, 202, 203, 234, 235, 206, 207, 154, 155, 186, 187, 218, 219, 250, 251, 222, 223, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 266, 267, 298, 299, 330, 331, 362, 363, 334, 335, 282, 283, 314, 315, 346, 347, 378, 379, 350, 351, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 394, 395, 426, 427, 458, 459, 490, 491, 462, 463, 410, 411, 442, 443, 474, 475, 506, 507, 478, 479, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 522, 523, 554, 555, 586, 587, 618, 619, 590, 591, 538, 539, 570, 571, 602, 603, 634, 635, 606, 607, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 704, 705, 706, 707, 708, 709, 710, 711, 712, 713, 720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 736, 737, 738, 739, 740, 741, 742, 743, 744, 745, 752, 753, 754, 755, 756, 757, 758, 759, 760, 761, 650, 651, 682, 683, 714, 715, 746, 747, 718, 719, 666, 667, 698, 699, 730, 731, 762, 763, 734, 735, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 778, 779, 810, 811, 842, 843, 874, 875, 846, 847, 794, 795, 826, 827, 858, 859, 890, 891, 862, 863, 896, 897, 898, 899, 900, 901, 902, 903, 904, 905, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 928, 929, 930, 931, 932, 933, 934, 935, 936, 937, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 976, 977, 978, 979, 980, 981, 982, 983, 984, 985, 992, 993, 994, 995, 996, 997, 998, 999, 1000, 1001, 1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 906, 907, 938, 939, 970, 971, 1002, 1003, 974, 975, 922, 923, 954, 955, 986, 987, 1018, 1019, 990, 991, 12, 13, 268, 269, 524, 525, 780, 781, 46, 47, 28, 29, 284, 285, 540, 541, 796, 797, 62, 63, 44, 45, 300, 301, 556, 557, 812, 813, 302, 303, 60, 61, 316, 317, 572, 573, 828, 829, 318, 319, 76, 77, 332, 333, 588, 589, 844, 845, 558, 559, 92, 93, 348, 349, 604, 605, 860, 861, 574, 575, 108, 109, 364, 365, 620, 621, 876, 877, 814, 815, 124, 125, 380, 381, 636, 637, 892, 893, 830, 831, 14, 15, 270, 271, 526, 527, 782, 783, 110, 111, 30, 31, 286, 287, 542, 543, 798, 799, 126, 127, 140, 141, 396, 397, 652, 653, 908, 909, 174, 175, 156, 157, 412, 413, 668, 669, 924, 925, 190, 191, 172, 173, 428, 429, 684, 685, 940, 941, 430, 431, 188, 189, 444, 445, 700, 701, 956, 957, 446, 447, 204, 205, 460, 461, 716, 717, 972, 973, 686, 687, 220, 221, 476, 477, 732, 733, 988, 989, 702, 703, 236, 237, 492, 493, 748, 749, 1004, 1005, 942, 943, 252, 253, 508, 509, 764, 765, 1020, 1021, 958, 959, 142, 143, 398, 399, 654, 655, 910, 911, 238, 239, 158, 159, 414, 415, 670, 671, 926, 927, 254, 255};
    private final int numberOfDigits;
    private final int digitGroups;

    public DenselyPackedDecimalCodec(int numberOfDigits) {
        if (numberOfDigits / 3 <= 0 || numberOfDigits % 3 != 1) {
            throw new IllegalArgumentException("numberOfDigits must be of form n * 3 + 1 with n > 0, was " + numberOfDigits);
        }
        this.numberOfDigits = numberOfDigits;
        this.digitGroups = numberOfDigits / 3;
    }

    public BigInteger decodeValue(int signum, int firstDigit, byte[] decBytes) {
        return this.decodeValue(signum, firstDigit, decBytes, decBytes.length - 1);
    }

    public BigInteger decodeValue(int signum, int firstDigit, byte[] decBytes, int lsbIndex) {
        if (firstDigit < 0 || firstDigit > 9) {
            throw new IllegalArgumentException("firstDigit must be in range 0 <= firstDigit <= 9, was " + firstDigit);
        }
        this.validateLsbIndex(lsbIndex, decBytes.length);
        return this.decodeValue0(signum, firstDigit, decBytes, lsbIndex);
    }

    public int encodeValue(BigInteger value, byte[] decBytes) {
        return this.encodeValue(value.abs(), decBytes, decBytes.length - 1);
    }

    public int encodeValue(BigInteger value, byte[] decBytes, int lsbIndex) {
        this.validateLsbIndex(lsbIndex, decBytes.length);
        return this.encodeValue0(value.abs(), decBytes, lsbIndex);
    }

    private BigInteger decodeValue0(int signum, int firstDigit, byte[] decBytes, int lsbIndex) {
        char[] digitChars = this.createZeroedCharArray();
        for (int digitGroup = 0; digitGroup < this.digitGroups; ++digitGroup) {
            int digitBitsFromEnd = digitGroup * 10;
            int firstByteIndex = lsbIndex - digitBitsFromEnd / 8;
            int firstByteBitOffset = digitBitsFromEnd % 8;
            int dpdGroupBits = 0x3FF & ((decBytes[firstByteIndex] & 0xFF) >>> firstByteBitOffset | decBytes[firstByteIndex - 1] << 8 - firstByteBitOffset);
            if (dpdGroupBits == 0) continue;
            System.arraycopy(DPD_GROUP_BITS_2_DIGITS, dpdGroupBits * 3, digitChars, digitChars.length - (digitGroup + 1) * 3, 3);
        }
        if (firstDigit != 0) {
            digitChars[1] = Character.forDigit(firstDigit, 10);
        }
        return DenselyPackedDecimalCodec.toBigInteger(signum, digitChars);
    }

    private int encodeValue0(BigInteger value, byte[] decBytes, int lsbIndex) {
        BigInteger remainingValue = value;
        for (int digitGroup = 0; digitGroup < this.digitGroups; ++digitGroup) {
            int digitBitsFromEnd = digitGroup * 10;
            int firstByteBitOffset = digitBitsFromEnd % 8;
            int firstByteIndex = lsbIndex - digitBitsFromEnd / 8;
            BigInteger[] valueAndRemainder = remainingValue.divideAndRemainder(ONE_THOUSAND);
            remainingValue = valueAndRemainder[0];
            int currentGroup = BIN_2_DPD[valueAndRemainder[1].intValue()];
            decBytes[firstByteIndex] = (byte)(decBytes[firstByteIndex] | currentGroup << firstByteBitOffset);
            decBytes[firstByteIndex - 1] = (byte)(decBytes[firstByteIndex - 1] | currentGroup >>> 8 - firstByteBitOffset);
        }
        int mostSignificantDigit = remainingValue.intValue();
        assert (0 <= mostSignificantDigit && mostSignificantDigit <= 9) : "mostSignificantDigit out of range, was " + mostSignificantDigit;
        return mostSignificantDigit;
    }

    private char[] createZeroedCharArray() {
        char[] digitChars = new char[this.numberOfDigits + 1];
        Arrays.fill(digitChars, '0');
        return digitChars;
    }

    private void validateLsbIndex(int lsbIndex, int decBytesLength) {
        if (lsbIndex < 0 || lsbIndex >= decBytesLength) {
            throw new ArrayIndexOutOfBoundsException("lsbIndex must be within array decBytes with length of " + decBytesLength + " , was " + lsbIndex);
        }
        if ((lsbIndex + 1) * 8 < 10 * this.digitGroups) {
            throw new IllegalArgumentException(String.format("Need at least %d bytes for value, have %d (lsbIndex = %d)", (10 * this.digitGroups + 7) / 8, lsbIndex + 1, lsbIndex));
        }
    }

    private static BigInteger toBigInteger(int signum, char[] digitChars) {
        int digitCharIndex = DenselyPackedDecimalCodec.findFirstNonZero(digitChars);
        if (digitCharIndex == -1) {
            return BigInteger.ZERO;
        }
        if (signum == -1) {
            digitChars[--digitCharIndex] = 45;
        }
        return new BigInteger(new String(digitChars, digitCharIndex, digitChars.length - digitCharIndex));
    }

    private static int findFirstNonZero(char[] digitChars) {
        for (int index = 0; index < digitChars.length; ++index) {
            if (digitChars[index] == '0') continue;
            return index;
        }
        return -1;
    }
}

