/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class TcpsConfigure {
    static final boolean DEBUG = false;
    private static final int SSL_CERT_SAN_DNS_NAME = 2;
    public static final String[] VALID_SSL_VERSION_STRINGS;
    public static final String[][] TABLE_ENABLED_SSL_PROTOCOLS;
    public static final int[] VALID_SSL_STRING_TO_PROTOCOLS_MAP;
    static final HashSet<String> UNSUPPORTED_PROTOCOLS_SET;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    private TcpsConfigure() {
    }

    public static void configureVersion(SSLSocket sslSocket, SSLEngine sslEngine, String sslVersionString, boolean useNio) throws NetException, IOException {
        if (sslVersionString == null) {
            sslVersionString = System.getProperty("oracle.net.ssl_version");
        }
        String[] enabledProtocols = null;
        int validSSLVersionIndex = 0;
        if (sslVersionString != null) {
            sslVersionString = sslVersionString.startsWith("(") && sslVersionString.endsWith(")") ? "(ssl_version=" + sslVersionString.substring(1) : "(ssl_version=" + sslVersionString + ")";
            try {
                NVPair nvpVersion = new NVFactory().createNVPair(sslVersionString);
                String sslVersion = nvpVersion.getAtom();
                for (int i2 = 0; i2 < VALID_SSL_VERSION_STRINGS.length; ++i2) {
                    if (!sslVersion.equalsIgnoreCase(VALID_SSL_VERSION_STRINGS[i2])) continue;
                    validSSLVersionIndex = i2;
                    break;
                }
            }
            catch (NLException ex) {
                throw (NetException)new NetException(400, sslVersionString).initCause(ex);
            }
            if (validSSLVersionIndex >= VALID_SSL_VERSION_STRINGS.length) {
                throw new NetException(400);
            }
            enabledProtocols = TABLE_ENABLED_SSL_PROTOCOLS[VALID_SSL_STRING_TO_PROTOCOLS_MAP[validSSLVersionIndex]];
        } else {
            enabledProtocols = TcpsConfigure.getAllSupportedProtocols(useNio, sslEngine, sslSocket);
            if (enabledProtocols == null) {
                throw new NetException(400);
            }
        }
        try {
            if (!useNio) {
                sslSocket.setEnabledProtocols(enabledProtocols);
            } else {
                sslEngine.setEnabledProtocols(enabledProtocols);
            }
        }
        catch (IllegalArgumentException ex) {
            throw (NetException)new NetException(401).initCause(ex);
        }
    }

    public static void configureCipherSuites(SSLSocket sslSocket, SSLEngine sslEngine, String cipherSuitesString, boolean useNio) throws NetException, IOException {
        if (cipherSuitesString == null) {
            cipherSuitesString = System.getProperty("oracle.net.ssl_cipher_suites");
        }
        if (cipherSuitesString == null) {
            return;
        }
        cipherSuitesString = cipherSuitesString.startsWith("(") && cipherSuitesString.endsWith(")") ? "(cipher_suites=" + cipherSuitesString + ")" : "(cipher_suites=(" + cipherSuitesString + "))";
        try {
            NVPair nvpCipher = new NVFactory().createNVPair(cipherSuitesString);
            String[] listCipherSuites = new String[nvpCipher.getListSize()];
            if (nvpCipher.getRHSType() == NVPair.LIST_COMMASEP || nvpCipher.getRHSType() == NVPair.RHS_LIST) {
                for (int i2 = 0; i2 < nvpCipher.getListSize(); ++i2) {
                    listCipherSuites[i2] = nvpCipher.getListElement(i2).getName();
                }
            } else {
                throw new NetException(403, cipherSuitesString);
            }
            if (!useNio) {
                sslSocket.setEnabledCipherSuites(listCipherSuites);
            } else {
                sslEngine.setEnabledCipherSuites(listCipherSuites);
            }
        }
        catch (NLException ex) {
            throw new NetException(403, cipherSuitesString);
        }
        catch (IllegalArgumentException ex) {
            throw (NetException)new NetException(404).initCause(ex);
        }
    }

    private static String[] getAllSupportedProtocols(boolean useNio, SSLEngine sslEngine, SSLSocket sslSocket) {
        ArrayList<String> allSupportedProtocols = new ArrayList<String>();
        String[] allProtocols = null;
        allProtocols = useNio ? sslEngine.getSupportedProtocols() : sslSocket.getSupportedProtocols();
        if (allProtocols == null) {
            return null;
        }
        for (String curProtocol : allProtocols) {
            if (UNSUPPORTED_PROTOCOLS_SET.contains(curProtocol)) continue;
            allSupportedProtocols.add(curProtocol);
        }
        return allSupportedProtocols.toArray(new String[allSupportedProtocols.size()]);
    }

    static {
        try {
            $$$methodRef$$$3 = TcpsConfigure.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpsConfigure.class.getDeclaredMethod("getAllSupportedProtocols", Boolean.TYPE, SSLEngine.class, SSLSocket.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpsConfigure.class.getDeclaredMethod("configureCipherSuites", SSLSocket.class, SSLEngine.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpsConfigure.class.getDeclaredMethod("configureVersion", SSLSocket.class, SSLEngine.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        VALID_SSL_VERSION_STRINGS = new String[]{"0", "undetermined", "2", "2.0", "version 2", "3", "3.0", "version 3 only", "1", "1.0", "version 1 only", "1 or 3", "1.0 or 3.0", "version 1 or version 3", "1.1", "1.2", "1.1 or 3.0", "1.2 or 3.0", "1.1 or 1.0", "1.2 or 1.0", "1.2 or 1.1", "1.1 or 1.0 or 3.0", "1.2 or 1.0 or 3.0", "1.2 or 1.1 or 1.0", "1.2 or 1.1 or 3.0", "1.2 or 1.1 or 1.0 or 3.0"};
        TABLE_ENABLED_SSL_PROTOCOLS = new String[][]{{"TLSv1.2", "TLSv1.1", "TLSv1"}, {"SSLv2Hello"}, {"SSLv3"}, {"TLSv1"}, {"TLSv1", "SSLv3"}, {"TLSv1.1"}, {"TLSv1.2"}, {"TLSv1.1", "SSLv3"}, {"TLSv1.2", "SSLv3"}, {"TLSv1.1", "TLSv1"}, {"TLSv1.2", "TLSv1"}, {"TLSv1.2", "TLSv1.1"}, {"TLSv1.1", "TLSv1", "SSLv3"}, {"TLSv1.2", "TLSv1", "SSLv3"}, {"TLSv1.2", "TLSv1.1", "TLSv1"}, {"TLSv1.2", "TLSv1.1", "SSLv3"}, {"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"}};
        VALID_SSL_STRING_TO_PROTOCOLS_MAP = new int[]{0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        UNSUPPORTED_PROTOCOLS_SET = new HashSet();
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv3");
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv2Hello");
    }
}

