from typing import Final, Literal

from pymeeus.Angle import Angle
from pymeeus.Epoch import Epoch

PERIODIC_TERMS_LR_TABLE: Final[list[list[float]]]
PERIODIC_TERMS_B_TABLE: Final[list[list[float]]]

class Moon:
    @staticmethod
    def geocentric_ecliptical_pos(epoch: Epoch) -> tuple[Angle, Angle, float, Angle]: ...
    @staticmethod
    def apparent_ecliptical_pos(epoch: Epoch) -> tuple[Angle, Angle, float, Angle]: ...
    @staticmethod
    def apparent_equatorial_pos(epoch: Epoch) -> tuple[Angle, Angle, float, Angle]: ...
    @staticmethod
    def longitude_mean_ascending_node(epoch: Epoch) -> Angle: ...
    @staticmethod
    def longitude_true_ascending_node(epoch: Epoch) -> Angle: ...
    @staticmethod
    def longitude_mean_perigee(epoch: Epoch) -> Angle: ...
    @staticmethod
    def illuminated_fraction_disk(epoch: Epoch) -> float: ...
    @staticmethod
    def position_bright_limb(epoch: Epoch) -> Angle: ...
    @staticmethod
    def moon_phase(epoch: Epoch, target: Literal["new", "first", "full", "last"] = "new") -> Epoch: ...
    @staticmethod
    def moon_perigee_apogee(epoch: Epoch, target: Literal["perigee", "apogee"] = "perigee") -> tuple[Epoch, Angle]: ...
    @staticmethod
    def moon_passage_nodes(epoch: Epoch, target: Literal["ascending", "descending"] = "ascending") -> Epoch: ...
    @staticmethod
    def moon_maximum_declination(epoch: Epoch, target: Literal["northern", "southern"] = "northern") -> tuple[Epoch, Angle]: ...
    @staticmethod
    def moon_librations(epoch: Epoch) -> tuple[Angle, Angle, Angle, Angle, Angle, Angle]: ...
    @staticmethod
    def moon_position_angle_axis(epoch: Epoch) -> Angle: ...

def main() -> None: ...
