/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import lombok.Generated;
import org.opensearch.sql.protocol.response.format.ErrorFormatter;
import org.opensearch.sql.protocol.response.format.ResponseFormatter;

public abstract class JsonResponseFormatter<R>
implements ResponseFormatter<R> {
    private final Style style;
    public static final String CONTENT_TYPE = "application/json; charset=UTF-8";

    @Override
    public String format(R response) {
        return this.jsonify(this.buildJsonObject(response));
    }

    @Override
    public String format(Throwable t) {
        return this.style == Style.PRETTY ? ErrorFormatter.prettyFormat(t) : ErrorFormatter.compactFormat(t);
    }

    @Override
    public String contentType() {
        return CONTENT_TYPE;
    }

    protected abstract Object buildJsonObject(R var1);

    protected String jsonify(Object jsonObject) {
        return this.style == Style.PRETTY ? ErrorFormatter.prettyJsonify(jsonObject) : ErrorFormatter.compactJsonify(jsonObject);
    }

    @Generated
    public JsonResponseFormatter(Style style) {
        this.style = style;
    }

    public static enum Style {
        PRETTY,
        COMPACT;

    }
}

