/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Tenant
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Tenant> {
    @Nullable
    private final String description;
    @Nullable
    private final Boolean hidden;
    @Nullable
    private final Boolean reserved;
    @Nullable
    private final Boolean static_;
    public static final JsonpDeserializer<Tenant> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Tenant::setupTenantDeserializer);

    private Tenant(Builder builder) {
        this.description = builder.description;
        this.hidden = builder.hidden;
        this.reserved = builder.reserved;
        this.static_ = builder.static_;
    }

    public static Tenant of(Function<Builder, ObjectBuilder<Tenant>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Boolean hidden() {
        return this.hidden;
    }

    @Nullable
    public final Boolean reserved() {
        return this.reserved;
    }

    @Nullable
    public final Boolean static_() {
        return this.static_;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.hidden != null) {
            generator.writeKey("hidden");
            generator.write(this.hidden.booleanValue());
        }
        if (this.reserved != null) {
            generator.writeKey("reserved");
            generator.write(this.reserved.booleanValue());
        }
        if (this.static_ != null) {
            generator.writeKey("static");
            generator.write(this.static_.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTenantDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden");
        op.add(Builder::reserved, JsonpDeserializer.booleanDeserializer(), "reserved");
        op.add(Builder::static_, JsonpDeserializer.booleanDeserializer(), "static");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.hidden);
        result = 31 * result + Objects.hashCode(this.reserved);
        result = 31 * result + Objects.hashCode(this.static_);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant other = (Tenant)o;
        return Objects.equals(this.description, other.description) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.reserved, other.reserved) && Objects.equals(this.static_, other.static_);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Tenant> {
        @Nullable
        private String description;
        @Nullable
        private Boolean hidden;
        @Nullable
        private Boolean reserved;
        @Nullable
        private Boolean static_;

        public Builder() {
        }

        private Builder(Tenant o) {
            this.description = o.description;
            this.hidden = o.hidden;
            this.reserved = o.reserved;
            this.static_ = o.static_;
        }

        private Builder(Builder o) {
            this.description = o.description;
            this.hidden = o.hidden;
            this.reserved = o.reserved;
            this.static_ = o.static_;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder hidden(@Nullable Boolean value) {
            this.hidden = value;
            return this;
        }

        @Nonnull
        public final Builder reserved(@Nullable Boolean value) {
            this.reserved = value;
            return this;
        }

        @Nonnull
        public final Builder static_(@Nullable Boolean value) {
            this.static_ = value;
            return this;
        }

        @Override
        @Nonnull
        public Tenant build() {
            this._checkSingleUse();
            return new Tenant(this);
        }
    }
}

