(()=>{var __webpack_modules__={1559:function(){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(acequire,exports,module){"use strict";var dom=acequire("../lib/dom");var lang=acequire("../lib/lang");var event=acequire("../lib/event");var searchboxCss='.ace_search {background-color: #ddd;color: #666;border: 1px solid #cbcbcb;border-top: 0 none;overflow: hidden;margin: 0;padding: 4px 6px 0 4px;position: absolute;top: 0;z-index: 99;white-space: normal;}.ace_search.left {border-left: 0 none;border-radius: 0px 0px 5px 0px;left: 0;}.ace_search.right {border-radius: 0px 0px 0px 5px;border-right: 0 none;right: 0;}.ace_search_form, .ace_replace_form {margin: 0 20px 4px 0;overflow: hidden;line-height: 1.9;}.ace_replace_form {margin-right: 0;}.ace_search_form.ace_nomatch {outline: 1px solid red;}.ace_search_field {border-radius: 3px 0 0 3px;background-color: white;color: black;border: 1px solid #cbcbcb;border-right: 0 none;box-sizing: border-box!important;outline: 0;padding: 0;font-size: inherit;margin: 0;line-height: inherit;padding: 0 6px;min-width: 17em;vertical-align: top;}.ace_searchbtn {border: 1px solid #cbcbcb;line-height: inherit;display: inline-block;padding: 0 6px;background: #fff;border-right: 0 none;border-left: 1px solid #dcdcdc;cursor: pointer;margin: 0;position: relative;box-sizing: content-box!important;color: #666;}.ace_searchbtn:last-child {border-radius: 0 3px 3px 0;border-right: 1px solid #cbcbcb;}.ace_searchbtn:disabled {background: none;cursor: default;}.ace_searchbtn:hover {background-color: #eef1f6;}.ace_searchbtn.prev, .ace_searchbtn.next {padding: 0px 0.7em}.ace_searchbtn.prev:after, .ace_searchbtn.next:after {content: "";border: solid 2px #888;width: 0.5em;height: 0.5em;border-width:  2px 0 0 2px;display:inline-block;transform: rotate(-45deg);}.ace_searchbtn.next:after {border-width: 0 2px 2px 0 ;}.ace_searchbtn_close {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;border-radius: 50%;border: 0 none;color: #656565;cursor: pointer;font: 16px/16px Arial;padding: 0;height: 14px;width: 14px;top: 9px;right: 7px;position: absolute;}.ace_searchbtn_close:hover {background-color: #656565;background-position: 50% 100%;color: white;}.ace_button {margin-left: 2px;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;overflow: hidden;opacity: 0.7;border: 1px solid rgba(100,100,100,0.23);padding: 1px;box-sizing:    border-box!important;color: black;}.ace_button:hover {background-color: #eee;opacity:1;}.ace_button:active {background-color: #ddd;}.ace_button.checked {border-color: #3399ff;opacity:1;}.ace_search_options{margin-bottom: 3px;text-align: right;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;clear: both;}.ace_search_counter {float: left;font-family: arial;padding: 0 8px;}';var HashHandler=acequire("../keyboard/hash_handler").HashHandler;var keyUtil=acequire("../lib/keys");var MAX_COUNT=999;dom.importCssString(searchboxCss,"ace_searchbox");var html='<div class="ace_search right">    <span action="hide" class="ace_searchbtn_close"></span>    <div class="ace_search_form">        <input class="ace_search_field" placeholder="Search for" spellcheck="false"></input>        <span action="findPrev" class="ace_searchbtn prev"></span>        <span action="findNext" class="ace_searchbtn next"></span>        <span action="findAll" class="ace_searchbtn" title="Alt-Enter">All</span>    </div>    <div class="ace_replace_form">        <input class="ace_search_field" placeholder="Replace with" spellcheck="false"></input>        <span action="replaceAndFindNext" class="ace_searchbtn">Replace</span>        <span action="replaceAll" class="ace_searchbtn">All</span>    </div>    <div class="ace_search_options">        <span action="toggleReplace" class="ace_button" title="Toggel Replace mode"            style="float:left;margin-top:-2px;padding:0 5px;">+</span>        <span class="ace_search_counter"></span>        <span action="toggleRegexpMode" class="ace_button" title="RegExp Search">.*</span>        <span action="toggleCaseSensitive" class="ace_button" title="CaseSensitive Search">Aa</span>        <span action="toggleWholeWords" class="ace_button" title="Whole Word Search">\\b</span>        <span action="searchInSelection" class="ace_button" title="Search In Selection">S</span>    </div></div>'.replace(/> +/g,">");var SearchBox=function(editor,range,showReplaceForm){var div=dom.createElement("div");div.innerHTML=html;this.element=div.firstChild;this.setSession=this.setSession.bind(this);this.$init();this.setEditor(editor)};(function(){this.setEditor=function(editor){editor.searchBox=this;editor.renderer.scroller.appendChild(this.element);this.editor=editor};this.setSession=function(e){this.searchRange=null;this.$syncOptions(true)};this.$initElements=function(sb){this.searchBox=sb.querySelector(".ace_search_form");this.replaceBox=sb.querySelector(".ace_replace_form");this.searchOption=sb.querySelector("[action=searchInSelection]");this.replaceOption=sb.querySelector("[action=toggleReplace]");this.regExpOption=sb.querySelector("[action=toggleRegexpMode]");this.caseSensitiveOption=sb.querySelector("[action=toggleCaseSensitive]");this.wholeWordOption=sb.querySelector("[action=toggleWholeWords]");this.searchInput=this.searchBox.querySelector(".ace_search_field");this.replaceInput=this.replaceBox.querySelector(".ace_search_field");this.searchCounter=sb.querySelector(".ace_search_counter")};this.$init=function(){var sb=this.element;this.$initElements(sb);var _this=this;event.addListener(sb,"mousedown",function(e){setTimeout(function(){_this.activeInput.focus()},0);event.stopPropagation(e)});event.addListener(sb,"click",function(e){var t=e.target||e.srcElement;var action=t.getAttribute("action");if(action&&_this[action])_this[action]();else if(_this.$searchBarKb.commands[action])_this.$searchBarKb.commands[action].exec(_this);event.stopPropagation(e)});event.addCommandKeyListener(sb,function(e,hashId,keyCode){var keyString=keyUtil.keyCodeToString(keyCode);var command=_this.$searchBarKb.findKeyCommand(hashId,keyString);if(command&&command.exec){command.exec(_this);event.stopEvent(e)}});this.$onChange=lang.delayedCall(function(){_this.find(false,false)});event.addListener(this.searchInput,"input",function(){_this.$onChange.schedule(20)});event.addListener(this.searchInput,"focus",function(){_this.activeInput=_this.searchInput;_this.searchInput.value&&_this.highlight()});event.addListener(this.replaceInput,"focus",function(){_this.activeInput=_this.replaceInput;_this.searchInput.value&&_this.highlight()})};this.$closeSearchBarKb=new HashHandler([{bindKey:"Esc",name:"closeSearchBar",exec:function(editor){editor.searchBox.hide()}}]);this.$searchBarKb=new HashHandler;this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(sb){var isReplace=sb.isReplace=!sb.isReplace;sb.replaceBox.style.display=isReplace?"":"none";sb.replaceOption.checked=false;sb.$syncOptions();sb.searchInput.focus()},"Ctrl-H|Command-Option-F":function(sb){sb.replaceOption.checked=true;sb.$syncOptions();sb.replaceInput.focus()},"Ctrl-G|Command-G":function(sb){sb.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(sb){sb.findPrev()},"esc":function(sb){setTimeout(function(){sb.hide()})},"Return":function(sb){if(sb.activeInput==sb.replaceInput)sb.replace();sb.findNext()},"Shift-Return":function(sb){if(sb.activeInput==sb.replaceInput)sb.replace();sb.findPrev()},"Alt-Return":function(sb){if(sb.activeInput==sb.replaceInput)sb.replaceAll();sb.findAll()},"Tab":function(sb){(sb.activeInput==sb.replaceInput?sb.searchInput:sb.replaceInput).focus()}});this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(sb){sb.regExpOption.checked=!sb.regExpOption.checked;sb.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(sb){sb.caseSensitiveOption.checked=!sb.caseSensitiveOption.checked;sb.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(sb){sb.wholeWordOption.checked=!sb.wholeWordOption.checked;sb.$syncOptions()}},{name:"toggleReplace",exec:function(sb){sb.replaceOption.checked=!sb.replaceOption.checked;sb.$syncOptions()}},{name:"searchInSelection",exec:function(sb){sb.searchOption.checked=!sb.searchRange;sb.setSearchRange(sb.searchOption.checked&&sb.editor.getSelectionRange());sb.$syncOptions()}}]);this.setSearchRange=function(range){this.searchRange=range;if(range){this.searchRangeMarker=this.editor.session.addMarker(range,"ace_active-line")}else if(this.searchRangeMarker){this.editor.session.removeMarker(this.searchRangeMarker);this.searchRangeMarker=null}};this.$syncOptions=function(preventScroll){dom.setCssClass(this.replaceOption,"checked",this.searchRange);dom.setCssClass(this.searchOption,"checked",this.searchOption.checked);this.replaceOption.textContent=this.replaceOption.checked?"-":"+";dom.setCssClass(this.regExpOption,"checked",this.regExpOption.checked);dom.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked);dom.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);this.replaceBox.style.display=this.replaceOption.checked?"":"none";this.find(false,false,preventScroll)};this.highlight=function(re){this.editor.session.highlight(re||this.editor.$search.$options.re);this.editor.renderer.updateBackMarkers()};this.find=function(skipCurrent,backwards,preventScroll){var range=this.editor.find(this.searchInput.value,{skipCurrent:skipCurrent,backwards:backwards,wrap:true,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:preventScroll,range:this.searchRange});var noMatch=!range&&this.searchInput.value;dom.setCssClass(this.searchBox,"ace_nomatch",noMatch);this.editor._emit("findSearchBox",{match:!noMatch});this.highlight();this.updateCounter()};this.updateCounter=function(){var editor=this.editor;var regex=editor.$search.$options.re;var all=0;var before=0;if(regex){var value=this.searchRange?editor.session.getTextRange(this.searchRange):editor.getValue();var offset=editor.session.doc.positionToIndex(editor.selection.anchor);if(this.searchRange)offset-=editor.session.doc.positionToIndex(this.searchRange.start);var last=regex.lastIndex=0;var m;while(m=regex.exec(value)){all++;last=m.index;if(last<=offset)before++;if(all>MAX_COUNT)break;if(!m[0]){regex.lastIndex=last+=1;if(last>=value.length)break}}}this.searchCounter.textContent=before+" of "+(all>MAX_COUNT?MAX_COUNT+"+":all)};this.findNext=function(){this.find(true,false)};this.findPrev=function(){this.find(true,true)};this.findAll=function(){var range=this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked});var noMatch=!range&&this.searchInput.value;dom.setCssClass(this.searchBox,"ace_nomatch",noMatch);this.editor._emit("findSearchBox",{match:!noMatch});this.highlight();this.hide()};this.replace=function(){if(!this.editor.getReadOnly())this.editor.replace(this.replaceInput.value)};this.replaceAndFindNext=function(){if(!this.editor.getReadOnly()){this.editor.replace(this.replaceInput.value);this.findNext()}};this.replaceAll=function(){if(!this.editor.getReadOnly())this.editor.replaceAll(this.replaceInput.value)};this.hide=function(){this.active=false;this.setSearchRange(null);this.editor.off("changeSession",this.setSession);this.element.style.display="none";this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb);this.editor.focus()};this.show=function(value,isReplace){this.active=true;this.editor.on("changeSession",this.setSession);this.element.style.display="";this.replaceOption.checked=isReplace;if(value)this.searchInput.value=value;this.searchInput.focus();this.searchInput.select();this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb);this.$syncOptions(true)};this.isFocused=function(){var el=document.activeElement;return el==this.searchInput||el==this.replaceInput}}).call(SearchBox.prototype);exports.SearchBox=SearchBox;exports.Search=function(editor,isReplace){var sb=editor.searchBox||new SearchBox(editor);sb.show(editor.session.getTextRange(),isReplace)}});(function(){ace.acequire(["ace/ext/searchbox"],function(){})})()},4750:function(){ace.define("ace/mode/hjson_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(acequire,exports,module){"use strict";var oop=acequire("../lib/oop");var TextHighlightRules=acequire("./text_highlight_rules").TextHighlightRules;var HjsonHighlightRules=function(){this.$rules={start:[{include:"#comments"},{include:"#rootObject"},{include:"#value"}],"#array":[{token:"paren.lparen",regex:/\[/,push:[{token:"paren.rparen",regex:/\]/,next:"pop"},{include:"#value"},{include:"#comments"},{token:"text",regex:/,|$/},{token:"invalid.illegal",regex:/[^\s\]]/},{defaultToken:"array"}]}],"#comments":[{token:["comment.punctuation","comment.line"],regex:/(#)(.*$)/},{token:"comment.punctuation",regex:/\/\*/,push:[{token:"comment.punctuation",regex:/\*\//,next:"pop"},{defaultToken:"comment.block"}]},{token:["comment.punctuation","comment.line"],regex:/(\/\/)(.*$)/}],"#constant":[{token:"constant",regex:/\b(?:true|false|null)\b/}],"#keyname":[{token:"keyword",regex:/(?:[^,\{\[\}\]\s]+|"(?:[^"\\]|\\.)*")\s*(?=:)/}],"#mstring":[{token:"string",regex:/'''/,push:[{token:"string",regex:/'''/,next:"pop"},{defaultToken:"string"}]}],"#number":[{token:"constant.numeric",regex:/-?(?:0|[1-9]\d*)(?:(?:\.\d+)?(?:[eE][+-]?\d+)?)?/,comment:"handles integer and decimal numbers"}],"#object":[{token:"paren.lparen",regex:/\{/,push:[{token:"paren.rparen",regex:/\}/,next:"pop"},{include:"#keyname"},{include:"#value"},{token:"text",regex:/:/},{token:"text",regex:/,/},{defaultToken:"paren"}]}],"#rootObject":[{token:"paren",regex:/(?=\s*(?:[^,\{\[\}\]\s]+|"(?:[^"\\]|\\.)*")\s*:)/,push:[{token:"paren.rparen",regex:/---none---/,next:"pop"},{include:"#keyname"},{include:"#value"},{token:"text",regex:/:/},{token:"text",regex:/,/},{defaultToken:"paren"}]}],"#string":[{token:"string",regex:/"/,push:[{token:"string",regex:/"/,next:"pop"},{token:"constant.language.escape",regex:/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/},{token:"invalid.illegal",regex:/\\./},{defaultToken:"string"}]}],"#ustring":[{token:"string",regex:/\b[^:,0-9\-\{\[\}\]\s].*$/}],"#value":[{include:"#constant"},{include:"#number"},{include:"#string"},{include:"#array"},{include:"#object"},{include:"#comments"},{include:"#mstring"},{include:"#ustring"}]};this.normalizeRules()};HjsonHighlightRules.metaData={fileTypes:["hjson"],foldingStartMarker:"(?x:     # turn on extended mode\n              ^    # a line beginning with\n              \\s*    # some optional space\n              [{\\[]  # the start of an object or array\n              (?!    # but not followed by\n              .*   # whatever\n              [}\\]]  # and the close of an object or array\n              ,?   # an optional comma\n              \\s*  # some optional space\n              $    # at the end of the line\n              )\n              |    # ...or...\n              [{\\[]  # the start of an object or array\n              \\s*    # some optional space\n              $    # at the end of the line\n            )",foldingStopMarker:"(?x:   # turn on extended mode\n             ^    # a line beginning with\n             \\s*  # some optional space\n             [}\\]]  # and the close of an object or array\n             )",keyEquivalent:"^~J",name:"Hjson",scopeName:"source.hjson"};oop.inherits(HjsonHighlightRules,TextHighlightRules);exports.HjsonHighlightRules=HjsonHighlightRules});ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(acequire,exports,module){"use strict";var oop=acequire("../../lib/oop");var Range=acequire("../../range").Range;var BaseFoldMode=acequire("./fold_mode").FoldMode;var FoldMode=exports.FoldMode=function(commentRegex){if(commentRegex){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+commentRegex.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+commentRegex.end))}};oop.inherits(FoldMode,BaseFoldMode);(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(session,foldStyle,row){var line=session.getLine(row);if(this.singleLineBlockCommentRe.test(line)){if(!this.startRegionRe.test(line)&&!this.tripleStarBlockCommentRe.test(line))return""}var fw=this._getFoldWidgetBase(session,foldStyle,row);if(!fw&&this.startRegionRe.test(line))return"start";return fw};this.getFoldWidgetRange=function(session,foldStyle,row,forceMultiline){var line=session.getLine(row);if(this.startRegionRe.test(line))return this.getCommentRegionBlock(session,line,row);var match=line.match(this.foldingStartMarker);if(match){var i=match.index;if(match[1])return this.openingBracketBlock(session,match[1],row,i);var range=session.getCommentFoldRange(row,i+match[0].length,1);if(range&&!range.isMultiLine()){if(forceMultiline){range=this.getSectionRange(session,row)}else if(foldStyle!="all")range=null}return range}if(foldStyle==="markbegin")return;var match=line.match(this.foldingStopMarker);if(match){var i=match.index+match[0].length;if(match[1])return this.closingBracketBlock(session,match[1],row,i);return session.getCommentFoldRange(row,i,-1)}};this.getSectionRange=function(session,row){var line=session.getLine(row);var startIndent=line.search(/\S/);var startRow=row;var startColumn=line.length;row=row+1;var endRow=row;var maxRow=session.getLength();while(++row<maxRow){line=session.getLine(row);var indent=line.search(/\S/);if(indent===-1)continue;if(startIndent>indent)break;var subRange=this.getFoldWidgetRange(session,"all",row);if(subRange){if(subRange.start.row<=startRow){break}else if(subRange.isMultiLine()){row=subRange.end.row}else if(startIndent==indent){break}}endRow=row}return new Range(startRow,startColumn,endRow,session.getLine(endRow).length)};this.getCommentRegionBlock=function(session,line,row){var startColumn=line.search(/\s*$/);var maxRow=session.getLength();var startRow=row;var re=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;var depth=1;while(++row<maxRow){line=session.getLine(row);var m=re.exec(line);if(!m)continue;if(m[1])depth--;else depth++;if(!depth)break}var endRow=row;if(endRow>startRow){return new Range(startRow,startColumn,endRow,line.length)}}}).call(FoldMode.prototype)});ace.define("ace/mode/hjson",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/hjson_highlight_rules","ace/mode/folding/cstyle"],function(acequire,exports,module){"use strict";var oop=acequire("../lib/oop");var TextMode=acequire("./text").Mode;var HjsonHighlightRules=acequire("./hjson_highlight_rules").HjsonHighlightRules;var FoldMode=acequire("./folding/cstyle").FoldMode;var Mode=function(){this.HighlightRules=HjsonHighlightRules;this.foldingRules=new FoldMode};oop.inherits(Mode,TextMode);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.$id="ace/mode/hjson"}).call(Mode.prototype);exports.Mode=Mode})},7252:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVis{display:flex;flex:1 1 100%;position:relative}.vgaVis__view{z-index:0;flex:1 1 100%;display:block;max-width:100%;max-height:100%;width:100%;height:100%}.vgaVis__view .vega-bindings{display:none !important}.vgaVis__controls{font-size:14px;font-size:0.875rem;line-height:1.5;display:flex}.vgaVis__controls:not(:empty){padding:8px 0}.vgaVis__controls.vgaVis__controls--column{flex-direction:column}.vgaVis__controls.vgaVis__controls--row{flex-direction:row}.vgaVis__controls.vgaVis__controls--row>.vega-bind{flex-grow:1}.vgaVis__controls>.vega-bind .vega-bind-name{display:inline-block;width:104px}.vgaVis__controls>.vega-bind input[type=range]{width:120px;display:inline-block;vertical-align:middle}.vgaVis__controls>.vega-bind label{margin:0 0 0 8px}.vgaVis__controls>.vega-bind select{max-width:160px}.vgaVis__controls>.vega-bind .vega-bind-radio label{margin:0 8px 0 4px}.vgaVis__messages{position:absolute;top:0;width:100%;margin:auto;opacity:.8;z-index:1;list-style:none}.vgaVis__message{margin:8px}.vgaVis__message .vgaVis__messageCode{white-space:pre-wrap;padding:8px}.vgaVis__message--warn .vgaVis__messageCode{background-color:rgb(76.5,61.8,36.6);color:#ffce7a}.vgaVis__message--err .vgaVis__messageCode{background-color:rgb(76.5,30.6,30.6);color:#f66}.vgaVis__tooltip{max-width:100%;position:fixed}.vgaVis__tooltip h2{margin-bottom:8px}.vgaVis__tooltip td{max-width:100%;overflow:hidden !important;text-overflow:ellipsis !important;white-space:nowrap !important;word-wrap:normal !important;padding-top:4px;padding-bottom:4px}.vgaVis__tooltip td.key{color:#535966;max-width:160px;text-align:right;padding-right:4px}.vgaVis__tooltip td.value{max-width:240px;text-align:left}@media only screen and (max-width: 768px){.vgaVis__tooltip td.key{max-width:96px}.vgaVis__tooltip td.value{max-width:160px}}.visEditor--vega .visEditorSidebar__config{padding:0}@media only screen and (max-width: 574px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(152,162,179,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 575px)and (max-width: 767px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(152,162,179,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 768px)and (max-width: 991px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(152,162,179,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}.vgaEditor__aceEditorActions{position:absolute;z-index:1000;top:8px;right:40px;line-height:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},8356:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVegaDataInspector,.vgaVegaDataInspector__specViewer{height:100%}.vgaVegaDataInspector{display:flex;flex-direction:column}.vgaVegaDataInspector [role=tablist]{flex-shrink:0}.vgaVegaDataInspector [role=tabpanel]{flex-grow:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},470:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVis{display:flex;flex:1 1 100%;position:relative}.vgaVis__view{z-index:0;flex:1 1 100%;display:block;max-width:100%;max-height:100%;width:100%;height:100%}.vgaVis__view .vega-bindings{display:none !important}.vgaVis__controls{font-size:14px;font-size:0.875rem;line-height:1.5;display:flex}.vgaVis__controls:not(:empty){padding:8px 0}.vgaVis__controls.vgaVis__controls--column{flex-direction:column}.vgaVis__controls.vgaVis__controls--row{flex-direction:row}.vgaVis__controls.vgaVis__controls--row>.vega-bind{flex-grow:1}.vgaVis__controls>.vega-bind .vega-bind-name{display:inline-block;width:104px}.vgaVis__controls>.vega-bind input[type=range]{width:120px;display:inline-block;vertical-align:middle}.vgaVis__controls>.vega-bind label{margin:0 0 0 8px}.vgaVis__controls>.vega-bind select{max-width:160px}.vgaVis__controls>.vega-bind .vega-bind-radio label{margin:0 8px 0 4px}.vgaVis__messages{position:absolute;top:0;width:100%;margin:auto;opacity:.8;z-index:1;list-style:none}.vgaVis__message{margin:8px}.vgaVis__message .vgaVis__messageCode{white-space:pre-wrap;padding:8px}.vgaVis__message--warn .vgaVis__messageCode{background-color:rgb(254,246.2,229.5);color:rgb(146.6905501134,99.9890688528,0)}.vgaVis__message--err .vgaVis__messageCode{background-color:rgb(248.4,233.4,232.5);color:#bd271e}.vgaVis__tooltip{max-width:100%;position:fixed}.vgaVis__tooltip h2{margin-bottom:8px}.vgaVis__tooltip td{max-width:100%;overflow:hidden !important;text-overflow:ellipsis !important;white-space:nowrap !important;word-wrap:normal !important;padding-top:4px;padding-bottom:4px}.vgaVis__tooltip td.key{color:#98a2b3;max-width:160px;text-align:right;padding-right:4px}.vgaVis__tooltip td.value{max-width:240px;text-align:left}@media only screen and (max-width: 768px){.vgaVis__tooltip td.key{max-width:96px}.vgaVis__tooltip td.value{max-width:160px}}.visEditor--vega .visEditorSidebar__config{padding:0}@media only screen and (max-width: 574px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(105,112,125,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 575px)and (max-width: 767px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(105,112,125,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 768px)and (max-width: 991px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(105,112,125,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}.vgaEditor__aceEditorActions{position:absolute;z-index:1000;top:8px;right:40px;line-height:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},574:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVegaDataInspector,.vgaVegaDataInspector__specViewer{height:100%}.vgaVegaDataInspector{display:flex;flex-direction:column}.vgaVegaDataInspector [role=tablist]{flex-shrink:0}.vgaVegaDataInspector [role=tabpanel]{flex-grow:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},3919:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVis{display:flex;flex:1 1 100%;position:relative}.vgaVis__view{z-index:0;flex:1 1 100%;display:block;max-width:100%;max-height:100%;width:100%;height:100%}.vgaVis__view .vega-bindings{display:none !important}.vgaVis__controls{font-size:15.75px;font-size:0.875rem;line-height:1.333333;display:flex}.vgaVis__controls:not(:empty){padding:8px 0}.vgaVis__controls.vgaVis__controls--column{flex-direction:column}.vgaVis__controls.vgaVis__controls--row{flex-direction:row}.vgaVis__controls.vgaVis__controls--row>.vega-bind{flex-grow:1}.vgaVis__controls>.vega-bind .vega-bind-name{display:inline-block;width:104px}.vgaVis__controls>.vega-bind input[type=range]{width:120px;display:inline-block;vertical-align:middle}.vgaVis__controls>.vega-bind label{margin:0 0 0 8px}.vgaVis__controls>.vega-bind select{max-width:160px}.vgaVis__controls>.vega-bind .vega-bind-radio label{margin:0 8px 0 4px}.vgaVis__messages{position:absolute;top:0;width:100%;margin:auto;opacity:.8;z-index:1;list-style:none}.vgaVis__message{margin:8px}.vgaVis__message .vgaVis__messageCode{white-space:pre-wrap;padding:8px}.vgaVis__message--warn .vgaVis__messageCode{background-color:rgb(83.5,74.4,54.8);color:#ffce7a}.vgaVis__message--err .vgaVis__messageCode{background-color:rgb(83.5,43.2,48.8);color:rgb(254.7075,116.82,116.9175)}.vgaVis__tooltip{max-width:100%;position:fixed}.vgaVis__tooltip h2{margin-bottom:8px}.vgaVis__tooltip td{max-width:100%;overflow:hidden !important;text-overflow:ellipsis !important;white-space:nowrap !important;word-wrap:normal !important;padding-top:4px;padding-bottom:4px}.vgaVis__tooltip td.key{color:#5b6875;max-width:160px;text-align:right;padding-right:4px}.vgaVis__tooltip td.value{max-width:240px;text-align:left}@media only screen and (max-width: 768px){.vgaVis__tooltip td.key{max-width:96px}.vgaVis__tooltip td.value{max-width:160px}}.visEditor--vega .visEditorSidebar__config{padding:0}@media only screen and (max-width: 574px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(141,152,163,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 575px)and (max-width: 767px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(141,152,163,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 768px)and (max-width: 991px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(141,152,163,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}.vgaEditor__aceEditorActions{position:absolute;z-index:1000;top:8px;right:40px;line-height:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},9903:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVegaDataInspector,.vgaVegaDataInspector__specViewer{height:100%}.vgaVegaDataInspector{display:flex;flex-direction:column}.vgaVegaDataInspector [role=tablist]{flex-shrink:0}.vgaVegaDataInspector [role=tabpanel]{flex-grow:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},8895:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVis{display:flex;flex:1 1 100%;position:relative}.vgaVis__view{z-index:0;flex:1 1 100%;display:block;max-width:100%;max-height:100%;width:100%;height:100%}.vgaVis__view .vega-bindings{display:none !important}.vgaVis__controls{font-size:15.75px;font-size:0.875rem;line-height:1.333333;display:flex}.vgaVis__controls:not(:empty){padding:8px 0}.vgaVis__controls.vgaVis__controls--column{flex-direction:column}.vgaVis__controls.vgaVis__controls--row{flex-direction:row}.vgaVis__controls.vgaVis__controls--row>.vega-bind{flex-grow:1}.vgaVis__controls>.vega-bind .vega-bind-name{display:inline-block;width:104px}.vgaVis__controls>.vega-bind input[type=range]{width:120px;display:inline-block;vertical-align:middle}.vgaVis__controls>.vega-bind label{margin:0 0 0 8px}.vgaVis__controls>.vega-bind select{max-width:160px}.vgaVis__controls>.vega-bind .vega-bind-radio label{margin:0 8px 0 4px}.vgaVis__messages{position:absolute;top:0;width:100%;margin:auto;opacity:.8;z-index:1;list-style:none}.vgaVis__message{margin:8px}.vgaVis__message .vgaVis__messageCode{white-space:pre-wrap;padding:8px}.vgaVis__message--warn .vgaVis__messageCode{background-color:rgb(251.3,245.3,229.5);color:rgb(143.668021685,102.7512137492,11.2111976008)}.vgaVis__message--err .vgaVis__messageCode{background-color:rgb(245.7,232.5,232.5);color:#bd271e}.vgaVis__tooltip{max-width:100%;position:fixed}.vgaVis__tooltip h2{margin-bottom:8px}.vgaVis__tooltip td{max-width:100%;overflow:hidden !important;text-overflow:ellipsis !important;white-space:nowrap !important;word-wrap:normal !important;padding-top:4px;padding-bottom:4px}.vgaVis__tooltip td.key{color:#adb4ba;max-width:160px;text-align:right;padding-right:4px}.vgaVis__tooltip td.value{max-width:240px;text-align:left}@media only screen and (max-width: 768px){.vgaVis__tooltip td.key{max-width:96px}.vgaVis__tooltip td.value{max-width:160px}}.visEditor--vega .visEditorSidebar__config{padding:0}@media only screen and (max-width: 574px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(90,104,117,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 575px)and (max-width: 767px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(90,104,117,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 768px)and (max-width: 991px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(90,104,117,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}.vgaEditor__aceEditorActions{position:absolute;z-index:1000;top:8px;right:40px;line-height:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},9335:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVegaDataInspector,.vgaVegaDataInspector__specViewer{height:100%}.vgaVegaDataInspector{display:flex;flex-direction:column}.vgaVegaDataInspector [role=tablist]{flex-shrink:0}.vgaVegaDataInspector [role=tabpanel]{flex-grow:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},2690:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVis{display:flex;flex:1 1 100%;position:relative}.vgaVis__view{z-index:0;flex:1 1 100%;display:block;max-width:100%;max-height:100%;width:100%;height:100%}.vgaVis__view .vega-bindings{display:none !important}.vgaVis__controls{font-size:14px;font-size:1rem;line-height:1.5;display:flex}.vgaVis__controls:not(:empty){padding:8px 0}.vgaVis__controls.vgaVis__controls--column{flex-direction:column}.vgaVis__controls.vgaVis__controls--row{flex-direction:row}.vgaVis__controls.vgaVis__controls--row>.vega-bind{flex-grow:1}.vgaVis__controls>.vega-bind .vega-bind-name{display:inline-block;width:104px}.vgaVis__controls>.vega-bind input[type=range]{width:120px;display:inline-block;vertical-align:middle}.vgaVis__controls>.vega-bind label{margin:0 0 0 8px}.vgaVis__controls>.vega-bind select{max-width:160px}.vgaVis__controls>.vega-bind .vega-bind-radio label{margin:0 8px 0 4px}.vgaVis__messages{position:absolute;top:0;width:100%;margin:auto;opacity:.8;z-index:1;list-style:none}.vgaVis__message{margin:8px}.vgaVis__message .vgaVis__messageCode{white-space:pre-wrap;padding:8px}.vgaVis__message--warn .vgaVis__messageCode{background-color:rgb(74.6,53.6,21.5);color:#f4ae27}.vgaVis__message--err .vgaVis__messageCode{background-color:rgb(62.9,29.3,35.6);color:rgb(209.0808625,118.22715,113.26758125)}.vgaVis__tooltip{max-width:100%;position:fixed}.vgaVis__tooltip h2{margin-bottom:8px}.vgaVis__tooltip td{max-width:100%;overflow:hidden !important;text-overflow:ellipsis !important;white-space:nowrap !important;word-wrap:normal !important;padding-top:4px;padding-bottom:4px}.vgaVis__tooltip td.key{color:#5c666f;max-width:160px;text-align:right;padding-right:4px}.vgaVis__tooltip td.value{max-width:240px;text-align:left}@media only screen and (max-width: 768px){.vgaVis__tooltip td.key{max-width:96px}.vgaVis__tooltip td.value{max-width:160px}}.visEditor--vega .visEditorSidebar__config{padding:0}@media only screen and (max-width: 574px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(149,155,162,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 575px)and (max-width: 767px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(149,155,162,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 768px)and (max-width: 991px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(149,155,162,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}.vgaEditor__aceEditorActions{position:absolute;z-index:1000;top:8px;right:40px;line-height:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},1122:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVegaDataInspector,.vgaVegaDataInspector__specViewer{height:100%}.vgaVegaDataInspector{display:flex;flex-direction:column}.vgaVegaDataInspector [role=tablist]{flex-shrink:0}.vgaVegaDataInspector [role=tabpanel]{flex-grow:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},7240:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVis{display:flex;flex:1 1 100%;position:relative}.vgaVis__view{z-index:0;flex:1 1 100%;display:block;max-width:100%;max-height:100%;width:100%;height:100%}.vgaVis__view .vega-bindings{display:none !important}.vgaVis__controls{font-size:14px;font-size:1rem;line-height:1.5;display:flex}.vgaVis__controls:not(:empty){padding:8px 0}.vgaVis__controls.vgaVis__controls--column{flex-direction:column}.vgaVis__controls.vgaVis__controls--row{flex-direction:row}.vgaVis__controls.vgaVis__controls--row>.vega-bind{flex-grow:1}.vgaVis__controls>.vega-bind .vega-bind-name{display:inline-block;width:104px}.vgaVis__controls>.vega-bind input[type=range]{width:120px;display:inline-block;vertical-align:middle}.vgaVis__controls>.vega-bind label{margin:0 0 0 8px}.vgaVis__controls>.vega-bind select{max-width:160px}.vgaVis__controls>.vega-bind .vega-bind-radio label{margin:0 8px 0 4px}.vgaVis__messages{position:absolute;top:0;width:100%;margin:auto;opacity:.8;z-index:1;list-style:none}.vgaVis__message{margin:8px}.vgaVis__message .vgaVis__messageCode{white-space:pre-wrap;padding:8px}.vgaVis__message--warn .vgaVis__messageCode{background-color:rgb(249.2,244.7,234.3);color:hsl(37.6278301442,60.045436983%,34.7733037038%)}.vgaVis__message--err .vgaVis__messageCode{background-color:rgb(246.4,234.7,234.8);color:rgb(186.3,58.05,51.05)}.vgaVis__tooltip{max-width:100%;position:fixed}.vgaVis__tooltip h2{margin-bottom:8px}.vgaVis__tooltip td{max-width:100%;overflow:hidden !important;text-overflow:ellipsis !important;white-space:nowrap !important;word-wrap:normal !important;padding-top:4px;padding-bottom:4px}.vgaVis__tooltip td.key{color:#adb4ba;max-width:160px;text-align:right;padding-right:4px}.vgaVis__tooltip td.value{max-width:240px;text-align:left}@media only screen and (max-width: 768px){.vgaVis__tooltip td.key{max-width:96px}.vgaVis__tooltip td.value{max-width:160px}}.visEditor--vega .visEditorSidebar__config{padding:0}@media only screen and (max-width: 574px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(90,104,117,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 575px)and (max-width: 767px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(90,104,117,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}@media only screen and (min-width: 768px)and (max-width: 991px){.vgaEditor{scrollbar-width:thin}.vgaEditor::-webkit-scrollbar{width:16px;height:16px}.vgaEditor::-webkit-scrollbar-thumb{background-color:rgba(90,104,117,.5);border:6px solid rgba(0,0,0,0);background-clip:content-box}.vgaEditor::-webkit-scrollbar-corner,.vgaEditor::-webkit-scrollbar-track{background-color:rgba(0,0,0,0)}.vgaEditor{max-height:240px;overflow-y:auto}}.vgaEditor__aceEditorActions{position:absolute;z-index:1000;top:8px;right:40px;line-height:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},6464:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{"default":()=>__WEBPACK_DEFAULT_EXPORT__});var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5248);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});___CSS_LOADER_EXPORT___.push([module.id,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.vgaVegaDataInspector,.vgaVegaDataInspector__specViewer{height:100%}.vgaVegaDataInspector{display:flex;flex-direction:column}.vgaVegaDataInspector [role=tablist]{flex-shrink:0}.vgaVegaDataInspector [role=tabpanel]{flex-grow:1}\n",""]);const __WEBPACK_DEFAULT_EXPORT__=___CSS_LOADER_EXPORT___},5248:function(module){"use strict";module.exports=function(cssWithMappingToString){var list=[];list.toString=function toString(){return this.map(function(item){var content=cssWithMappingToString(item);if(item[2]){return"@media ".concat(item[2]," {").concat(content,"}")}return content}).join("")};list.i=function(modules,mediaQuery,dedupe){if(typeof modules==="string"){modules=[[null,modules,""]]}var alreadyImportedModules={};if(dedupe){for(var i=0;i<this.length;i++){var id=this[i][0];if(id!=null){alreadyImportedModules[id]=true}}}for(var _i=0;_i<modules.length;_i++){var item=[].concat(modules[_i]);if(dedupe&&alreadyImportedModules[item[0]]){continue}if(mediaQuery){if(!item[2]){item[2]=mediaQuery}else{item[2]="".concat(mediaQuery," and ").concat(item[2])}}list.push(item)}};return list}},1112:function(module,__unused_webpack_exports,__webpack_require__){"use strict";var common=__webpack_require__(7391);function makeComment(b,a,x){var c;if(b)c={b:b};if(a)(c=c||{}).a=a;if(x)(c=c||{}).x=x;return c}function extractComments(value,root){if(value===null||typeof value!=="object")return;var comments=common.getComment(value);if(comments)common.removeComment(value);var i,length;var any,res;if(Object.prototype.toString.apply(value)==="[object Array]"){res={a:{}};for(i=0,length=value.length;i<length;i++){if(saveComment(res.a,i,comments.a[i],extractComments(value[i])))any=true}if(!any&&comments.e){res.e=makeComment(comments.e[0],comments.e[1]);any=true}}else{res={s:{}};var keys,currentKeys=Object.keys(value);if(comments&&comments.o){keys=[];comments.o.concat(currentKeys).forEach(function(key){if(Object.prototype.hasOwnProperty.call(value,key)&&keys.indexOf(key)<0)keys.push(key)})}else keys=currentKeys;res.o=keys;for(i=0,length=keys.length;i<length;i++){var key=keys[i];if(saveComment(res.s,key,comments.c[key],extractComments(value[key])))any=true}if(!any&&comments.e){res.e=makeComment(comments.e[0],comments.e[1]);any=true}}if(root&&comments&&comments.r){res.r=makeComment(comments.r[0],comments.r[1])}return any?res:undefined}function mergeStr(){var res="";[].forEach.call(arguments,function(c){if(c&&c.trim()!==""){if(res)res+="; ";res+=c.trim()}});return res}function mergeComments(comments,value){var dropped=[];merge(comments,value,dropped,[]);if(dropped.length>0){var text=rootComment(value,null,1);text+="\n# Orphaned comments:\n";dropped.forEach(function(c){text+=("# "+c.path.join("/")+": "+mergeStr(c.b,c.a,c.e)).replace("\n","\\n ")+"\n"});rootComment(value,text,1)}}function saveComment(res,key,item,col){var c=makeComment(item?item[0]:undefined,item?item[1]:undefined,col);if(c)res[key]=c;return c}function droppedComment(path,c){var res=makeComment(c.b,c.a);res.path=path;return res}function dropAll(comments,dropped,path){if(!comments)return;var i,length;if(comments.a){for(i=0,length=comments.a.length;i<length;i++){var kpath=path.slice().concat([i]);var c=comments.a[i];if(c){dropped.push(droppedComment(kpath,c));dropAll(c.x,dropped,kpath)}}}else if(comments.o){comments.o.forEach(function(key){var kpath=path.slice().concat([key]);var c=comments.s[key];if(c){dropped.push(droppedComment(kpath,c));dropAll(c.x,dropped,kpath)}})}if(comments.e)dropped.push(droppedComment(path,comments.e))}function merge(comments,value,dropped,path){if(!comments)return;if(value===null||typeof value!=="object"){dropAll(comments,dropped,path);return}var i;var setComments=common.createComment(value);if(path.length===0&&comments.r)setComments.r=[comments.r.b,comments.r.a];if(Object.prototype.toString.apply(value)==="[object Array]"){setComments.a=[];var a=comments.a||{};for(var key in a){if(a.hasOwnProperty(key)){i=parseInt(key);var c=comments.a[key];if(c){var kpath=path.slice().concat([i]);if(i<value.length){setComments.a[i]=[c.b,c.a];merge(c.x,value[i],dropped,kpath)}else{dropped.push(droppedComment(kpath,c));dropAll(c.x,dropped,kpath)}}}}if(i===0&&comments.e)setComments.e=[comments.e.b,comments.e.a]}else{setComments.c={};setComments.o=[];(comments.o||[]).forEach(function(key){var kpath=path.slice().concat([key]);var c=comments.s[key];if(Object.prototype.hasOwnProperty.call(value,key)){setComments.o.push(key);if(c){setComments.c[key]=[c.b,c.a];merge(c.x,value[key],dropped,kpath)}}else if(c){dropped.push(droppedComment(kpath,c));dropAll(c.x,dropped,kpath)}});if(comments.e)setComments.e=[comments.e.b,comments.e.a]}}function rootComment(value,setText,header){var comment=common.createComment(value,common.getComment(value));if(!comment.r)comment.r=["",""];if(setText||setText==="")comment.r[header]=common.forceComment(setText);return comment.r[header]||""}module.exports={extract:function(value){return extractComments(value,true)},merge:mergeComments,header:function(value,setText){return rootComment(value,setText,0)},footer:function(value,setText){return rootComment(value,setText,1)}}},7391:function(module,__unused_webpack_exports,__webpack_require__){"use strict";var os=__webpack_require__(4090);function tryParseNumber(text,stopAtNext){var number,string="",leadingZeros=0,testLeading=true;var at=0;var ch;function next(){ch=text.charAt(at);at++;return ch}next();if(ch==="-"){string="-";next()}while(ch>="0"&&ch<="9"){if(testLeading){if(ch=="0")leadingZeros++;else testLeading=false}string+=ch;next()}if(testLeading)leadingZeros--;if(ch==="."){string+=".";while(next()&&ch>="0"&&ch<="9")string+=ch}if(ch==="e"||ch==="E"){string+=ch;next();if(ch==="-"||ch==="+"){string+=ch;next()}while(ch>="0"&&ch<="9"){string+=ch;next()}}while(ch&&ch<=" ")next();if(stopAtNext){if(ch===","||ch==="}"||ch==="]"||ch==="#"||ch==="/"&&(text[at]==="/"||text[at]==="*"))ch=0}number=+string;if(ch||leadingZeros||!isFinite(number))return undefined;else return number}function createComment(value,comment){if(Object.defineProperty)Object.defineProperty(value,"__COMMENTS__",{enumerable:false,writable:true});return value.__COMMENTS__=comment||{}}function removeComment(value){Object.defineProperty(value,"__COMMENTS__",{value:undefined})}function getComment(value){return value.__COMMENTS__}function forceComment(text){if(!text)return"";var a=text.split("\n");var str,i,j,len;for(j=0;j<a.length;j++){str=a[j];len=str.length;for(i=0;i<len;i++){var c=str[i];if(c==="#")break;else if(c==="/"&&(str[i+1]==="/"||str[i+1]==="*")){if(str[i+1]==="*")j=a.length;break}else if(c>" "){a[j]="# "+str;break}}}return a.join("\n")}module.exports={EOL:os.EOL||"\n",tryParseNumber:tryParseNumber,createComment:createComment,removeComment:removeComment,getComment:getComment,forceComment:forceComment}},8297:function(module){"use strict";function loadDsf(col,type){if(Object.prototype.toString.apply(col)!=="[object Array]"){if(col)throw new Error("dsf option must contain an array!");else return nopDsf}else if(col.length===0)return nopDsf;var dsf=[];function isFunction(f){return({}).toString.call(f)==="[object Function]"}col.forEach(function(x){if(!x.name||!isFunction(x.parse)||!isFunction(x.stringify))throw new Error("extension does not match the DSF interface");dsf.push(function(){try{if(type=="parse"){return x.parse.apply(null,arguments)}else if(type=="stringify"){var res=x.stringify.apply(null,arguments);if(res!==undefined&&(typeof res!=="string"||res.length===0||res[0]==='"'||[].some.call(res,function(c){return isInvalidDsfChar(c)})))throw new Error("value may not be empty, start with a quote or contain a punctuator character except colon: "+res);return res}else throw new Error("Invalid type")}catch(e){throw new Error("DSF-"+x.name+" failed; "+e.message)}})});return runDsf.bind(null,dsf)}function runDsf(dsf,value){if(dsf){for(var i=0;i<dsf.length;i++){var res=dsf[i](value);if(res!==undefined)return res}}}function nopDsf(){}function isInvalidDsfChar(c){return c==="{"||c==="}"||c==="["||c==="]"||c===","}function math(){return{name:"math",parse:function(value){switch(value){case"+inf":case"inf":case"+Inf":case"Inf":return Infinity;case"-inf":case"-Inf":return-Infinity;case"nan":case"NaN":return NaN}},stringify:function(value){if(typeof value!=="number")return;if(1/value===-Infinity)return"-0";if(value===Infinity)return"Inf";if(value===-Infinity)return"-Inf";if(isNaN(value))return"NaN"}}}math.description="support for Inf/inf, -Inf/-inf, Nan/naN and -0";function hex(opt){var out=opt&&opt.out;return{name:"hex",parse:function(value){if(/^0x[0-9A-Fa-f]+$/.test(value))return parseInt(value,16)},stringify:function(value){if(out&&Number.isInteger(value))return"0x"+value.toString(16)}}}hex.description="parse hexadecimal numbers prefixed with 0x";function date(){return{name:"date",parse:function(value){if(/^\d{4}-\d{2}-\d{2}$/.test(value)||/^\d{4}-\d{2}-\d{2}T\d{2}\:\d{2}\:\d{2}(?:.\d+)(?:Z|[+-]\d{2}:\d{2})$/.test(value)){var dt=Date.parse(value);if(!isNaN(dt))return new Date(dt)}},stringify:function(value){if(Object.prototype.toString.call(value)==="[object Date]"){var dt=value.toISOString();if(dt.indexOf("T00:00:00.000Z",dt.length-14)!==-1)return dt.substr(0,10);else return dt}}}}date.description="support ISO dates";module.exports={loadDsf:loadDsf,std:{math:math,hex:hex,date:date}}},7639:function(module,__unused_webpack_exports,__webpack_require__){"use strict";module.exports=function(source,opt){var common=__webpack_require__(7391);var dsf=__webpack_require__(8297);var text;var at;var ch;var escapee={'"':'"',"'":"'","\\":"\\","/":"/",b:"\b",f:"\f",n:"\n",r:"\r",t:"	"};var keepComments;var runDsf;function resetAt(){at=0;ch=" "}function isPunctuatorChar(c){return c==="{"||c==="}"||c==="["||c==="]"||c===","||c===":"}function error(m){var i,col=0,line=1;for(i=at-1;i>0&&text[i]!=="\n";i--,col++){}for(;i>0;i--)if(text[i]==="\n")line++;throw new Error(m+" at line "+line+","+col+" >>>"+text.substr(at-col,20)+" ...")}function next(){ch=text.charAt(at);at++;return ch}function peek(offs){return text.charAt(at+offs)}function string(allowML){var string="";var exitCh=ch;while(next()){if(ch===exitCh){next();if(allowML&&exitCh==="'"&&ch==="'"&&string.length===0){next();return mlString()}else return string}if(ch==="\\"){next();if(ch==="u"){var uffff=0;for(var i=0;i<4;i++){next();var c=ch.charCodeAt(0),hex;if(ch>="0"&&ch<="9")hex=c-48;else if(ch>="a"&&ch<="f")hex=c-97+10;else if(ch>="A"&&ch<="F")hex=c-65+10;else error("Bad \\u char "+ch);uffff=uffff*16+hex}string+=String.fromCharCode(uffff)}else if(typeof escapee[ch]==="string"){string+=escapee[ch]}else break}else if(ch==="\n"||ch==="\r"){error("Bad string containing newline")}else{string+=ch}}error("Bad string")}function mlString(){var string="",triple=0;var indent=0;for(;;){var c=peek(-indent-5);if(!c||c==="\n")break;indent++}function skipIndent(){var skip=indent;while(ch&&ch<=" "&&ch!=="\n"&&skip-- >0)next()}while(ch&&ch<=" "&&ch!=="\n")next();if(ch==="\n"){next();skipIndent()}for(;;){if(!ch){error("Bad multiline string")}else if(ch==="'"){triple++;next();if(triple===3){if(string.slice(-1)==="\n")string=string.slice(0,-1);return string}else continue}else{while(triple>0){string+="'";triple--}}if(ch==="\n"){string+="\n";next();skipIndent()}else{if(ch!=="\r")string+=ch;next()}}}function keyname(){if(ch==='"'||ch==="'")return string(false);var name="",start=at,space=-1;for(;;){if(ch===":"){if(!name)error("Found ':' but no key name (for an empty key name use quotes)");else if(space>=0&&space!==name.length){at=start+space;error("Found whitespace in your key name (use quotes to include)")}return name}else if(ch<=" "){if(!ch)error("Found EOF while looking for a key name (check your syntax)");else if(space<0)space=name.length}else if(isPunctuatorChar(ch)){error("Found '"+ch+"' where a key name was expected (check your syntax or use quotes if the key name includes {}[],: or whitespace)")}else{name+=ch}next()}}function white(){while(ch){while(ch&&ch<=" ")next();if(ch==="#"||ch==="/"&&peek(0)==="/"){while(ch&&ch!=="\n")next()}else if(ch==="/"&&peek(0)==="*"){next();next();while(ch&&!(ch==="*"&&peek(0)==="/"))next();if(ch){next();next()}}else break}}function tfnns(){var value=ch;if(isPunctuatorChar(ch))error("Found a punctuator character '"+ch+"' when expecting a quoteless string (check your syntax)");for(;;){next();var isEol=ch==="\r"||ch==="\n"||ch==="";if(isEol||ch===","||ch==="}"||ch==="]"||ch==="#"||ch==="/"&&(peek(0)==="/"||peek(0)==="*")){var chf=value[0];switch(chf){case"f":if(value.trim()==="false")return false;break;case"n":if(value.trim()==="null")return null;break;case"t":if(value.trim()==="true")return true;break;default:if(chf==="-"||chf>="0"&&chf<="9"){var n=common.tryParseNumber(value);if(n!==undefined)return n}}if(isEol){value=value.trim();var dsfValue=runDsf(value);return dsfValue!==undefined?dsfValue:value}}value+=ch}}function getComment(cAt,first){var i;cAt--;for(i=at-2;i>cAt&&text[i]<=" "&&text[i]!=="\n";i--);if(text[i]==="\n")i--;if(text[i]==="\r")i--;var res=text.substr(cAt,i-cAt+1);for(i=0;i<res.length;i++){if(res[i]>" "){var j=res.indexOf("\n");if(j>=0){var c=[res.substr(0,j),res.substr(j+1)];if(first&&c[0].trim().length===0)c.shift();return c}else return[res]}}return[]}function errorClosingHint(value){function search(value,ch){var i,k,length,res;switch(typeof value){case"string":if(value.indexOf(ch)>=0)res=value;break;case"object":if(Object.prototype.toString.apply(value)==="[object Array]"){for(i=0,length=value.length;i<length;i++){res=search(value[i],ch)||res}}else{for(k in value){if(!Object.prototype.hasOwnProperty.call(value,k))continue;res=search(value[k],ch)||res}}}return res}function report(ch){var possibleErr=search(value,ch);if(possibleErr){return"found '"+ch+"' in a string value, your mistake could be with:\n"+"  > "+possibleErr+"\n"+"  (unquoted strings contain everything up to the next line!)"}else return""}return report("}")||report("]")}function array(){var array=[];var comments,cAt,nextComment;try{if(keepComments)comments=common.createComment(array,{a:[]});next();cAt=at;white();if(comments)nextComment=getComment(cAt,true).join("\n");if(ch==="]"){next();if(comments)comments.e=[nextComment];return array}while(ch){array.push(value());cAt=at;white();if(ch===","){next();cAt=at;white()}if(comments){var c=getComment(cAt);comments.a.push([nextComment||"",c[0]||""]);nextComment=c[1]}if(ch==="]"){next();if(comments)comments.a[comments.a.length-1][1]+=nextComment||"";return array}white()}error("End of input while parsing an array (missing ']')")}catch(e){e.hint=e.hint||errorClosingHint(array);throw e}}function object(withoutBraces){var key="",object={};var comments,cAt,nextComment;try{if(keepComments)comments=common.createComment(object,{c:{},o:[]});if(!withoutBraces){next();cAt=at}else cAt=1;white();if(comments)nextComment=getComment(cAt,true).join("\n");if(ch==="}"&&!withoutBraces){if(comments)comments.e=[nextComment];next();return object}while(ch){key=keyname();white();if(ch!==":")error("Expected ':' instead of '"+ch+"'");next();object[key]=value();cAt=at;white();if(ch===","){next();cAt=at;white()}if(comments){var c=getComment(cAt);comments.c[key]=[nextComment||"",c[0]||""];nextComment=c[1];comments.o.push(key)}if(ch==="}"&&!withoutBraces){next();if(comments)comments.c[key][1]+=nextComment||"";return object}white()}if(withoutBraces)return object;else error("End of input while parsing an object (missing '}')")}catch(e){e.hint=e.hint||errorClosingHint(object);throw e}}function value(){white();switch(ch){case"{":return object();case"[":return array();case"'":case'"':return string(true);default:return tfnns()}}function checkTrailing(v,c){var cAt=at;white();if(ch)error("Syntax error, found trailing characters");if(keepComments){var b=c.join("\n"),a=getComment(cAt).join("\n");if(a||b){var comments=common.createComment(v,common.getComment(v));comments.r=[b,a]}}return v}function rootValue(){white();var c=keepComments?getComment(1):null;switch(ch){case"{":return checkTrailing(object(),c);case"[":return checkTrailing(array(),c);default:return checkTrailing(value(),c)}}function legacyRootValue(){white();var c=keepComments?getComment(1):null;switch(ch){case"{":return checkTrailing(object(),c);case"[":return checkTrailing(array(),c)}try{return checkTrailing(object(true),c)}catch(e){resetAt();try{return checkTrailing(value(),c)}catch(e2){throw e}}}if(typeof source!=="string")throw new Error("source is not a string");var dsfDef=null;var legacyRoot=true;if(opt&&typeof opt==="object"){keepComments=opt.keepWsc;dsfDef=opt.dsf;legacyRoot=opt.legacyRoot!==false}runDsf=dsf.loadDsf(dsfDef,"parse");text=source;resetAt();return legacyRoot?legacyRootValue():rootValue()}},5017:function(module,__unused_webpack_exports,__webpack_require__){"use strict";module.exports=function(data,opt){var common=__webpack_require__(7391);var dsf=__webpack_require__(8297);var plainToken={obj:["{","}"],arr:["[","]"],key:["",""],qkey:['"','"'],col:[":",""],com:[",",""],str:["",""],qstr:['"','"'],mstr:["'''","'''"],num:["",""],lit:["",""],dsf:["",""],esc:["\\",""],uni:["\\u",""],rem:["",""]};var eol=common.EOL;var indent="  ";var keepComments=false;var bracesSameLine=false;var quoteKeys=false;var quoteStrings=false;var condense=0;var multiline=1;var separator="";var dsfDef=null;var sortProps=false;var token=plainToken;if(opt&&typeof opt==="object"){opt.quotes=opt.quotes==="always"?"strings":opt.quotes;if(opt.eol==="\n"||opt.eol==="\r\n")eol=opt.eol;keepComments=opt.keepWsc;condense=opt.condense||0;bracesSameLine=opt.bracesSameLine;quoteKeys=opt.quotes==="all"||opt.quotes==="keys";quoteStrings=opt.quotes==="all"||opt.quotes==="strings"||opt.separator===true;if(quoteStrings||opt.multiline=="off")multiline=0;else multiline=opt.multiline=="no-tabs"?2:1;separator=opt.separator===true?token.com[0]:"";dsfDef=opt.dsf;sortProps=opt.sortProps;if(typeof opt.space==="number"){indent=new Array(opt.space+1).join(" ")}else if(typeof opt.space==="string"){indent=opt.space}if(opt.colors===true){token={obj:["\x1b[37m{\x1b[0m","\x1b[37m}\x1b[0m"],arr:["\x1b[37m[\x1b[0m","\x1b[37m]\x1b[0m"],key:["\x1b[33m","\x1b[0m"],qkey:['\x1b[33m"','"\x1b[0m'],col:["\x1b[37m:\x1b[0m",""],com:["\x1b[37m,\x1b[0m",""],str:["\x1b[37;1m","\x1b[0m"],qstr:['\x1b[37;1m"','"\x1b[0m'],mstr:["\x1b[37;1m'''","'''\x1b[0m"],num:["\x1b[36;1m","\x1b[0m"],lit:["\x1b[36m","\x1b[0m"],dsf:["\x1b[37m","\x1b[0m"],esc:["\x1b[31m\\","\x1b[0m"],uni:["\x1b[31m\\u","\x1b[0m"],rem:["\x1b[35m","\x1b[0m"]}}var i,ckeys=Object.keys(plainToken);for(i=ckeys.length-1;i>=0;i--){var k=ckeys[i];token[k].push(plainToken[k][0].length,plainToken[k][1].length)}}var runDsf;var commonRange="\x7f-\x9f\xad؀-؄܏឴឵‌-‏\u2028- ⁠-⁯\uFEFF￰-￿";var needsEscape=new RegExp('[\\\\\\"\0-\x1f'+commonRange+"]","g");var needsQuotes=new RegExp("^\\s|^\"|^'|^#|^\\/\\*|^\\/\\/|^\\{|^\\}|^\\[|^\\]|^:|^,|\\s$|[\0-\x1f"+commonRange+"]","g");var needsEscapeML=new RegExp("'''|^[\\s]+$|[\0-"+(multiline===2?"	":"\b")+"\v\f\x0e-\x1f"+commonRange+"]","g");var startsWithKeyword=new RegExp("^(true|false|null)\\s*((,|\\]|\\}|#|//|/\\*).*)?$");var meta={"\b":"b","	":"t","\n":"n","\f":"f","\r":"r",'"':'"',"\\":"\\"};var needsEscapeName=/[,\{\[\}\]\s:#"']|\/\/|\/\*/;var gap="";var wrapLen=0;function wrap(tk,v){wrapLen+=tk[0].length+tk[1].length-tk[2]-tk[3];return tk[0]+v+tk[1]}function quoteReplace(string){return string.replace(needsEscape,function(a){var c=meta[a];if(typeof c==="string")return wrap(token.esc,c);else return wrap(token.uni,("0000"+a.charCodeAt(0).toString(16)).slice(-4))})}function quote(string,gap,hasComment,isRootObject){if(!string)return wrap(token.qstr,"");needsQuotes.lastIndex=0;startsWithKeyword.lastIndex=0;if(quoteStrings||hasComment||needsQuotes.test(string)||common.tryParseNumber(string,true)!==undefined||startsWithKeyword.test(string)){needsEscape.lastIndex=0;needsEscapeML.lastIndex=0;if(!needsEscape.test(string))return wrap(token.qstr,string);else if(!needsEscapeML.test(string)&&!isRootObject&&multiline)return mlString(string,gap);else return wrap(token.qstr,quoteReplace(string))}else{return wrap(token.str,string)}}function mlString(string,gap){var i,a=string.replace(/\r/g,"").split("\n");gap+=indent;if(a.length===1){return wrap(token.mstr,a[0])}else{var res=eol+gap+token.mstr[0];for(i=0;i<a.length;i++){res+=eol;if(a[i])res+=gap+a[i]}return res+eol+gap+token.mstr[1]}}function quoteKey(name){if(!name)return'""';if(quoteKeys||needsEscapeName.test(name)){needsEscape.lastIndex=0;return wrap(token.qkey,needsEscape.test(name)?quoteReplace(name):name)}else{return wrap(token.key,name)}}function str(value,hasComment,noIndent,isRootObject){function startsWithNL(str){return str&&str[str[0]==="\r"?1:0]==="\n"}function commentOnThisLine(str){return str&&!startsWithNL(str)}function makeComment(str,prefix,trim){if(!str)return"";str=common.forceComment(str);var i,len=str.length;for(i=0;i<len&&str[i]<=" ";i++){}if(trim&&i>0)str=str.substr(i);if(i<len)return prefix+wrap(token.rem,str);else return str}var dsfValue=runDsf(value);if(dsfValue!==undefined)return wrap(token.dsf,dsfValue);switch(typeof value){case"string":return quote(value,gap,hasComment,isRootObject);case"number":return isFinite(value)?wrap(token.num,String(value)):wrap(token.lit,"null");case"boolean":return wrap(token.lit,String(value));case"object":if(!value)return wrap(token.lit,"null");var comments;if(keepComments)comments=common.getComment(value);var isArray=Object.prototype.toString.apply(value)==="[object Array]";var mind=gap;gap+=indent;var eolMind=eol+mind;var eolGap=eol+gap;var prefix=noIndent||bracesSameLine?"":eolMind;var partial=[];var setsep;var cpartial=condense?[]:null;var saveQuoteStrings=quoteStrings,saveMultiline=multiline;var iseparator=separator?"":token.com[0];var cwrapLen=0;var i,length;var k,v,vs;var c,ca;var res,cres;if(isArray){for(i=0,length=value.length;i<length;i++){setsep=i<length-1;if(comments){c=comments.a[i]||[];ca=commentOnThisLine(c[1]);partial.push(makeComment(c[0],"\n")+eolGap);if(cpartial&&(c[0]||c[1]||ca))cpartial=null}else partial.push(eolGap);wrapLen=0;v=value[i];partial.push(str(v,comments?ca:false,true)+(setsep?separator:""));if(cpartial){switch(typeof v){case"string":wrapLen=0;quoteStrings=true;multiline=0;cpartial.push(str(v,false,true)+(setsep?token.com[0]:""));quoteStrings=saveQuoteStrings;multiline=saveMultiline;break;case"object":if(v){cpartial=null;break}default:cpartial.push(partial[partial.length-1]+(setsep?iseparator:""));break}if(setsep)wrapLen+=token.com[0].length-token.com[2];cwrapLen+=wrapLen}if(comments&&c[1])partial.push(makeComment(c[1],ca?" ":"\n",ca))}if(length===0){if(comments&&comments.e)partial.push(makeComment(comments.e[0],"\n")+eolMind)}else partial.push(eolMind);if(partial.length===0)res=wrap(token.arr,"");else{res=prefix+wrap(token.arr,partial.join(""));if(cpartial){cres=cpartial.join(" ");if(cres.length-cwrapLen<=condense)res=wrap(token.arr,cres)}}}else{var commentKeys=comments?comments.o.slice():[];var objectKeys=[];for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)&&commentKeys.indexOf(k)<0)objectKeys.push(k)}if(sortProps){objectKeys.sort()}var keys=commentKeys.concat(objectKeys);for(i=0,length=keys.length;i<length;i++){setsep=i<length-1;k=keys[i];if(comments){c=comments.c[k]||[];ca=commentOnThisLine(c[1]);partial.push(makeComment(c[0],"\n")+eolGap);if(cpartial&&(c[0]||c[1]||ca))cpartial=null}else partial.push(eolGap);wrapLen=0;v=value[k];vs=str(v,comments&&ca);partial.push(quoteKey(k)+token.col[0]+(startsWithNL(vs)?"":" ")+vs+(setsep?separator:""));if(comments&&c[1])partial.push(makeComment(c[1],ca?" ":"\n",ca));if(cpartial){switch(typeof v){case"string":wrapLen=0;quoteStrings=true;multiline=0;vs=str(v,false);quoteStrings=saveQuoteStrings;multiline=saveMultiline;cpartial.push(quoteKey(k)+token.col[0]+" "+vs+(setsep?token.com[0]:""));break;case"object":if(v){cpartial=null;break}default:cpartial.push(partial[partial.length-1]+(setsep?iseparator:""));break}wrapLen+=token.col[0].length-token.col[2];if(setsep)wrapLen+=token.com[0].length-token.com[2];cwrapLen+=wrapLen}}if(length===0){if(comments&&comments.e)partial.push(makeComment(comments.e[0],"\n")+eolMind)}else partial.push(eolMind);if(partial.length===0){res=wrap(token.obj,"")}else{res=prefix+wrap(token.obj,partial.join(""));if(cpartial){cres=cpartial.join(" ");if(cres.length-cwrapLen<=condense)res=wrap(token.obj,cres)}}}gap=mind;return res}}runDsf=dsf.loadDsf(dsfDef,"stringify");var res="";var comments=keepComments?comments=(common.getComment(data)||{}).r:null;if(comments&&comments[0])res=comments[0]+"\n";res+=str(data,null,true,true);if(comments)res+=comments[1]||"";return res}},5816:function(module){module.exports="3.2.1"},4865:function(module,__unused_webpack_exports,__webpack_require__){"use strict";var common=__webpack_require__(7391);var version=__webpack_require__(5816);var parse=__webpack_require__(7639);var stringify=__webpack_require__(5017);var comments=__webpack_require__(1112);var dsf=__webpack_require__(8297);module.exports={parse:parse,stringify:stringify,endOfLine:function(){return common.EOL},setEndOfLine:function(eol){if(eol==="\n"||eol==="\r\n")common.EOL=eol},version:version,rt:{parse:function(text,options){(options=options||{}).keepWsc=true;return parse(text,options)},stringify:function(value,options){(options=options||{}).keepWsc=true;return stringify(value,options)}},comments:comments,dsf:dsf.std}},236:function(module){function stringify(obj,options){options=options||{};var indent=JSON.stringify([1],null,get(options,"indent",2)).slice(2,-3);var addMargin=get(options,"margins",false);var maxLength=indent===""?Infinity:get(options,"maxLength",80);return function _stringify(obj,currentIndent,reserved){if(obj&&typeof obj.toJSON==="function"){obj=obj.toJSON()}var string=JSON.stringify(obj);if(string===undefined){return string}var length=maxLength-currentIndent.length-reserved;if(string.length<=length){var prettified=prettify(string,addMargin);if(prettified.length<=length){return prettified}}if(typeof obj==="object"&&obj!==null){var nextIndent=currentIndent+indent;var items=[];var delimiters;var comma=function(array,index){return index===array.length-1?0:1};if(Array.isArray(obj)){for(var index=0;index<obj.length;index++){items.push(_stringify(obj[index],nextIndent,comma(obj,index))||"null")}delimiters="[]"}else{Object.keys(obj).forEach(function(key,index,array){var keyPart=JSON.stringify(key)+": ";var value=_stringify(obj[key],nextIndent,keyPart.length+comma(array,index));if(value!==undefined){items.push(keyPart+value)}});delimiters="{}"}if(items.length>0){return[delimiters[0],indent+items.join(",\n"+nextIndent),delimiters[1]].join("\n"+currentIndent)}}return string}(obj,"",0)}var stringOrChar=/("(?:[^\\"]|\\.)*")|[:,\][}{]/g;function prettify(string,addMargin){var m=addMargin?" ":"";var tokens={"{":"{"+m,"[":"["+m,"}":m+"}","]":m+"]",",":", ",":":": "};return string.replace(stringOrChar,function(match,string){return string?match:tokens[match]})}function get(options,name,defaultValue){return name in options?options[name]:defaultValue}module.exports=stringify},4090:function(__unused_webpack_module,exports){exports.endianness=function(){return"LE"};exports.hostname=function(){if(typeof location!=="undefined"){return location.hostname}else return""};exports.loadavg=function(){return[]};exports.uptime=function(){return 0};exports.freemem=function(){return Number.MAX_VALUE};exports.totalmem=function(){return Number.MAX_VALUE};exports.cpus=function(){return[]};exports.type=function(){return"Browser"};exports.release=function(){if(typeof navigator!=="undefined"){return navigator.appVersion}return""};exports.networkInterfaces=exports.getNetworkInterfaces=function(){return{}};exports.arch=function(){return"javascript"};exports.platform=function(){return"browser"};exports.tmpdir=exports.tmpDir=function(){return"/tmp"};exports.EOL="\n";exports.homedir=function(){return"/"}},9094:function(__unused_webpack_module,exports,__webpack_require__){"use strict";var __webpack_unused_export__;var f=__webpack_require__(6933),g=60103;__webpack_unused_export__=60107;if("function"===typeof Symbol&&Symbol.for){var h=Symbol.for;g=h("react.element");__webpack_unused_export__=h("react.fragment")}var m=f.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner,n=Object.prototype.hasOwnProperty,p={key:!0,ref:!0,__self:!0,__source:!0};function q(c,a,k){var b,d={},e=null,l=null;void 0!==k&&(e=""+k);void 0!==a.key&&(e=""+a.key);void 0!==a.ref&&(l=a.ref);for(b in a)n.call(a,b)&&!p.hasOwnProperty(b)&&(d[b]=a[b]);if(c&&c.defaultProps)for(b in a=c.defaultProps,a)void 0===d[b]&&(d[b]=a[b]);return{$$typeof:g,type:c,key:e,ref:l,props:d,_owner:m.current}}exports.jsx=q;exports.jsxs=q},6870:function(module,__unused_webpack_exports,__webpack_require__){"use strict";if(true){module.exports=__webpack_require__(9094)}else{}},3735:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(7252);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},1421:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(8356);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},875:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(470);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},3681:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(574);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2208:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(3919);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2490:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(9903);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},518:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(8895);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},5072:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(9335);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},7249:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(2690);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},8683:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(1122);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},8793:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(7240);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},3763:function(module,__unused_webpack_exports,__webpack_require__){var api=__webpack_require__(7478);var content=__webpack_require__(6464);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.id,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},7478:function(module,__unused_webpack_exports,__webpack_require__){"use strict";var isOldIE=function isOldIE(){var memo;return function memorize(){if(typeof memo==="undefined"){memo=Boolean(window&&document&&document.all&&!window.atob)}return memo}}();var getTarget=function getTarget(){var memo={};return function memorize(target){if(typeof memo[target]==="undefined"){var styleTarget=document.querySelector(target);if(window.HTMLIFrameElement&&styleTarget instanceof window.HTMLIFrameElement){try{styleTarget=styleTarget.contentDocument.head}catch(e){styleTarget=null}}memo[target]=styleTarget}return memo[target]}}();var stylesInDom=[];function getIndexByIdentifier(identifier){var result=-1;for(var i=0;i<stylesInDom.length;i++){if(stylesInDom[i].identifier===identifier){result=i;break}}return result}function modulesToDom(list,options){var idCountMap={};var identifiers=[];for(var i=0;i<list.length;i++){var item=list[i];var id=options.base?item[0]+options.base:item[0];var count=idCountMap[id]||0;var identifier="".concat(id," ").concat(count);idCountMap[id]=count+1;var index=getIndexByIdentifier(identifier);var obj={css:item[1],media:item[2],sourceMap:item[3]};if(index!==-1){stylesInDom[index].references++;stylesInDom[index].updater(obj)}else{stylesInDom.push({identifier:identifier,updater:addStyle(obj,options),references:1})}identifiers.push(identifier)}return identifiers}function insertStyleElement(options){var style=document.createElement("style");var attributes=options.attributes||{};if(typeof attributes.nonce==="undefined"){var nonce=true?__webpack_require__.nc:0;if(nonce){attributes.nonce=nonce}}Object.keys(attributes).forEach(function(key){style.setAttribute(key,attributes[key])});if(typeof options.insert==="function"){options.insert(style)}else{var target=getTarget(options.insert||"head");if(!target){throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.")}target.appendChild(style)}return style}function removeStyleElement(style){if(style.parentNode===null){return false}style.parentNode.removeChild(style)}var replaceText=function replaceText(){var textStore=[];return function replace(index,replacement){textStore[index]=replacement;return textStore.filter(Boolean).join("\n")}}();function applyToSingletonTag(style,index,remove,obj){var css=remove?"":obj.media?"@media ".concat(obj.media," {").concat(obj.css,"}"):obj.css;if(style.styleSheet){style.styleSheet.cssText=replaceText(index,css)}else{var cssNode=document.createTextNode(css);var childNodes=style.childNodes;if(childNodes[index]){style.removeChild(childNodes[index])}if(childNodes.length){style.insertBefore(cssNode,childNodes[index])}else{style.appendChild(cssNode)}}}function applyToTag(style,options,obj){var css=obj.css;var media=obj.media;var sourceMap=obj.sourceMap;if(media){style.setAttribute("media",media)}else{style.removeAttribute("media")}if(sourceMap&&typeof btoa!=="undefined"){css+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))))," */")}if(style.styleSheet){style.styleSheet.cssText=css}else{while(style.firstChild){style.removeChild(style.firstChild)}style.appendChild(document.createTextNode(css))}}var singleton=null;var singletonCounter=0;function addStyle(obj,options){var style;var update;var remove;if(options.singleton){var styleIndex=singletonCounter++;style=singleton||(singleton=insertStyleElement(options));update=applyToSingletonTag.bind(null,style,styleIndex,false);remove=applyToSingletonTag.bind(null,style,styleIndex,true)}else{style=insertStyleElement(options);update=applyToTag.bind(null,style,options);remove=function remove(){removeStyleElement(style)}}update(obj);return function updateStyle(newObj){if(newObj){if(newObj.css===obj.css&&newObj.media===obj.media&&newObj.sourceMap===obj.sourceMap){return}update(obj=newObj)}else{remove()}}}module.exports=function(list,options){options=options||{};if(!options.singleton&&typeof options.singleton!=="boolean"){options.singleton=isOldIE()}list=list||[];var lastIdentifiers=modulesToDom(list,options);return function update(newList){newList=newList||[];if(Object.prototype.toString.call(newList)!=="[object Array]"){return}for(var i=0;i<lastIdentifiers.length;i++){var identifier=lastIdentifiers[i];var index=getIndexByIdentifier(identifier);stylesInDom[index].references--}var newLastIdentifiers=modulesToDom(newList,options);for(var _i=0;_i<lastIdentifiers.length;_i++){var _identifier=lastIdentifiers[_i];var _index=getIndexByIdentifier(_identifier);if(stylesInDom[_index].references===0){stylesInDom[_index].updater();stylesInDom.splice(_index,1)}}lastIdentifiers=newLastIdentifiers}}},5868:function(__unused_webpack_module,__unused_webpack_exports,__webpack_require__){__webpack_require__.p=window.__osdPublicPath__["visTypeVega"];__webpack_require__.nc=window.__webpack_nonce__||""},3664:function(__unused_webpack_module,__unused_webpack_exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(3735);case"v7light":return __webpack_require__(875);case"v8dark":return __webpack_require__(2208);case"v8light":return __webpack_require__(518);case"v9dark":return __webpack_require__(7249);case"v9light":return __webpack_require__(8793)}},1688:function(__unused_webpack_module,__unused_webpack_exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(1421);case"v7light":return __webpack_require__(3681);case"v8dark":return __webpack_require__(2490);case"v8light":return __webpack_require__(5072);case"v9dark":return __webpack_require__(8683);case"v9light":return __webpack_require__(3763)}},5476:function(module){module.exports=__osdBundles__.get("plugin/data/public")},5443:function(module){module.exports=__osdBundles__.get("plugin/inspector/public")},4904:function(module){module.exports=__osdBundles__.get("plugin/opensearchDashboardsReact/public")},6342:function(module){module.exports=__osdBundles__.get("plugin/opensearchDashboardsUtils/public")},5075:function(module){module.exports=__osdBundles__.get("plugin/visAugmenter/public")},908:function(module){module.exports=__osdBundles__.get("plugin/visDefaultEditor/public")},4598:function(__unused_webpack_module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{LineVegaSpecExpressionFunctionDefinition:()=>line_vega_spec_fn_namespaceObject.LineVegaSpecExpressionFunctionDefinition,VegaExpressionFunctionDefinition:()=>vega_fn_namespaceObject.VegaExpressionFunctionDefinition,YAxisConfig:()=>helpers_namespaceObject.YAxisConfig,plugin:()=>public_plugin});var vega_fn_namespaceObject={};__webpack_require__.r(vega_fn_namespaceObject);__webpack_require__.d(vega_fn_namespaceObject,{K:()=>createVegaFn});var helpers_namespaceObject={};__webpack_require__.r(helpers_namespaceObject);__webpack_require__.d(helpers_namespaceObject,{xm:()=>createSpecFromXYChartDatatable,sq:()=>formatDatatable});var line_vega_spec_fn_namespaceObject={};__webpack_require__.r(line_vega_spec_fn_namespaceObject);__webpack_require__.d(line_vega_spec_fn_namespaceObject,{V:()=>createLineVegaSpecFn});var _async_to_generator=__webpack_require__(5194);var _class_call_check=__webpack_require__(7394);var _create_class=__webpack_require__(4379);var _define_property=__webpack_require__(9623);var external_osdSharedDeps_TsLib_=__webpack_require__(2790);var public_services=__webpack_require__(3233);var external_osdSharedDeps_Lodash_=__webpack_require__(1731);var external_osdSharedDeps_OsdI18n_=__webpack_require__(7528);var data_public=__webpack_require__(5476);const external_osdSharedDeps_Rxjs_namespaceObject=__osdSharedDeps__.Rxjs;const external_osdSharedDeps_RxjsOperators_namespaceObject=__osdSharedDeps__.RxjsOperators;var search_api_SearchAPI=function(){"use strict";function SearchAPI(dependencies,abortSignal,inspectorAdapters){(0,_class_call_check._)(this,SearchAPI);(0,_define_property._)(this,"dependencies",void 0);(0,_define_property._)(this,"abortSignal",void 0);(0,_define_property._)(this,"inspectorAdapters",void 0);this.dependencies=dependencies;this.abortSignal=abortSignal;this.inspectorAdapters=inspectorAdapters}(0,_create_class._)(SearchAPI,[{key:"search",value:function search(searchRequests,options){return(0,_async_to_generator._)(function(){var _this,search,requestResponders;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){switch(_state.label){case 0:_this=this;search=this.dependencies.search.search;requestResponders={};return[4,Promise.all(searchRequests.map(function(request){return(0,_async_to_generator._)(function(){var _this,requestId,dataSourceId,_tmp,params,searchApiParams;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){switch(_state.label){case 0:_this=this;requestId=request.name;if(!!!request.data_source_name)return[3,2];return[4,this.findDataSourceIdbyName(request.data_source_name)];case 1:_tmp=_state.sent();return[3,3];case 2:_tmp=undefined;_state.label=3;case 3:dataSourceId=_tmp;params=(0,data_public.getSearchParamsFromRequest)(request,{getConfig:this.dependencies.uiSettings.get.bind(this.dependencies.uiSettings)});if(this.inspectorAdapters){requestResponders[requestId]=this.inspectorAdapters.requests.start(requestId,request);requestResponders[requestId].json(params.body)}searchApiParams=dataSourceId&&this.dependencies.dataSourceEnabled?{params:params,dataSourceId:dataSourceId}:{params:params};return[2,search(searchApiParams,{abortSignal:this.abortSignal,strategy:options===null||options===void 0?void 0:options.strategy}).pipe((0,external_osdSharedDeps_RxjsOperators_namespaceObject.tap)(function(data){return _this.inspectSearchResult(data,requestResponders[requestId])}),(0,external_osdSharedDeps_RxjsOperators_namespaceObject.map)(function(data){return{name:requestId,rawResponse:data.rawResponse}}))]}})}).call(_this)}))];case 1:return[2,external_osdSharedDeps_Rxjs_namespaceObject.combineLatest.apply(void 0,[_state.sent()])]}})}).call(this)}},{key:"findDataSourceIdbyName",value:function findDataSourceIdbyName(dataSourceName){return(0,_async_to_generator._)(function(){var _possibleDataSourceIds_pop,dataSources,possibleDataSourceIds;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){switch(_state.label){case 0:if(!this.dependencies.dataSourceEnabled){throw new Error("data_source_name cannot be used because data_source.enabled is false")}return[4,this.dataSourceFindQuery(dataSourceName)];case 1:dataSources=_state.sent();possibleDataSourceIds=dataSources.savedObjects.filter(function(obj){return obj.attributes.title===dataSourceName});if(possibleDataSourceIds.length!==1){throw new Error('Expected exactly 1 result for data_source_name "'.concat(dataSourceName,'" but got ').concat(possibleDataSourceIds.length," results"))}return[2,(_possibleDataSourceIds_pop=possibleDataSourceIds.pop())===null||_possibleDataSourceIds_pop===void 0?void 0:_possibleDataSourceIds_pop.id]}})}).call(this)}},{key:"dataSourceFindQuery",value:function dataSourceFindQuery(dataSourceName){return(0,_async_to_generator._)(function(){return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){switch(_state.label){case 0:return[4,this.dependencies.savedObjectsClient.find({type:"data-source",perPage:10,search:'"'.concat(dataSourceName,'"'),searchFields:["title"],fields:["id","title"]})];case 1:return[2,_state.sent()]}})}).call(this)}},{key:"resetSearchStats",value:function resetSearchStats(){if(this.inspectorAdapters){this.inspectorAdapters.requests.reset()}}},{key:"getPPLRawResponseInspectorStats",value:function getPPLRawResponseInspectorStats(response){var stats={};stats.hitsTotal={label:external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.search.searchSource.hitsTotalLabel",{defaultMessage:"Hits (total)"}),value:"".concat(response.total),description:external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.search.searchSource.hitsTotalDescription",{defaultMessage:"The number of documents that match the query."})};stats.hits={label:external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.search.searchSource.hitsLabel",{defaultMessage:"Hits"}),value:"".concat(response.size),description:external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.search.searchSource.hitsDescription",{defaultMessage:"The number of documents returned by the query."})};return stats}},{key:"inspectSearchResult",value:function inspectSearchResult(response,requestResponder){if(requestResponder){if("jsonData"in response.rawResponse){requestResponder.stats(this.getPPLRawResponseInspectorStats(response.rawResponse)).ok({json:response.rawResponse})}else{requestResponder.stats(data_public.search.getResponseInspectorStats(response.rawResponse)).ok({json:response.rawResponse})}}}}]);return SearchAPI}();var AlwaysCacheMaxAge=40;var time_cache_TimeCache=function(){"use strict";function TimeCache(timefilter,maxAge){(0,_class_call_check._)(this,TimeCache);(0,_define_property._)(this,"_timefilter",void 0);(0,_define_property._)(this,"_maxAge",void 0);(0,_define_property._)(this,"_cachedBounds",void 0);(0,_define_property._)(this,"_cacheTS",void 0);(0,_define_property._)(this,"_timeRange",void 0);this._timefilter=timefilter;this._maxAge=maxAge;this._cacheTS=0}(0,_create_class._)(TimeCache,[{key:"_now",value:function _now(){return Date.now()}},{key:"getTimeBounds",value:function getTimeBounds(){var ts=this._now();var bounds=null;if(this._cachedBounds){var diff=ts-this._cacheTS;if(diff<AlwaysCacheMaxAge){return this._cachedBounds}if(diff<this._maxAge){bounds=this._getBounds();if(Math.abs(bounds.min-this._cachedBounds.min)<this._maxAge&&Math.abs(bounds.max-this._cachedBounds.max)<this._maxAge){return this._cachedBounds}}}this._cacheTS=ts;this._cachedBounds=bounds||this._getBounds();return this._cachedBounds}},{key:"setTimeRange",value:function setTimeRange(timeRange){this._timeRange=timeRange}},{key:"_getBounds",value:function _getBounds(){var bounds=this._timefilter.calculateBounds(this._timeRange);return{min:bounds.min.valueOf(),max:bounds.max.valueOf()}}}]);return TimeCache}();function createVegaRequestHandler(param){var data=param.plugins.data,uiSettings=param.core.uiSettings,getServiceSettings=param.getServiceSettings,context=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{};var searchAPI;var timefilter=data.query.timefilter.timefilter;var timeCache=new time_cache_TimeCache(timefilter,3*1e3);return function vegaRequestHandler(_0){return(0,_async_to_generator._)(function(param){var timeRange,filters,query,visParams,opensearchQueryConfigs,filtersDsl,VegaParserModule,vp;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){switch(_state.label){case 0:timeRange=param.timeRange,filters=param.filters,query=param.query,visParams=param.visParams;if(!searchAPI){searchAPI=new search_api_SearchAPI({uiSettings:uiSettings,search:(0,public_services.bQ)().search,injectedMetadata:(0,public_services.o6)(),dataSourceEnabled:(0,public_services.D8)().enabled,savedObjectsClient:(0,public_services.LJ)().client},context.abortSignal,context.inspectorAdapters)}timeCache.setTimeRange(timeRange);opensearchQueryConfigs=data_public.opensearchQuery.getOpenSearchQueryConfig(uiSettings);filtersDsl=data_public.opensearchQuery.buildOpenSearchQuery(undefined,query,filters,opensearchQueryConfigs);return[4,Promise.all([__webpack_require__.e("0"),__webpack_require__.e("2"),__webpack_require__.e("3")]).then(__webpack_require__.bind(__webpack_require__,2759))];case 1:VegaParserModule=_state.sent();vp=new VegaParserModule.VegaParser(visParams.spec,searchAPI,timeCache,filtersDsl,getServiceSettings);return[4,vp.parseAsync()];case 2:return[2,_state.sent()]}})}).apply(this,arguments)}};var createVegaFn=function(dependencies){return{name:"vega",type:"render",inputTypes:["opensearch_dashboards_context","null"],help:external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.function.help",{defaultMessage:"Vega visualization"}),args:{spec:{types:["string"],"default":"",help:""}},fn:function fn(input,args,context){return(0,_async_to_generator._)(function(){var vegaRequestHandler,response;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){switch(_state.label){case 0:vegaRequestHandler=createVegaRequestHandler(dependencies,context);return[4,vegaRequestHandler({timeRange:(0,external_osdSharedDeps_Lodash_.get)(input,"timeRange"),query:(0,external_osdSharedDeps_Lodash_.get)(input,"query"),filters:(0,external_osdSharedDeps_Lodash_.get)(input,"filters"),visParams:{spec:args.spec}})];case 1:response=_state.sent();return[2,{type:"render",as:"visualization",value:{visData:response,visType:"vega",visConfig:{spec:args.spec}}}]}})})()}}};var hjson=__webpack_require__(4865);var hjson_default=__webpack_require__.n(hjson);var vis_default_editor_public=__webpack_require__(908);var jsx_runtime=__webpack_require__(6870);var external_osdSharedDeps_React_=__webpack_require__(6933);var external_osdSharedDeps_ElasticEui_=__webpack_require__(1350);var json_stringify_pretty_compact=__webpack_require__(236);var json_stringify_pretty_compact_default=__webpack_require__.n(json_stringify_pretty_compact);var mode_hjson=__webpack_require__(4750);var searchbox=__webpack_require__(1559);var _sliced_to_array=__webpack_require__(4242);const external_osdSharedDeps_OsdI18nReact_namespaceObject=__osdSharedDeps__.OsdI18nReact;var opensearch_dashboards_react_public=__webpack_require__(4904);function VegaHelpMenu(){var _useOpenSearchDashboards_services_docLinks;var _useState=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)(false),2),isPopoverOpen=_useState[0],setIsPopoverOpen=_useState[1];var onButtonClick=(0,external_osdSharedDeps_React_.useCallback)(function(){return setIsPopoverOpen(!isPopoverOpen)},[isPopoverOpen]);var closePopover=(0,external_osdSharedDeps_React_.useCallback)(function(){return setIsPopoverOpen(false)},[]);var vegaHelpDoc=(_useOpenSearchDashboards_services_docLinks=(0,opensearch_dashboards_react_public.useOpenSearchDashboards)().services.docLinks)===null||_useOpenSearchDashboards_services_docLinks===void 0?void 0:_useOpenSearchDashboards_services_docLinks.links.noDocumentation.vega;var button=(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiSmallButtonIcon,{iconType:"questionInCircle",onClick:onButtonClick,"aria-label":external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.editor.vegaHelpButtonAriaLabel",{defaultMessage:"Vega help"})});var items=[(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiContextMenuItem,{href:vegaHelpDoc,target:"_blank",onClick:closePopover,children:(0,jsx_runtime.jsx)(external_osdSharedDeps_OsdI18nReact_namespaceObject.FormattedMessage,{id:"visTypeVega.editor.vegaHelpLinkText",defaultMessage:"OpenSearch Dashboards Vega help"})},"vegaHelp"),(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiContextMenuItem,{href:"https://vega.github.io/vega-lite/docs/",target:"_blank",onClick:closePopover,children:(0,jsx_runtime.jsx)(external_osdSharedDeps_OsdI18nReact_namespaceObject.FormattedMessage,{id:"visTypeVega.editor.vegaLiteDocumentationLinkText",defaultMessage:"Vega-Lite documentation"})},"vegaLiteDocs"),(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiContextMenuItem,{href:"https://vega.github.io/vega/docs/",target:"_blank",onClick:closePopover,children:(0,jsx_runtime.jsx)(external_osdSharedDeps_OsdI18nReact_namespaceObject.FormattedMessage,{id:"visTypeVega.editor.vegaDocumentationLinkText",defaultMessage:"Vega documentation"})},"vegaDoc")];return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiPopover,{id:"helpMenu",button:button,isOpen:isPopoverOpen,closePopover:closePopover,panelPaddingSize:"none",anchorPosition:"downLeft",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiContextMenuPanel,{items:items,size:"s"})})};function VegaActionsMenu(param){var formatHJson=param.formatHJson,formatJson=param.formatJson;var _useState=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)(false),2),isPopoverOpen=_useState[0],setIsPopoverOpen=_useState[1];var onButtonClick=(0,external_osdSharedDeps_React_.useCallback)(function(){return setIsPopoverOpen(function(isOpen){return!isOpen})},[]);var onHJsonCLick=(0,external_osdSharedDeps_React_.useCallback)(function(){formatHJson();setIsPopoverOpen(false)},[formatHJson]);var onJsonCLick=(0,external_osdSharedDeps_React_.useCallback)(function(){formatJson();setIsPopoverOpen(false)},[formatJson]);var closePopover=(0,external_osdSharedDeps_React_.useCallback)(function(){return setIsPopoverOpen(false)},[]);var button=(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiSmallButtonIcon,{iconType:"wrench",onClick:onButtonClick,"aria-label":external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.editor.vegaEditorOptionsButtonAriaLabel",{defaultMessage:"Vega editor options"})});var items=[(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiContextMenuItem,{onClick:onHJsonCLick,children:(0,jsx_runtime.jsx)(external_osdSharedDeps_OsdI18nReact_namespaceObject.FormattedMessage,{id:"visTypeVega.editor.reformatAsHJSONButtonLabel",defaultMessage:"Reformat as HJSON"})},"hjson"),(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiContextMenuItem,{onClick:onJsonCLick,children:(0,jsx_runtime.jsx)(external_osdSharedDeps_OsdI18nReact_namespaceObject.FormattedMessage,{id:"visTypeVega.editor.reformatAsJSONButtonLabel",defaultMessage:"Reformat as JSON, delete comments"})},"json")];return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiPopover,{id:"actionsMenu",button:button,isOpen:isPopoverOpen,closePopover:closePopover,panelPaddingSize:"none",anchorPosition:"downLeft",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiContextMenuPanel,{items:items,size:"s"})})};var aceOptions={maxLines:Infinity,highlightActiveLine:false,showPrintMargin:false,tabSize:2,useSoftTabs:true,wrap:true};var hjsonStringifyOptions={bracesSameLine:true,keepWsc:true};function format(value,stringify,options){try{var spec=hjson_default().parse(value,{legacyRoot:false,keepWsc:true});return stringify(spec,options)}catch(err){(0,public_services.Tr)().toasts.addError(err,{title:external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.editor.formatError",{defaultMessage:"Error formatting spec"})});return value}}function VegaVisEditor(param){var stateParams=param.stateParams,setValue=param.setValue;var onChange=(0,external_osdSharedDeps_React_.useCallback)(function(value){setValue("spec",value)},[setValue]);var formatJson=(0,external_osdSharedDeps_React_.useCallback)(function(){return setValue("spec",format(stateParams.spec,json_stringify_pretty_compact_default()))},[setValue,stateParams.spec]);var formatHJson=(0,external_osdSharedDeps_React_.useCallback)(function(){return setValue("spec",format(stateParams.spec,hjson_default().stringify,hjsonStringifyOptions))},[setValue,stateParams.spec]);return(0,jsx_runtime.jsxs)("div",{className:"vgaEditor",children:[(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiCodeEditor,{"data-test-subj":"vega-editor",mode:"hjson",theme:"textmate",width:"100%",height:"auto",onChange:onChange,value:stateParams.spec,setOptions:aceOptions}),(0,jsx_runtime.jsxs)("div",{className:"vgaEditor__aceEditorActions",children:[(0,jsx_runtime.jsx)(VegaHelpMenu,{}),(0,jsx_runtime.jsx)(VegaActionsMenu,{formatHJson:formatHJson,formatJson:formatJson})]})]})};var extract_index_pattern=__webpack_require__(2162);var createVegaVisualization=function(param){var getServiceSettings=param.getServiceSettings;var VegaVisualization=function(){"use strict";function VegaVisualization(el,vis){(0,_class_call_check._)(this,VegaVisualization);this._el=el;this._vis=vis;this.dataPlugin=(0,public_services.bQ)()}(0,_create_class._)(VegaVisualization,[{key:"render",value:function render(visData){return(0,_async_to_generator._)(function(){var toasts,error;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){switch(_state.label){case 0:toasts=(0,public_services.Tr)().toasts;if(!visData&&!this._vegaView){toasts.addWarning(external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.visualization.unableToRenderWithoutDataWarningMessage",{defaultMessage:"Unable to render without data"}));return[2]}_state.label=1;case 1:_state.trys.push([1,3,,4]);return[4,this._render(visData)];case 2:_state.sent();return[3,4];case 3:error=_state.sent();if(this._vegaView){this._vegaView.onError(error)}else{toasts.addError(error,{title:external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.visualization.renderErrorTitle",{defaultMessage:"Vega error"})})}return[3,4];case 4:return[2]}})}).call(this)}},{key:"_render",value:function _render(vegaParser){return(0,_async_to_generator._)(function(){var serviceSettings,filterManager,timefilter,vegaViewParams,services,VegaMapView,VegaView;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){switch(_state.label){case 0:if(!vegaParser)return[3,9];if(!this._vegaView)return[3,2];return[4,this._vegaView.destroy()];case 1:_state.sent();this._vegaView=null;_state.label=2;case 2:return[4,getServiceSettings()];case 3:serviceSettings=_state.sent();filterManager=this.dataPlugin.query.filterManager;timefilter=this.dataPlugin.query.timefilter.timefilter;vegaViewParams={parentEl:this._el,applyFilter:this._vis.API.events.applyFilter,vegaParser:vegaParser,serviceSettings:serviceSettings,filterManager:filterManager,timefilter:timefilter,externalAction:this._vis.API.events.externalAction};if(!vegaParser.useMap)return[3,5];services={toastService:(0,public_services.Tr)().toasts};return[4,Promise.all([__webpack_require__.e("0"),__webpack_require__.e("2"),__webpack_require__.e("1")]).then(__webpack_require__.bind(__webpack_require__,2615))];case 4:VegaMapView=_state.sent().VegaMapView;this._vegaView=new VegaMapView(vegaViewParams,services);return[3,7];case 5:return[4,Promise.all([__webpack_require__.e("0"),__webpack_require__.e("2"),__webpack_require__.e("4")]).then(__webpack_require__.bind(__webpack_require__,9688))];case 6:VegaView=_state.sent().VegaView;this._vegaView=new VegaView(vegaViewParams);_state.label=7;case 7:return[4,this._vegaView.init()];case 8:_state.sent();_state.label=9;case 9:return[2]}})}).call(this)}},{key:"destroy",value:function destroy(){return this._vegaView&&this._vegaView.destroy()}}]);return VegaVisualization}();return VegaVisualization};const default_spec_hjson='{\n  /*\n\n  Welcome to Vega visualizations.  Here you can design your own dataviz from scratch using a declarative language called Vega, or its simpler form Vega-Lite.  In Vega, you have the full control of what data is loaded, even from multiple sources, how that data is transformed, and what visual elements are used to show it.  Use help icon to view Vega examples, tutorials, and other docs.  Use the wrench icon to reformat this text, or to remove comments.\n\n  This example graph shows the document count in all indexes in the current time range.  You might need to adjust the time filter in the upper right corner.\n  */\n\n  $schema: https://vega.github.io/schema/vega-lite/v5.json\n  title: Event counts from all indexes\n\n  // Define the data source\n  data: {\n    url: {\n      /*\n      An object instead of a string for the "url" param is treated as an OpenSearch query. Anything inside this object is not part of the Vega language, but only understood by OpenSearch Dashboards and OpenSearch server. This query counts the number of documents per time interval, assuming you have a @timestamp field in your data.\n\n      OpenSearch Dashboards has a special handling for the fields surrounded by "%".  They are processed before the query is sent to OpenSearch. This way the query becomes context aware, and can use the time range and the dashboard filters.\n      */\n\n      // Apply dashboard context filters when set\n      %context%: true\n      // Filter the time picker (upper right corner) with this field\n      %timefield%: @timestamp\n\n      /*\n      See .search() documentation for :  https://opensearch.org/docs/latest/clients/javascript/\n      */\n\n      // Which index to search\n      index: _all\n\n      // If "data_source.enabled: true", optionally set the data source name to query from (omit field if querying from local cluster)\n      // data_source_name: Example US Cluster\n\n      // Aggregate data by the time field into time buckets, counting the number of documents in each bucket.\n      body: {\n        aggs: {\n          time_buckets: {\n            date_histogram: {\n              // Use date histogram aggregation on @timestamp field\n              field: @timestamp\n              // The interval value will depend on the daterange picker (true), or use an integer to set an approximate bucket count\n              interval: {%autointerval%: true}\n              // Make sure we get an entire range, even if it has no data\n              extended_bounds: {\n                // Use the current time range\'s start and end\n                min: {%timefilter%: "min"}\n                max: {%timefilter%: "max"}\n              }\n              // Use this for linear (e.g. line, area) graphs.  Without it, empty buckets will not show up\n              min_doc_count: 0\n            }\n          }\n        }\n        // Speed up the response by only including aggregation results\n        size: 0\n      }\n    }\n    /*\n    OpenSearch will return results in this format:\n\n    aggregations: {\n      time_buckets: {\n        buckets: [\n          {\n            key_as_string: 2015-11-30T22:00:00.000Z\n            key: 1448920800000\n            doc_count: 0\n          },\n          {\n            key_as_string: 2015-11-30T23:00:00.000Z\n            key: 1448924400000\n            doc_count: 0\n          }\n          ...\n        ]\n      }\n    }\n\n    For our graph, we only need the list of bucket values.  Use the format.property to discard everything else.\n    */\n    format: {property: "aggregations.time_buckets.buckets"}\n  }\n\n  // "mark" is the graphics element used to show our data.  Other mark values are: area, bar, circle, line, point, rect, rule, square, text, and tick.  See https://vega.github.io/vega-lite/docs/mark.html\n  mark: line\n\n  // "encoding" tells the "mark" what data to use and in what way.  See https://vega.github.io/vega-lite/docs/encoding.html\n  encoding: {\n    x: {\n      // The "key" value is the timestamp in milliseconds.  Use it for X axis.\n      field: key\n      type: temporal\n      axis: {title: false} // Customize X axis format\n    }\n    y: {\n      // The "doc_count" is the count per bucket.  Use it for Y axis.\n      field: doc_count\n      type: quantitative\n      axis: {title: "Document count"}\n    }\n  }\n}\n';var getDefaultSpec=function(){return default_spec_hjson};var _object_spread=__webpack_require__(2961);var _object_spread_props=__webpack_require__(5548);var _to_consumable_array=__webpack_require__(9190);var _type_of=__webpack_require__(5310);var vegaAdapterSignalLabel=external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.vegaAdapter.signal",{defaultMessage:"Signal"});var vegaAdapterValueLabel=external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.vegaAdapter.value",{defaultMessage:"Value"});var getVegaRuntimeScope=function(debugValues){return debugValues.view._runtime};var serializeColumns=function(item,columns){var nonSerializableFieldLabel="(..)";return columns.reduce(function(row,column){try{var cell=item[column];row[column]=(typeof cell==="undefined"?"undefined":(0,_type_of._)(cell))==="object"?JSON.stringify(cell):"".concat(cell)}catch(e){row[column]=nonSerializableFieldLabel}return row},{})};var vega_adapter_VegaAdapter=function(){"use strict";function VegaAdapter(){(0,_class_call_check._)(this,VegaAdapter);(0,_define_property._)(this,"debugValuesSubject",new external_osdSharedDeps_Rxjs_namespaceObject.ReplaySubject)}(0,_create_class._)(VegaAdapter,[{key:"bindInspectValues",value:function bindInspectValues(debugValues){this.debugValuesSubject.next(debugValues)}},{key:"getDataSetsSubscription",value:function getDataSetsSubscription(){return this.debugValuesSubject.pipe((0,external_osdSharedDeps_RxjsOperators_namespaceObject.filter)(function(debugValues){return Boolean(debugValues)}),(0,external_osdSharedDeps_RxjsOperators_namespaceObject.map)(function(debugValues){var runtimeScope=getVegaRuntimeScope(debugValues);return Object.keys(runtimeScope.data||[]).reduce(function(acc,key){var value=runtimeScope.data[key].values.value;if(value&&value[0]){var columns=Object.keys(value[0]);acc.push({id:key,columns:columns.map(function(column){return{id:column,schema:"json"}}),data:value.map(function(item){return serializeColumns(item,columns)})})}return acc},[])}))}},{key:"getSignalsSetsSubscription",value:function getSignalsSetsSubscription(){var signalsListener=this.debugValuesSubject.pipe((0,external_osdSharedDeps_RxjsOperators_namespaceObject.filter)(function(debugValues){return Boolean(debugValues)}),(0,external_osdSharedDeps_RxjsOperators_namespaceObject.switchMap)(function(debugValues){var runtimeScope=getVegaRuntimeScope(debugValues);return external_osdSharedDeps_Rxjs_namespaceObject.merge.apply(void 0,(0,_to_consumable_array._)(Object.keys(runtimeScope.signals).map(function(key){return(0,external_osdSharedDeps_Rxjs_namespaceObject.fromEventPattern)(function(handler){return debugValues.view.addSignalListener(key,handler)},function(handler){return debugValues.view.removeSignalListener(key,handler)})}))).pipe((0,external_osdSharedDeps_RxjsOperators_namespaceObject.debounce)(function(val){return(0,external_osdSharedDeps_Rxjs_namespaceObject.timer)(350)}),(0,external_osdSharedDeps_RxjsOperators_namespaceObject.map)(function(){return debugValues}))}));return(0,external_osdSharedDeps_Rxjs_namespaceObject.merge)(this.debugValuesSubject,signalsListener).pipe((0,external_osdSharedDeps_RxjsOperators_namespaceObject.filter)(function(debugValues){return Boolean(debugValues)}),(0,external_osdSharedDeps_RxjsOperators_namespaceObject.map)(function(debugValues){var runtimeScope=getVegaRuntimeScope(debugValues);return{columns:[{id:vegaAdapterSignalLabel,schema:"text"},{id:vegaAdapterValueLabel,schema:"json"}],data:Object.keys(runtimeScope.signals).map(function(key){var _obj;return serializeColumns((_obj={},(0,_define_property._)(_obj,vegaAdapterSignalLabel,key),(0,_define_property._)(_obj,vegaAdapterValueLabel,runtimeScope.signals[key].value),_obj),[vegaAdapterSignalLabel,vegaAdapterValueLabel])})}}))}},{key:"getSpecSubscription",value:function getSpecSubscription(){return this.debugValuesSubject.pipe((0,external_osdSharedDeps_RxjsOperators_namespaceObject.filter)(function(debugValues){return Boolean(debugValues)}),(0,external_osdSharedDeps_RxjsOperators_namespaceObject.map)(function(debugValues){return JSON.stringify(debugValues.spec,null,2)}))}}]);return VegaAdapter}();var vega_data_inspector=__webpack_require__(1688);var _object_without_properties=__webpack_require__(6816);var DEFAULT_PAGE_SIZE=15;var InspectorDataGrid=function(param){var columns=param.columns,data=param.data,dataGridAriaLabel=param.dataGridAriaLabel;var _useState=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)({pageIndex:0,pageSize:DEFAULT_PAGE_SIZE}),2),pagination=_useState[0],setPagination=_useState[1];var onChangeItemsPerPage=(0,external_osdSharedDeps_React_.useCallback)(function(pageSize){return setPagination(function(p){return(0,_object_spread_props._)((0,_object_spread._)({},p),{pageSize:pageSize,pageIndex:0})})},[setPagination]);var onChangePage=(0,external_osdSharedDeps_React_.useCallback)(function(pageIndex){return setPagination(function(p){return(0,_object_spread_props._)((0,_object_spread._)({},p),{pageIndex:pageIndex})})},[setPagination]);var _useState1=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)([]),2),visibleColumns=_useState1[0],setVisibleColumns=_useState1[1];(0,external_osdSharedDeps_React_.useEffect)(function(){setPagination((0,_object_spread_props._)((0,_object_spread._)({},pagination),{pageIndex:0}));setVisibleColumns(columns.map(function(column){return column.id}))},[dataGridAriaLabel]);var _useState2=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)([]),2),sortingColumns=_useState2[0],setSortingColumns=_useState2[1];var onSort=(0,external_osdSharedDeps_React_.useCallback)(function(newSortingColumns){setSortingColumns(newSortingColumns)},[setSortingColumns]);var gridData=(0,external_osdSharedDeps_React_.useMemo)(function(){return(0,_to_consumable_array._)(data).sort(function(a,b){for(var i=0;i<sortingColumns.length;i++){var column=sortingColumns[i];var aValue=a[column.id];var bValue=b[column.id];if(aValue<bValue)return column.direction==="asc"?-1:1;if(aValue>bValue)return column.direction==="asc"?1:-1}return 0})},[data,sortingColumns]);var renderCellValue=(0,external_osdSharedDeps_React_.useMemo)(function(){return function(param){var rowIndex=param.rowIndex,columnId=param.columnId;var adjustedRowIndex=rowIndex;adjustedRowIndex=rowIndex-pagination.pageIndex*pagination.pageSize;return gridData.hasOwnProperty(adjustedRowIndex)?gridData[adjustedRowIndex][columnId]||null:null}},[gridData,pagination.pageIndex,pagination.pageSize]);gridData=(0,external_osdSharedDeps_React_.useMemo)(function(){var rowStart=pagination.pageIndex*pagination.pageSize;var rowEnd=Math.min(rowStart+pagination.pageSize,gridData.length);return gridData.slice(rowStart,rowEnd)},[gridData,pagination]);var _useState3=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)({}),2),columnWidths=_useState3[0],setColumnWidths=_useState3[1];var onColumnResize=(0,external_osdSharedDeps_React_.useCallback)(function(param){var columnId=param.columnId,width=param.width;setColumnWidths((0,_object_spread_props._)((0,_object_spread._)({},columnWidths),(0,_define_property._)({},columnId,width)))},[columnWidths]);return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiDataGrid,{"aria-label":dataGridAriaLabel,columns:columns.map(function(column){if(columnWidths[column.id]){return(0,_object_spread_props._)((0,_object_spread._)({},column),{initialWidth:columnWidths[column.id]})}return column}),columnVisibility:{visibleColumns:visibleColumns,setVisibleColumns:setVisibleColumns},rowCount:data.length,renderCellValue:renderCellValue,sorting:{columns:sortingColumns,onSort:onSort},toolbarVisibility:{showFullScreenSelector:false},onColumnResize:onColumnResize,pagination:(0,_object_spread_props._)((0,_object_spread._)({},pagination),{pageSizeOptions:[DEFAULT_PAGE_SIZE,25,50],onChangeItemsPerPage:onChangeItemsPerPage,onChangePage:onChangePage})})};var getDataGridArialabel=function(view){return external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.dataViewer.gridAriaLabel",{defaultMessage:"{name} data grid",values:{name:view.id}})};var dataSetAriaLabel=external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.dataViewer.dataSetAriaLabel",{defaultMessage:"Data set"});var DataViewer=function(_param){var vegaAdapter=_param.vegaAdapter,rest=(0,_object_without_properties._)(_param,["vegaAdapter"]);var _useState=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)([]),2),inspectDataSets=_useState[0],setInspectDataSets=_useState[1];var _useState1=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)(),2),selectedView=_useState1[0],setSelectedView=_useState1[1];var _useState2=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)(""),2),dataGridAriaLabel=_useState2[0],setDataGridAriaLabel=_useState2[1];var onViewChange=(0,external_osdSharedDeps_React_.useCallback)(function(selectedOptions){var newView=inspectDataSets.find(function(view){return view.id===selectedOptions[0].label});if(newView){setDataGridAriaLabel(getDataGridArialabel(newView));setSelectedView(newView)}},[inspectDataSets]);(0,external_osdSharedDeps_React_.useEffect)(function(){var subscription=vegaAdapter.getDataSetsSubscription().subscribe(function(dataSets){setInspectDataSets(dataSets)});return function(){subscription.unsubscribe()}},[vegaAdapter]);(0,external_osdSharedDeps_React_.useEffect)(function(){if(inspectDataSets){if(!selectedView){setSelectedView(inspectDataSets[0])}else{setDataGridAriaLabel(getDataGridArialabel(selectedView))}}},[selectedView,inspectDataSets]);if(!selectedView){return null}return(0,jsx_runtime.jsxs)(external_osdSharedDeps_ElasticEui_.EuiFlexGroup,(0,_object_spread_props._)((0,_object_spread._)({direction:"column",gutterSize:"s",wrap:false,responsive:false},rest),{children:[(0,jsx_runtime.jsxs)(external_osdSharedDeps_ElasticEui_.EuiFlexItem,{grow:false,children:[(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiSpacer,{size:"s"}),(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiCompressedComboBox,{fullWidth:true,options:inspectDataSets.map(function(item){return{label:item.id}}),"aria-label":dataSetAriaLabel,onChange:onViewChange,isClearable:false,singleSelection:{asPlainText:true},selectedOptions:[{label:selectedView.id}]})]}),(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiFlexItem,{grow:true,children:(0,jsx_runtime.jsx)(InspectorDataGrid,{columns:selectedView.columns,data:selectedView.data,dataGridAriaLabel:dataGridAriaLabel})})]}))};var initialSignalColumnWidth=150;var signalDataGridAriaLabel=external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.signalViewer.gridAriaLabel",{defaultMessage:"Signal values data grid"});var SignalViewer=function(param){var vegaAdapter=param.vegaAdapter;var _useState=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)(),2),inspectSignalsSets=_useState[0],setInspectSignalsSets=_useState[1];(0,external_osdSharedDeps_React_.useEffect)(function(){var subscription=vegaAdapter.getSignalsSetsSubscription().subscribe(function(signalSets){if(signalSets){setInspectSignalsSets(signalSets)}});return function(){subscription.unsubscribe()}},[vegaAdapter]);if(!inspectSignalsSets){return null}return(0,jsx_runtime.jsxs)("div",{children:[(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiSpacer,{size:"s"}),(0,jsx_runtime.jsx)(InspectorDataGrid,{columns:inspectSignalsSets.columns.map(function(column,index){if(index===0){return(0,_object_spread_props._)((0,_object_spread._)({},column),{initialWidth:initialSignalColumnWidth})}return column}),data:inspectSignalsSets.data,dataGridAriaLabel:signalDataGridAriaLabel})]})};var copyToClipboardLabel=external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.specViewer.copyToClipboardLabel",{defaultMessage:"Copy to clipboard"});var SpecViewer=function(_param){var vegaAdapter=_param.vegaAdapter,rest=(0,_object_without_properties._)(_param,["vegaAdapter"]);var _useState=(0,_sliced_to_array._)((0,external_osdSharedDeps_React_.useState)(),2),spec=_useState[0],setSpec=_useState[1];(0,external_osdSharedDeps_React_.useEffect)(function(){var subscription=vegaAdapter.getSpecSubscription().subscribe(function(data){if(data){setSpec(data)}});return function(){subscription.unsubscribe()}},[vegaAdapter]);if(!spec){return null}return(0,jsx_runtime.jsxs)(external_osdSharedDeps_ElasticEui_.EuiFlexGroup,(0,_object_spread_props._)((0,_object_spread._)({direction:"column",gutterSize:"s",wrap:false,responsive:false},rest),{children:[(0,jsx_runtime.jsxs)(external_osdSharedDeps_ElasticEui_.EuiFlexItem,{grow:false,children:[(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiSpacer,{size:"s"}),(0,jsx_runtime.jsx)("div",{className:"eui-textRight",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiCopy,{textToCopy:spec,children:function(copy){return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiButtonEmpty,{size:"xs",flush:"right",iconType:"copyClipboard",onClick:copy,"data-test-subj":"vegaDataInspectorCopyClipboardButton",children:copyToClipboardLabel})}})})]}),(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiFlexItem,{grow:true,children:(0,jsx_runtime.jsx)(opensearch_dashboards_react_public.CodeEditor,{languageId:"json",value:spec,onChange:function(){},options:{readOnly:true,lineNumbers:"off",fontSize:12,minimap:{enabled:false},scrollBeyondLastLine:false,wordWrap:"on",wrappingIndent:"indent",automaticLayout:true}})})]}))};;var dataSetsLabel=external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.dataSetsLabel",{defaultMessage:"Data sets"});var signalValuesLabel=external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.signalValuesLabel",{defaultMessage:"Signal values"});var specLabel=external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.specLabel",{defaultMessage:"Spec"});var VegaDataInspector=function(param){var adapters=param.adapters;var tabs=[{id:"data-viewer--id",name:dataSetsLabel,content:(0,jsx_runtime.jsx)(DataViewer,{vegaAdapter:adapters.vega}),"data-test-subj":"vegaDataInspectorDataViewerButton"},{id:"signal-viewer--id",name:signalValuesLabel,content:(0,jsx_runtime.jsx)(SignalViewer,{vegaAdapter:adapters.vega}),"data-test-subj":"vegaDataInspectorSignalViewerButton"},{id:"spec-viewer--id",name:specLabel,content:(0,jsx_runtime.jsx)(SpecViewer,{className:"vgaVegaDataInspector__specViewer",vegaAdapter:adapters.vega}),"data-test-subj":"vegaDataInspectorSpecViewerButton"}];return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_.EuiTabbedContent,{className:"vgaVegaDataInspector",size:"s",tabs:tabs,initialSelectedTab:tabs[0],autoFocus:"selected"})};var inspector_public=__webpack_require__(5443);var vegaDebugLabel=external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.inspector.vegaDebugLabel",{defaultMessage:"Vega debug"});var getVegaInspectorView=function(dependencies){return{title:vegaDebugLabel,shouldShow:function shouldShow(adapters){return Boolean(adapters.vega)},component:function(props){return(0,jsx_runtime.jsx)(opensearch_dashboards_react_public.OpenSearchDashboardsContextProvider,{services:dependencies,children:(0,jsx_runtime.jsx)(VegaDataInspector,(0,_object_spread_props._)((0,_object_spread._)({},props),{children:" "}))})}}};var createInspectorAdapters=function(){return{requests:new inspector_public.RequestAdapter,vega:new vega_adapter_VegaAdapter}};var visualizations_public=__webpack_require__(3991);var createVegaTypeDefinition=function(dependencies){var requestHandler=createVegaRequestHandler(dependencies);var visualization=createVegaVisualization(dependencies);return{name:"vega",title:"Vega",description:external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.type.vegaDescription",{defaultMessage:"Create custom visualizations using Vega and Vega-Lite",description:"Vega and Vega-Lite are product names and should not be translated"}),icon:"visVega",isClassic:true,visConfig:{defaults:{spec:getDefaultSpec()}},editorConfig:{optionsTemplate:VegaVisEditor,enableAutoApply:true,defaultSize:vis_default_editor_public.DefaultEditorSize.MEDIUM},visualization:visualization,requestHandler:requestHandler,responseHandler:"none",options:{showIndexSelection:false,showQueryBar:true,showFilterBar:true},getSupportedTriggers:function(){return[visualizations_public.VIS_EVENT_TO_TRIGGER.applyFilter,visualizations_public.VIS_EVENT_TO_TRIGGER.externalAction]},getUsedIndexPattern:function(visParams){return(0,_async_to_generator._)(function(){var spec;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){try{spec=(0,hjson.parse)(visParams.spec,{legacyRoot:false,keepWsc:true});return[2,(0,extract_index_pattern.a)(spec)]}catch(e){}return[2,[]]})})()},inspectorAdapters:createInspectorAdapters}};var public_0=__webpack_require__(3664);var vis_augmenter_public=__webpack_require__(5075);var getXAxisId=function(dimensions,columns){return columns.filter(function(column){return column.name===dimensions.x.label})[0].id};var cleanString=function(rawString){return rawString.replaceAll('"',"")};var calculateLegendOffset=function(legendPosition){return legendPosition==="top"||legendPosition==="bottom"?0:18};var formatDatatable=function(datatable){datatable.columns.forEach(function(column){column.name=cleanString(column.name);column.id=column.id.replaceAll(".","-")});var updatedRows=datatable.rows.map(function(row){return Object.entries(row).reduce(function(updatedRow,param){var _param=(0,_sliced_to_array._)(param,2),key=_param[0],value=_param[1];var cleanKey=key.replaceAll(".","-");return Object.assign(updatedRow,(0,_define_property._)({},cleanKey,value))},{})});datatable.rows=updatedRows;return datatable};var setupConfig=function(visParams,config){var legendPosition=visParams.legendPosition;return{view:{stroke:null},concat:{spacing:0},legend:{orient:legendPosition,offset:calculateLegendOffset(legendPosition)},kibana:{hideWarnings:true,visAugmenterConfig:config}}};var buildLayerMark=function(seriesParams){return{type:seriesParams.type,interpolate:seriesParams.interpolate,strokeWidth:seriesParams.lineWidth,point:seriesParams.showCircles}};var buildXAxis=function(xAxisTitle,xAxisId,visParams){return{axis:{title:xAxisTitle,grid:visParams.grid.categoryLines},field:xAxisId,type:"temporal"}};var buildYAxis=function(column,valueAxis,visParams){var _column_meta;var subAxis={title:cleanString(valueAxis.title.text)||column.name,grid:visParams.grid.valueAxis!==undefined,orient:valueAxis.position,labels:valueAxis.labels.show,labelAngle:valueAxis.labels.rotate};if(((_column_meta=column.meta)===null||_column_meta===void 0?void 0:_column_meta.type)==="percentile_ranks")Object.assign(subAxis,{format:".0%"});return{axis:subAxis,field:column.id,type:"quantitative"}};var isXAxisColumn=function(column){var _column_meta_aggConfigParams,_column_meta;return((_column_meta=column.meta)===null||_column_meta===void 0?void 0:(_column_meta_aggConfigParams=_column_meta.aggConfigParams)===null||_column_meta_aggConfigParams===void 0?void 0:_column_meta_aggConfigParams.interval)!==undefined};var createSpecFromXYChartDatatable=function(datatable,visParams,dimensions,config){var _visParams_valueAxes;var spec={};spec.$schema="https://vega.github.io/schema/vega-lite/v5.json";spec.data={values:datatable.rows};spec.config=setupConfig(visParams,config);var valueAxis=new Map;visParams===null||visParams===void 0?void 0:(_visParams_valueAxes=visParams.valueAxes)===null||_visParams_valueAxes===void 0?void 0:_visParams_valueAxes.forEach(function(yAxis){valueAxis.set(yAxis.id,yAxis)});spec.layer=[];if(datatable.rows.length>0&&dimensions.x!==null){var xAxisId=getXAxisId(dimensions,datatable.columns);var xAxisTitle=cleanString(dimensions.x.label);datatable.columns.forEach(function(column,index){if(isXAxisColumn(column)||(0,vis_augmenter_public.isVisLayerColumn)(column))return;var seriesParamsId=column.id.split("-")[2];var currentSeriesParams=visParams.seriesParams.find(function(param){var _param_data;return(param===null||param===void 0?void 0:(_param_data=param.data)===null||_param_data===void 0?void 0:_param_data.id)===seriesParamsId});if(!currentSeriesParams){console.error("Failed to find matching series param for column of id: ".concat(column.id));return}var currentValueAxis=valueAxis.get(currentSeriesParams.valueAxis.toString());var tooltip=[];if(visParams.addTooltip){tooltip=[{field:xAxisId,type:"temporal",title:xAxisTitle},{field:column.id,type:"quantitative",title:column.name}]}spec.layer.push({mark:buildLayerMark(currentSeriesParams),encoding:{x:buildXAxis(xAxisTitle,xAxisId,visParams),y:buildYAxis(column,currentValueAxis,visParams),tooltip:tooltip,color:{datum:column.name}}})})}if(visParams.addTimeMarker){spec.transform=[{calculate:"now()",as:"now_field"}];spec.layer.push({mark:"rule",encoding:{x:{type:"temporal",field:"now_field"},color:{value:"red"},size:{value:1}}})}if(visParams.thresholdLine.show){var layer={mark:{type:"rule",color:visParams.thresholdLine.color,strokeDash:[1,0]},encoding:{y:{datum:visParams.thresholdLine.value}}};if(visParams.thresholdLine.style!=="full"){layer.mark.strokeDash=[8,8]}spec.layer.push(layer)}return spec};var createLineVegaSpecFn=function(dependencies){return{name:"line_vega_spec",type:"string",inputTypes:["opensearch_dashboards_datatable"],help:external_osdSharedDeps_OsdI18n_.i18n.translate("visTypeVega.function.helpSpec",{defaultMessage:"Construct line vega spec"}),args:{visLayers:{types:["string","null"],"default":"",help:""},visParams:{types:["string"],"default":'""',help:""},dimensions:{types:["string"],"default":'""',help:""},visAugmenterConfig:{types:["string"],"default":'""',help:""}},fn:function fn(input,args,context){return(0,_async_to_generator._)(function(){var table,visParams,dimensions,allVisLayers,visAugmenterConfig,pointInTimeEventsVisLayers,spec;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){table=formatDatatable((0,external_osdSharedDeps_Lodash_.cloneDeep)(input));visParams=JSON.parse(args.visParams);dimensions=JSON.parse(args.dimensions);allVisLayers=args.visLayers?JSON.parse(args.visLayers):[];visAugmenterConfig=JSON.parse(args.visAugmenterConfig);pointInTimeEventsVisLayers=allVisLayers.filter(function(visLayer){return(0,vis_augmenter_public.isPointInTimeEventsVisLayer)(visLayer)});if(!(0,external_osdSharedDeps_Lodash_.isEmpty)(pointInTimeEventsVisLayers)&&dimensions.x!==null){table=(0,vis_augmenter_public.addPointInTimeEventsLayersToTable)(table,dimensions,pointInTimeEventsVisLayers)}spec=createSpecFromXYChartDatatable(table,visParams,dimensions,visAugmenterConfig);if(!(0,external_osdSharedDeps_Lodash_.isEmpty)(pointInTimeEventsVisLayers)&&dimensions.x!==null){spec=(0,vis_augmenter_public.addPointInTimeEventsLayersToSpec)(table,dimensions,spec);spec.config=(0,vis_augmenter_public.enableVisLayersInSpecConfig)(spec,pointInTimeEventsVisLayers);spec.config=(0,vis_augmenter_public.addVisEventSignalsToSpecConfig)(spec)}spec=(0,vis_augmenter_public.augmentEventChartSpec)(visAugmenterConfig,spec);return[2,JSON.stringify(spec)]})})()}}};var plugin_VegaPlugin=function(){"use strict";function VegaPlugin(initializerContext){(0,_class_call_check._)(this,VegaPlugin);(0,_define_property._)(this,"initializerContext",void 0);this.initializerContext=initializerContext}(0,_create_class._)(VegaPlugin,[{key:"setup",value:function setup(_0,_1){return(0,_async_to_generator._)(function(core,param){var inspector,data,expressions,visualizations,mapsLegacy,dataSource,visualizationDependencies;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){inspector=param.inspector,data=param.data,expressions=param.expressions,visualizations=param.visualizations,mapsLegacy=param.mapsLegacy,dataSource=param.dataSource;(0,public_services.Xj)({enableExternalUrls:this.initializerContext.config.get().enableExternalUrls,exposeDebugObjectToWindow:this.initializerContext.config.get().exposeDebugObjectToWindow,emsTileLayerId:core.injectedMetadata.getInjectedVar("emsTileLayerId",true)});(0,public_services.Ur)(core.uiSettings);(0,public_services.z9)(mapsLegacy.config);(0,public_services.pl)({enabled:!!dataSource});visualizationDependencies={core:core,plugins:{data:data},getServiceSettings:mapsLegacy.getServiceSettings};inspector.registerView(getVegaInspectorView({uiSettings:core.uiSettings}));expressions.registerFunction(function(){return createVegaFn(visualizationDependencies)});expressions.registerFunction(function(){return createLineVegaSpecFn(visualizationDependencies)});visualizations.createBaseVisualization(createVegaTypeDefinition(visualizationDependencies));return[2]})}).apply(this,arguments)}},{key:"start",value:function start(core,param){var data=param.data,uiActions=param.uiActions;(0,public_services.d_)(core.notifications);(0,public_services.XO)(data);(0,public_services.Nw)(core.savedObjects);(0,public_services.EZ)(uiActions);(0,public_services.EG)(core.injectedMetadata)}}]);return VegaPlugin}();;function public_plugin(initializerContext){return new plugin_VegaPlugin(initializerContext)}},2162:function(__unused_webpack_module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{a:()=>extractIndexPatternsFromSpec});var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(5194);var _swc_helpers_ts_generator__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(2790);var _swc_helpers_ts_generator__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_swc_helpers_ts_generator__WEBPACK_IMPORTED_MODULE_3__);var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1731);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);var _services__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(3233);var extractIndexPatternsFromSpec=function(spec){return(0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_2__._)(function(){var indexPatterns,data;return(0,_swc_helpers_ts_generator__WEBPACK_IMPORTED_MODULE_3__.__generator)(this,function(_state){switch(_state.label){case 0:indexPatterns=(0,_services__WEBPACK_IMPORTED_MODULE_1__.bQ)().indexPatterns;data=[];if(Array.isArray(spec.data)){data=spec.data}else if(spec.data){data=[spec.data]}return[4,Promise.all(data.reduce(function(accumulator,currentValue){var _currentValue_url;if((_currentValue_url=currentValue.url)===null||_currentValue_url===void 0?void 0:_currentValue_url.index){accumulator.push(indexPatterns.find(currentValue.url.index))}return accumulator},[]))];case 1:return[2,lodash__WEBPACK_IMPORTED_MODULE_0__.flatten.apply(void 0,[_state.sent()])]}})})()}},3233:function(__unused_webpack_module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{Bt:()=>getShowRegionDeniedWarning,D8:()=>getDataSourceEnabled,EG:()=>setInjectedMetadata,EZ:()=>setUiActions,LJ:()=>getSavedObjectsClient,Nw:()=>setSavedObjectsClient,Tr:()=>getNotifications,Ur:()=>setUISettings,XO:()=>setData,Xj:()=>setInjectedVars,bQ:()=>getData,cD:()=>getExposeDebugObjectToWindow,d_:()=>setNotifications,gG:()=>getEmsTileLayerId,o6:()=>getInjectedMetadata,pl:()=>setDataSourceEnabled,qG:()=>getUISettings,vP:()=>getEnableExternalUrls,z9:()=>setMapsLegacyConfig});var _swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(4242);var _opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6342);var _opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__);var _createGetterSetter=(0,_swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__._)((0,_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__.createGetterSetter)("Data"),2);var getData=_createGetterSetter[0],setData=_createGetterSetter[1];var _createGetterSetter1=(0,_swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__._)((0,_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__.createGetterSetter)("DataSource"),2);var getDataSourceEnabled=_createGetterSetter1[0],setDataSourceEnabled=_createGetterSetter1[1];var _createGetterSetter2=(0,_swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__._)((0,_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__.createGetterSetter)("SavedObjects"),2);var getSavedObjectsClient=_createGetterSetter2[0],setSavedObjectsClient=_createGetterSetter2[1];var _createGetterSetter3=(0,_swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__._)((0,_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__.createGetterSetter)("Notifications"),2);var getNotifications=_createGetterSetter3[0],setNotifications=_createGetterSetter3[1];var _createGetterSetter4=(0,_swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__._)((0,_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__.createGetterSetter)("UIActions"),2);var getUiActions=_createGetterSetter4[0],setUiActions=_createGetterSetter4[1];var _createGetterSetter5=(0,_swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__._)((0,_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__.createGetterSetter)("UISettings"),2);var getUISettings=_createGetterSetter5[0],setUISettings=_createGetterSetter5[1];var _createGetterSetter6=(0,_swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__._)((0,_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__.createGetterSetter)("InjectedMetadata"),2);var getInjectedMetadata=_createGetterSetter6[0],setInjectedMetadata=_createGetterSetter6[1];var _createGetterSetter7=(0,_swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__._)((0,_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__.createGetterSetter)("InjectedVars"),2);var getInjectedVars=_createGetterSetter7[0],setInjectedVars=_createGetterSetter7[1];var _createGetterSetter8=(0,_swc_helpers_sliced_to_array__WEBPACK_IMPORTED_MODULE_1__._)((0,_opensearch_dashboards_utils_public__WEBPACK_IMPORTED_MODULE_0__.createGetterSetter)("MapsLegacyConfig"),2);var getMapsLegacyConfig=_createGetterSetter8[0],setMapsLegacyConfig=_createGetterSetter8[1];var getEnableExternalUrls=function(){return getInjectedVars().enableExternalUrls};var getExposeDebugObjectToWindow=function(){return getInjectedVars().exposeDebugObjectToWindow};var getEmsTileLayerId=function(){return getMapsLegacyConfig().emsTileLayerId};var getShowRegionDeniedWarning=function(){return getMapsLegacyConfig().showRegionDeniedWarning}},3991:function(module){module.exports=__osdBundles__.get("plugin/visualizations/public")},1350:function(module){"use strict";module.exports=__osdSharedDeps__.ElasticEui},5760:function(module){"use strict";module.exports=__osdSharedDeps__.Jquery},1731:function(module){"use strict";module.exports=__osdSharedDeps__.Lodash},7518:function(module){"use strict";module.exports=__osdSharedDeps__.Moment},7528:function(module){"use strict";module.exports=__osdSharedDeps__.OsdI18n},6933:function(module){"use strict";module.exports=__osdSharedDeps__.React},2623:function(module){"use strict";module.exports=__osdSharedDeps__.Theme},2790:function(module){"use strict";module.exports=__osdSharedDeps__.TsLib},9071:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_array_like_to_array});function _array_like_to_array(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}},3890:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_array_with_holes});function _array_with_holes(arr){if(Array.isArray(arr))return arr}},5194:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_async_to_generator});function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done)resolve(value);else Promise.resolve(value).then(_next,_throw)}function _async_to_generator(fn){return function(){var self1=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self1,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value)}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err)}_next(undefined)})}}},7394:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_class_call_check});function _class_call_check(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}},4379:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_create_class});function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}function _create_class(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);return Constructor}},9623:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_define_property});function _define_property(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else obj[key]=value;return obj}},926:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_iterable_to_array});function _iterable_to_array(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null){return Array.from(iter)}}},1307:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_non_iterable_rest});function _non_iterable_rest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}},2961:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_object_spread});var _define_property_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(9623);function _object_spread(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};var ownKeys=Object.keys(source);if(typeof Object.getOwnPropertySymbols==="function"){ownKeys=ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym){return Object.getOwnPropertyDescriptor(source,sym).enumerable}))}ownKeys.forEach(function(key){(0,_define_property_js__WEBPACK_IMPORTED_MODULE_0__._)(target,key,source[key])})}return target}},5548:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_object_spread_props});function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);if(enumerableOnly){symbols=symbols.filter(function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable})}keys.push.apply(keys,symbols)}return keys}function _object_spread_props(target,source){source=source!=null?source:{};if(Object.getOwnPropertyDescriptors)Object.defineProperties(target,Object.getOwnPropertyDescriptors(source));else{ownKeys(Object(source)).forEach(function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))})}return target}},6816:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_object_without_properties});function _object_without_properties_loose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target};function _object_without_properties(source,excluded){if(source==null)return{};var target=_object_without_properties_loose(source,excluded);var key,i;if(Object.getOwnPropertySymbols){var sourceSymbolKeys=Object.getOwnPropertySymbols(source);for(i=0;i<sourceSymbolKeys.length;i++){key=sourceSymbolKeys[i];if(excluded.indexOf(key)>=0)continue;if(!Object.prototype.propertyIsEnumerable.call(source,key))continue;target[key]=source[key]}}return target}},4242:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_sliced_to_array});var _array_with_holes=__webpack_require__(3890);function _iterable_to_array_limit(arr,i){var _i=arr==null?null:typeof Symbol!=="undefined"&&arr[Symbol.iterator]||arr["@@iterator"];if(_i==null)return;var _arr=[];var _n=true;var _d=false;var _s,_e;try{for(_i=_i.call(arr);!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"]!=null)_i["return"]()}finally{if(_d)throw _e}}return _arr}var _non_iterable_rest=__webpack_require__(1307);var _unsupported_iterable_to_array=__webpack_require__(4986);function _sliced_to_array(arr,i){return(0,_array_with_holes._)(arr)||_iterable_to_array_limit(arr,i)||(0,_unsupported_iterable_to_array._)(arr,i)||(0,_non_iterable_rest._)()}},9190:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_to_consumable_array});var _array_like_to_array=__webpack_require__(9071);function _array_without_holes(arr){if(Array.isArray(arr))return(0,_array_like_to_array._)(arr)}var _iterable_to_array=__webpack_require__(926);function _non_iterable_spread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var _unsupported_iterable_to_array=__webpack_require__(4986);function _to_consumable_array(arr){return _array_without_holes(arr)||(0,_iterable_to_array._)(arr)||(0,_unsupported_iterable_to_array._)(arr)||_non_iterable_spread()}},5310:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_type_of});function _type_of(obj){"@swc/helpers - typeof";return obj&&typeof Symbol!=="undefined"&&obj.constructor===Symbol?"symbol":typeof obj}},4986:function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,{_:()=>_unsupported_iterable_to_array});var _array_like_to_array_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(9071);function _unsupported_iterable_to_array(o,minLen){if(!o)return;if(typeof o==="string")return(0,_array_like_to_array_js__WEBPACK_IMPORTED_MODULE_0__._)(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(n);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return(0,_array_like_to_array_js__WEBPACK_IMPORTED_MODULE_0__._)(o,minLen)}}};var __webpack_module_cache__={};function __webpack_require__(moduleId){var cachedModule=__webpack_module_cache__[moduleId];if(cachedModule!==undefined){return cachedModule.exports}var module=__webpack_module_cache__[moduleId]={id:moduleId,exports:{}};__webpack_modules__[moduleId].call(module.exports,module,module.exports,__webpack_require__);return module.exports}__webpack_require__.m=__webpack_modules__;(()=>{__webpack_require__.n=module=>{var getter=module&&module.__esModule?()=>module["default"]:()=>module;__webpack_require__.d(getter,{a:getter});return getter}})();(()=>{__webpack_require__.d=(exports,definition)=>{for(var key in definition){if(__webpack_require__.o(definition,key)&&!__webpack_require__.o(exports,key)){Object.defineProperty(exports,key,{enumerable:true,get:definition[key]})}}}})();(()=>{__webpack_require__.f={};__webpack_require__.e=chunkId=>{return Promise.all(Object.keys(__webpack_require__.f).reduce((promises,key)=>{__webpack_require__.f[key](chunkId,promises);return promises},[]))}})();(()=>{__webpack_require__.u=chunkId=>{return"visTypeVega.chunk."+chunkId+".js"}})();(()=>{__webpack_require__.g=(()=>{if(typeof globalThis==="object")return globalThis;try{return this||new Function("return this")()}catch(e){if(typeof window==="object")return window}})()})();(()=>{__webpack_require__.o=(obj,prop)=>Object.prototype.hasOwnProperty.call(obj,prop)})();(()=>{var inProgress={};null;__webpack_require__.l=function(url,done,key,chunkId){if(inProgress[url]){inProgress[url].push(done);return}var script,needAttach;if(key!==undefined){var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var s=scripts[i];if(s.getAttribute("src")==url){script=s;break}}}if(!script){needAttach=true;script=document.createElement("script");script.timeout=120;if(__webpack_require__.nc){script.setAttribute("nonce",__webpack_require__.nc)}script.src=url}inProgress[url]=[done];var onScriptComplete=function(prev,event){script.onerror=script.onload=null;clearTimeout(timeout);var doneFns=inProgress[url];delete inProgress[url];script.parentNode&&script.parentNode.removeChild(script);doneFns&&doneFns.forEach(function(fn){return fn(event)});if(prev)return prev(event)};var timeout=setTimeout(onScriptComplete.bind(null,undefined,{type:"timeout",target:script}),12e4);script.onerror=onScriptComplete.bind(null,script.onerror);script.onload=onScriptComplete.bind(null,script.onload);needAttach&&document.head.appendChild(script)}})();(()=>{__webpack_require__.r=exports=>{if(typeof Symbol!=="undefined"&&Symbol.toStringTag){Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"})}Object.defineProperty(exports,"__esModule",{value:true})}})();(()=>{__webpack_require__.nc=undefined})();(()=>{__webpack_require__.rv=()=>"1.6.4"})();(()=>{var scriptUrl;if(__webpack_require__.g.importScripts)scriptUrl=__webpack_require__.g.location+"";var document1=__webpack_require__.g.document;if(!scriptUrl&&document1){if(document1.currentScript&&document1.currentScript.tagName.toUpperCase()==="SCRIPT")scriptUrl=document1.currentScript.src;if(!scriptUrl){var scripts=document1.getElementsByTagName("script");if(scripts.length){var i=scripts.length-1;while(i>-1&&(!scriptUrl||!/^http(s?):/.test(scriptUrl)))scriptUrl=scripts[i--].src}}}if(!scriptUrl)throw new Error("Automatic publicPath is not supported in this browser");scriptUrl=scriptUrl.replace(/^blob:/,"").replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/");__webpack_require__.p=scriptUrl})();(()=>{var installedChunks={"5":0};__webpack_require__.f.j=function(chunkId,promises){var installedChunkData=__webpack_require__.o(installedChunks,chunkId)?installedChunks[chunkId]:undefined;if(installedChunkData!==0){if(installedChunkData){promises.push(installedChunkData[2])}else{if(true){var promise=new Promise((resolve,reject)=>installedChunkData=installedChunks[chunkId]=[resolve,reject]);promises.push(installedChunkData[2]=promise);var url=__webpack_require__.p+__webpack_require__.u(chunkId);var error=new Error;var loadingEnded=function(event){if(__webpack_require__.o(installedChunks,chunkId)){installedChunkData=installedChunks[chunkId];if(installedChunkData!==0)installedChunks[chunkId]=undefined;if(installedChunkData){var errorType=event&&(event.type==="load"?"missing":event.type);var realSrc=event&&event.target&&event.target.src;error.message="Loading chunk "+chunkId+" failed.\n("+errorType+": "+realSrc+")";error.name="ChunkLoadError";error.type=errorType;error.request=realSrc;installedChunkData[1](error)}}};__webpack_require__.l(url,loadingEnded,"chunk-"+chunkId,chunkId)}}}};var webpackJsonpCallback=(parentChunkLoadingFunction,data)=>{var chunkIds=data[0];var moreModules=data[1];var runtime=data[2];var moduleId,chunkId,i=0;if(chunkIds.some(id=>installedChunks[id]!==0)){for(moduleId in moreModules){if(__webpack_require__.o(moreModules,moduleId)){__webpack_require__.m[moduleId]=moreModules[moduleId]}}if(runtime)var result=runtime(__webpack_require__)}if(parentChunkLoadingFunction)parentChunkLoadingFunction(data);for(;i<chunkIds.length;i++){chunkId=chunkIds[i];if(__webpack_require__.o(installedChunks,chunkId)&&installedChunks[chunkId]){installedChunks[chunkId][0]()}installedChunks[chunkId]=0}};var chunkLoadingGlobal=self["visTypeVega_bundle_jsonpfunction"]=self["visTypeVega_bundle_jsonpfunction"]||[];chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null,0));chunkLoadingGlobal.push=webpackJsonpCallback.bind(null,chunkLoadingGlobal.push.bind(chunkLoadingGlobal))})();(()=>{__webpack_require__.ruid="bundler=rspack@1.6.4"})();var __webpack_exports__={};(()=>{"use strict";var _node_modules_val_loader_dist_cjs_js_key_visTypeVega_osd_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5868);var _node_modules_val_loader_dist_cjs_js_key_visTypeVega_osd_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_val_loader_dist_cjs_js_key_visTypeVega_osd_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__);__osdBundles__.define("plugin/visTypeVega/public",()=>{return __webpack_require__(4598)})})()})();