/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequestBuilder;
import org.opensearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.opensearch.action.admin.indices.analyze.AnalyzeAction;
import org.opensearch.action.admin.indices.analyze.AnalyzeRequestBuilder;
import org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheRequestBuilder;
import org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.opensearch.action.admin.indices.close.CloseIndexRequest;
import org.opensearch.action.admin.indices.close.CloseIndexRequestBuilder;
import org.opensearch.action.admin.indices.close.CloseIndexResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.datastream.CreateDataStreamAction;
import org.opensearch.action.admin.indices.datastream.DeleteDataStreamAction;
import org.opensearch.action.admin.indices.datastream.GetDataStreamAction;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.admin.indices.flush.FlushRequestBuilder;
import org.opensearch.action.admin.indices.flush.FlushResponse;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequestBuilder;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.opensearch.action.admin.indices.open.OpenIndexRequestBuilder;
import org.opensearch.action.admin.indices.open.OpenIndexResponse;
import org.opensearch.action.admin.indices.readonly.AddIndexBlockRequest;
import org.opensearch.action.admin.indices.readonly.AddIndexBlockRequestBuilder;
import org.opensearch.action.admin.indices.readonly.AddIndexBlockResponse;
import org.opensearch.action.admin.indices.recovery.RecoveryRequest;
import org.opensearch.action.admin.indices.recovery.RecoveryRequestBuilder;
import org.opensearch.action.admin.indices.recovery.RecoveryResponse;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.opensearch.action.admin.indices.refresh.RefreshResponse;
import org.opensearch.action.admin.indices.replication.SegmentReplicationStatsRequest;
import org.opensearch.action.admin.indices.replication.SegmentReplicationStatsRequestBuilder;
import org.opensearch.action.admin.indices.replication.SegmentReplicationStatsResponse;
import org.opensearch.action.admin.indices.resolve.ResolveIndexAction;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequestBuilder;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexRequestBuilder;
import org.opensearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.opensearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.opensearch.action.admin.indices.segments.IndicesSegmentsRequestBuilder;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequestBuilder;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.opensearch.action.admin.indices.shards.IndicesShardStoreRequestBuilder;
import org.opensearch.action.admin.indices.shards.IndicesShardStoresRequest;
import org.opensearch.action.admin.indices.shards.IndicesShardStoresResponse;
import org.opensearch.action.admin.indices.shrink.ResizeRequest;
import org.opensearch.action.admin.indices.shrink.ResizeRequestBuilder;
import org.opensearch.action.admin.indices.shrink.ResizeResponse;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.streamingingestion.pause.PauseIngestionRequest;
import org.opensearch.action.admin.indices.streamingingestion.pause.PauseIngestionResponse;
import org.opensearch.action.admin.indices.streamingingestion.resume.ResumeIngestionRequest;
import org.opensearch.action.admin.indices.streamingingestion.resume.ResumeIngestionResponse;
import org.opensearch.action.admin.indices.streamingingestion.state.GetIngestionStateRequest;
import org.opensearch.action.admin.indices.streamingingestion.state.GetIngestionStateResponse;
import org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequestBuilder;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesRequestBuilder;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.opensearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.opensearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.opensearch.action.admin.indices.upgrade.get.UpgradeStatusRequest;
import org.opensearch.action.admin.indices.upgrade.get.UpgradeStatusRequestBuilder;
import org.opensearch.action.admin.indices.upgrade.get.UpgradeStatusResponse;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeRequestBuilder;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryRequestBuilder;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.opensearch.action.admin.indices.view.CreateViewAction;
import org.opensearch.action.admin.indices.view.DeleteViewAction;
import org.opensearch.action.admin.indices.view.GetViewAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.transport.client.OpenSearchClient;

@PublicApi(since="1.0.0")
public interface IndicesAdminClient
extends OpenSearchClient {
    public ActionFuture<IndicesExistsResponse> exists(IndicesExistsRequest var1);

    public void exists(IndicesExistsRequest var1, ActionListener<IndicesExistsResponse> var2);

    public IndicesExistsRequestBuilder prepareExists(String ... var1);

    public ActionFuture<IndicesStatsResponse> stats(IndicesStatsRequest var1);

    public void stats(IndicesStatsRequest var1, ActionListener<IndicesStatsResponse> var2);

    public IndicesStatsRequestBuilder prepareStats(String ... var1);

    public ActionFuture<RecoveryResponse> recoveries(RecoveryRequest var1);

    public void recoveries(RecoveryRequest var1, ActionListener<RecoveryResponse> var2);

    public ActionFuture<SegmentReplicationStatsResponse> segmentReplicationStats(SegmentReplicationStatsRequest var1);

    public void segmentReplicationStats(SegmentReplicationStatsRequest var1, ActionListener<SegmentReplicationStatsResponse> var2);

    public RecoveryRequestBuilder prepareRecoveries(String ... var1);

    public SegmentReplicationStatsRequestBuilder prepareSegmentReplicationStats(String ... var1);

    public ActionFuture<IndicesSegmentResponse> segments(IndicesSegmentsRequest var1);

    public void segments(IndicesSegmentsRequest var1, ActionListener<IndicesSegmentResponse> var2);

    public IndicesSegmentsRequestBuilder prepareSegments(String ... var1);

    public ActionFuture<IndicesShardStoresResponse> shardStores(IndicesShardStoresRequest var1);

    public void shardStores(IndicesShardStoresRequest var1, ActionListener<IndicesShardStoresResponse> var2);

    public IndicesShardStoreRequestBuilder prepareShardStores(String ... var1);

    public ActionFuture<CreateIndexResponse> create(CreateIndexRequest var1);

    public void create(CreateIndexRequest var1, ActionListener<CreateIndexResponse> var2);

    public CreateIndexRequestBuilder prepareCreate(String var1);

    public ActionFuture<AcknowledgedResponse> delete(DeleteIndexRequest var1);

    public void delete(DeleteIndexRequest var1, ActionListener<AcknowledgedResponse> var2);

    public DeleteIndexRequestBuilder prepareDelete(String ... var1);

    public ActionFuture<CloseIndexResponse> close(CloseIndexRequest var1);

    public void close(CloseIndexRequest var1, ActionListener<CloseIndexResponse> var2);

    public CloseIndexRequestBuilder prepareClose(String ... var1);

    public ActionFuture<OpenIndexResponse> open(OpenIndexRequest var1);

    public void open(OpenIndexRequest var1, ActionListener<OpenIndexResponse> var2);

    public AddIndexBlockRequestBuilder prepareAddBlock(IndexMetadata.APIBlock var1, String ... var2);

    public void addBlock(AddIndexBlockRequest var1, ActionListener<AddIndexBlockResponse> var2);

    public OpenIndexRequestBuilder prepareOpen(String ... var1);

    public ActionFuture<RefreshResponse> refresh(RefreshRequest var1);

    public void refresh(RefreshRequest var1, ActionListener<RefreshResponse> var2);

    public RefreshRequestBuilder prepareRefresh(String ... var1);

    public ActionFuture<FlushResponse> flush(FlushRequest var1);

    public void flush(FlushRequest var1, ActionListener<FlushResponse> var2);

    public FlushRequestBuilder prepareFlush(String ... var1);

    public ActionFuture<ForceMergeResponse> forceMerge(ForceMergeRequest var1);

    public void forceMerge(ForceMergeRequest var1, ActionListener<ForceMergeResponse> var2);

    public ForceMergeRequestBuilder prepareForceMerge(String ... var1);

    public ActionFuture<UpgradeResponse> upgrade(UpgradeRequest var1);

    public void upgrade(UpgradeRequest var1, ActionListener<UpgradeResponse> var2);

    public UpgradeStatusRequestBuilder prepareUpgradeStatus(String ... var1);

    public ActionFuture<UpgradeStatusResponse> upgradeStatus(UpgradeStatusRequest var1);

    public void upgradeStatus(UpgradeStatusRequest var1, ActionListener<UpgradeStatusResponse> var2);

    public UpgradeRequestBuilder prepareUpgrade(String ... var1);

    public void getMappings(GetMappingsRequest var1, ActionListener<GetMappingsResponse> var2);

    public ActionFuture<GetMappingsResponse> getMappings(GetMappingsRequest var1);

    public GetMappingsRequestBuilder prepareGetMappings(String ... var1);

    public void getFieldMappings(GetFieldMappingsRequest var1, ActionListener<GetFieldMappingsResponse> var2);

    public GetFieldMappingsRequestBuilder prepareGetFieldMappings(String ... var1);

    public ActionFuture<GetFieldMappingsResponse> getFieldMappings(GetFieldMappingsRequest var1);

    public ActionFuture<AcknowledgedResponse> putMapping(PutMappingRequest var1);

    public void putMapping(PutMappingRequest var1, ActionListener<AcknowledgedResponse> var2);

    public PutMappingRequestBuilder preparePutMapping(String ... var1);

    public ActionFuture<AcknowledgedResponse> aliases(IndicesAliasesRequest var1);

    public void aliases(IndicesAliasesRequest var1, ActionListener<AcknowledgedResponse> var2);

    public IndicesAliasesRequestBuilder prepareAliases();

    public ActionFuture<GetAliasesResponse> getAliases(GetAliasesRequest var1);

    public void getAliases(GetAliasesRequest var1, ActionListener<GetAliasesResponse> var2);

    public GetAliasesRequestBuilder prepareGetAliases(String ... var1);

    public ActionFuture<GetIndexResponse> getIndex(GetIndexRequest var1);

    public void getIndex(GetIndexRequest var1, ActionListener<GetIndexResponse> var2);

    public GetIndexRequestBuilder prepareGetIndex();

    public ActionFuture<ClearIndicesCacheResponse> clearCache(ClearIndicesCacheRequest var1);

    public void clearCache(ClearIndicesCacheRequest var1, ActionListener<ClearIndicesCacheResponse> var2);

    public ClearIndicesCacheRequestBuilder prepareClearCache(String ... var1);

    public ActionFuture<AcknowledgedResponse> updateSettings(UpdateSettingsRequest var1);

    public void updateSettings(UpdateSettingsRequest var1, ActionListener<AcknowledgedResponse> var2);

    public UpdateSettingsRequestBuilder prepareUpdateSettings(String ... var1);

    public ActionFuture<AnalyzeAction.Response> analyze(AnalyzeAction.Request var1);

    public void analyze(AnalyzeAction.Request var1, ActionListener<AnalyzeAction.Response> var2);

    public AnalyzeRequestBuilder prepareAnalyze(@Nullable String var1, String var2);

    public AnalyzeRequestBuilder prepareAnalyze(String var1);

    public AnalyzeRequestBuilder prepareAnalyze();

    public ActionFuture<AcknowledgedResponse> putTemplate(PutIndexTemplateRequest var1);

    public void putTemplate(PutIndexTemplateRequest var1, ActionListener<AcknowledgedResponse> var2);

    public PutIndexTemplateRequestBuilder preparePutTemplate(String var1);

    public ActionFuture<AcknowledgedResponse> deleteTemplate(DeleteIndexTemplateRequest var1);

    public void deleteTemplate(DeleteIndexTemplateRequest var1, ActionListener<AcknowledgedResponse> var2);

    public DeleteIndexTemplateRequestBuilder prepareDeleteTemplate(String var1);

    public ActionFuture<GetIndexTemplatesResponse> getTemplates(GetIndexTemplatesRequest var1);

    public void getTemplates(GetIndexTemplatesRequest var1, ActionListener<GetIndexTemplatesResponse> var2);

    public GetIndexTemplatesRequestBuilder prepareGetTemplates(String ... var1);

    public ActionFuture<ValidateQueryResponse> validateQuery(ValidateQueryRequest var1);

    public void validateQuery(ValidateQueryRequest var1, ActionListener<ValidateQueryResponse> var2);

    public ValidateQueryRequestBuilder prepareValidateQuery(String ... var1);

    public void getSettings(GetSettingsRequest var1, ActionListener<GetSettingsResponse> var2);

    public ActionFuture<GetSettingsResponse> getSettings(GetSettingsRequest var1);

    public GetSettingsRequestBuilder prepareGetSettings(String ... var1);

    public ResizeRequestBuilder prepareResizeIndex(String var1, String var2);

    public ActionFuture<ResizeResponse> resizeIndex(ResizeRequest var1);

    public void resizeIndex(ResizeRequest var1, ActionListener<ResizeResponse> var2);

    public RolloverRequestBuilder prepareRolloverIndex(String var1);

    public ActionFuture<RolloverResponse> rolloverIndex(RolloverRequest var1);

    public void rolloverIndex(RolloverRequest var1, ActionListener<RolloverResponse> var2);

    public void createDataStream(CreateDataStreamAction.Request var1, ActionListener<AcknowledgedResponse> var2);

    public ActionFuture<AcknowledgedResponse> createDataStream(CreateDataStreamAction.Request var1);

    public void deleteDataStream(DeleteDataStreamAction.Request var1, ActionListener<AcknowledgedResponse> var2);

    public ActionFuture<AcknowledgedResponse> deleteDataStream(DeleteDataStreamAction.Request var1);

    public void getDataStreams(GetDataStreamAction.Request var1, ActionListener<GetDataStreamAction.Response> var2);

    public ActionFuture<GetDataStreamAction.Response> getDataStreams(GetDataStreamAction.Request var1);

    public void resolveIndex(ResolveIndexAction.Request var1, ActionListener<ResolveIndexAction.Response> var2);

    public ActionFuture<ResolveIndexAction.Response> resolveIndex(ResolveIndexAction.Request var1);

    public void createView(CreateViewAction.Request var1, ActionListener<GetViewAction.Response> var2);

    public ActionFuture<GetViewAction.Response> createView(CreateViewAction.Request var1);

    public void getView(GetViewAction.Request var1, ActionListener<GetViewAction.Response> var2);

    public ActionFuture<GetViewAction.Response> getView(GetViewAction.Request var1);

    public void deleteView(DeleteViewAction.Request var1, ActionListener<AcknowledgedResponse> var2);

    public ActionFuture<AcknowledgedResponse> deleteView(DeleteViewAction.Request var1);

    public void updateView(CreateViewAction.Request var1, ActionListener<GetViewAction.Response> var2);

    public ActionFuture<GetViewAction.Response> updateView(CreateViewAction.Request var1);

    public ActionFuture<PauseIngestionResponse> pauseIngestion(PauseIngestionRequest var1);

    public void pauseIngestion(PauseIngestionRequest var1, ActionListener<PauseIngestionResponse> var2);

    public ActionFuture<ResumeIngestionResponse> resumeIngestion(ResumeIngestionRequest var1);

    public void resumeIngestion(ResumeIngestionRequest var1, ActionListener<ResumeIngestionResponse> var2);

    public ActionFuture<GetIngestionStateResponse> getIngestionState(GetIngestionStateRequest var1);

    public void getIngestionState(GetIngestionStateRequest var1, ActionListener<GetIngestionStateResponse> var2);

    public ScaleIndexRequestBuilder prepareScaleSearchOnly(String var1, boolean var2);

    default public CompletionStage<IndicesExistsResponse> existsAsync(IndicesExistsRequest request) {
        CompletableFuture<IndicesExistsResponse> future = new CompletableFuture<IndicesExistsResponse>();
        this.exists(request, (ActionListener<IndicesExistsResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<IndicesStatsResponse> statsAsync(IndicesStatsRequest request) {
        CompletableFuture<IndicesStatsResponse> future = new CompletableFuture<IndicesStatsResponse>();
        this.stats(request, (ActionListener<IndicesStatsResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<RecoveryResponse> recoveriesAsync(RecoveryRequest request) {
        CompletableFuture<RecoveryResponse> future = new CompletableFuture<RecoveryResponse>();
        this.recoveries(request, (ActionListener<RecoveryResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<SegmentReplicationStatsResponse> segmentReplicationStatsAsync(SegmentReplicationStatsRequest request) {
        CompletableFuture<SegmentReplicationStatsResponse> future = new CompletableFuture<SegmentReplicationStatsResponse>();
        this.segmentReplicationStats(request, (ActionListener<SegmentReplicationStatsResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<IndicesSegmentResponse> segmentsAsync(IndicesSegmentsRequest request) {
        CompletableFuture<IndicesSegmentResponse> future = new CompletableFuture<IndicesSegmentResponse>();
        this.segments(request, (ActionListener<IndicesSegmentResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<IndicesShardStoresResponse> shardStoresAsync(IndicesShardStoresRequest request) {
        CompletableFuture<IndicesShardStoresResponse> future = new CompletableFuture<IndicesShardStoresResponse>();
        this.shardStores(request, (ActionListener<IndicesShardStoresResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<CreateIndexResponse> createAsync(CreateIndexRequest request) {
        CompletableFuture<CreateIndexResponse> future = new CompletableFuture<CreateIndexResponse>();
        this.create(request, (ActionListener<CreateIndexResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AcknowledgedResponse> deleteAsync(DeleteIndexRequest request) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        this.delete(request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<CloseIndexResponse> closeAsync(CloseIndexRequest request) {
        CompletableFuture<CloseIndexResponse> future = new CompletableFuture<CloseIndexResponse>();
        this.close(request, (ActionListener<CloseIndexResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<OpenIndexResponse> openAsync(OpenIndexRequest request) {
        CompletableFuture<OpenIndexResponse> future = new CompletableFuture<OpenIndexResponse>();
        this.open(request, (ActionListener<OpenIndexResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AddIndexBlockResponse> addBlockAsync(AddIndexBlockRequest request) {
        CompletableFuture<AddIndexBlockResponse> future = new CompletableFuture<AddIndexBlockResponse>();
        this.addBlock(request, (ActionListener<AddIndexBlockResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<RefreshResponse> refreshAsync(RefreshRequest request) {
        CompletableFuture<RefreshResponse> future = new CompletableFuture<RefreshResponse>();
        this.refresh(request, (ActionListener<RefreshResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<FlushResponse> flushAsync(FlushRequest request) {
        CompletableFuture<FlushResponse> future = new CompletableFuture<FlushResponse>();
        this.flush(request, (ActionListener<FlushResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<ForceMergeResponse> forceMergeAsync(ForceMergeRequest request) {
        CompletableFuture<ForceMergeResponse> future = new CompletableFuture<ForceMergeResponse>();
        this.forceMerge(request, (ActionListener<ForceMergeResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<UpgradeResponse> upgradeAsync(UpgradeRequest request) {
        CompletableFuture<UpgradeResponse> future = new CompletableFuture<UpgradeResponse>();
        this.upgrade(request, (ActionListener<UpgradeResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<UpgradeStatusResponse> upgradeStatusAsync(UpgradeStatusRequest request) {
        CompletableFuture<UpgradeStatusResponse> future = new CompletableFuture<UpgradeStatusResponse>();
        this.upgradeStatus(request, (ActionListener<UpgradeStatusResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetMappingsResponse> getMappingsAsync(GetMappingsRequest request) {
        CompletableFuture<GetMappingsResponse> future = new CompletableFuture<GetMappingsResponse>();
        this.getMappings(request, (ActionListener<GetMappingsResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetFieldMappingsResponse> getFieldMappingsAsync(GetFieldMappingsRequest request) {
        CompletableFuture<GetFieldMappingsResponse> future = new CompletableFuture<GetFieldMappingsResponse>();
        this.getFieldMappings(request, (ActionListener<GetFieldMappingsResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AcknowledgedResponse> putMappingAsync(PutMappingRequest request) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        this.putMapping(request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AcknowledgedResponse> aliasesAsync(IndicesAliasesRequest request) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        this.aliases(request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetAliasesResponse> getAliasesAsync(GetAliasesRequest request) {
        CompletableFuture<GetAliasesResponse> future = new CompletableFuture<GetAliasesResponse>();
        this.getAliases(request, (ActionListener<GetAliasesResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetIndexResponse> getIndexAsync(GetIndexRequest request) {
        CompletableFuture<GetIndexResponse> future = new CompletableFuture<GetIndexResponse>();
        this.getIndex(request, (ActionListener<GetIndexResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<ClearIndicesCacheResponse> clearCacheAsync(ClearIndicesCacheRequest request) {
        CompletableFuture<ClearIndicesCacheResponse> future = new CompletableFuture<ClearIndicesCacheResponse>();
        this.clearCache(request, (ActionListener<ClearIndicesCacheResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AcknowledgedResponse> updateSettingsAsync(UpdateSettingsRequest request) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        this.updateSettings(request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetSettingsResponse> getSettingsAsync(GetSettingsRequest request) {
        CompletableFuture<GetSettingsResponse> future = new CompletableFuture<GetSettingsResponse>();
        this.getSettings(request, (ActionListener<GetSettingsResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AnalyzeAction.Response> analyzeAsync(AnalyzeAction.Request request) {
        CompletableFuture<AnalyzeAction.Response> future = new CompletableFuture<AnalyzeAction.Response>();
        this.analyze(request, (ActionListener<AnalyzeAction.Response>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AcknowledgedResponse> putTemplateAsync(PutIndexTemplateRequest request) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        this.putTemplate(request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AcknowledgedResponse> deleteTemplateAsync(DeleteIndexTemplateRequest request) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        this.deleteTemplate(request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetIndexTemplatesResponse> getTemplatesAsync(GetIndexTemplatesRequest request) {
        CompletableFuture<GetIndexTemplatesResponse> future = new CompletableFuture<GetIndexTemplatesResponse>();
        this.getTemplates(request, (ActionListener<GetIndexTemplatesResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<ValidateQueryResponse> validateQueryAsync(ValidateQueryRequest request) {
        CompletableFuture<ValidateQueryResponse> future = new CompletableFuture<ValidateQueryResponse>();
        this.validateQuery(request, (ActionListener<ValidateQueryResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<ResizeResponse> resizeIndexAsync(ResizeRequest request) {
        CompletableFuture<ResizeResponse> future = new CompletableFuture<ResizeResponse>();
        this.resizeIndex(request, (ActionListener<ResizeResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<RolloverResponse> rolloverIndexAsync(RolloverRequest request) {
        CompletableFuture<RolloverResponse> future = new CompletableFuture<RolloverResponse>();
        this.rolloverIndex(request, (ActionListener<RolloverResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AcknowledgedResponse> createDataStreamAsync(CreateDataStreamAction.Request request) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        this.createDataStream(request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AcknowledgedResponse> deleteDataStreamAsync(DeleteDataStreamAction.Request request) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        this.deleteDataStream(request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetDataStreamAction.Response> getDataStreamsAsync(GetDataStreamAction.Request request) {
        CompletableFuture<GetDataStreamAction.Response> future = new CompletableFuture<GetDataStreamAction.Response>();
        this.getDataStreams(request, (ActionListener<GetDataStreamAction.Response>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<ResolveIndexAction.Response> resolveIndexAsync(ResolveIndexAction.Request request) {
        CompletableFuture<ResolveIndexAction.Response> future = new CompletableFuture<ResolveIndexAction.Response>();
        this.resolveIndex(request, (ActionListener<ResolveIndexAction.Response>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetViewAction.Response> createViewAsync(CreateViewAction.Request request) {
        CompletableFuture<GetViewAction.Response> future = new CompletableFuture<GetViewAction.Response>();
        this.createView(request, (ActionListener<GetViewAction.Response>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetViewAction.Response> getViewAsync(GetViewAction.Request request) {
        CompletableFuture<GetViewAction.Response> future = new CompletableFuture<GetViewAction.Response>();
        this.getView(request, (ActionListener<GetViewAction.Response>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<AcknowledgedResponse> deleteViewAsync(DeleteViewAction.Request request) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        this.deleteView(request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetViewAction.Response> updateViewAsync(CreateViewAction.Request request) {
        CompletableFuture<GetViewAction.Response> future = new CompletableFuture<GetViewAction.Response>();
        this.updateView(request, (ActionListener<GetViewAction.Response>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<PauseIngestionResponse> pauseIngestionAsync(PauseIngestionRequest request) {
        CompletableFuture<PauseIngestionResponse> future = new CompletableFuture<PauseIngestionResponse>();
        this.pauseIngestion(request, (ActionListener<PauseIngestionResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<ResumeIngestionResponse> resumeIngestionAsync(ResumeIngestionRequest request) {
        CompletableFuture<ResumeIngestionResponse> future = new CompletableFuture<ResumeIngestionResponse>();
        this.resumeIngestion(request, (ActionListener<ResumeIngestionResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }

    default public CompletionStage<GetIngestionStateResponse> getIngestionStateAsync(GetIngestionStateRequest request) {
        CompletableFuture<GetIngestionStateResponse> future = new CompletableFuture<GetIngestionStateResponse>();
        this.getIngestionState(request, (ActionListener<GetIngestionStateResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
        return future;
    }
}

