/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor.fs;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.filecache.FileCacheSettings;
import org.opensearch.indices.IndicesService;
import org.opensearch.monitor.fs.FsInfo;
import org.opensearch.monitor.fs.FsProbe;
import org.opensearch.monitor.fs.FsService;

public class WarmFsService
extends FsService {
    private static final Logger logger = LogManager.getLogger(WarmFsService.class);
    private final FileCacheSettings fileCacheSettings;
    private final IndicesService indicesService;
    private final FileCache fileCache;

    public WarmFsService(Settings settings, NodeEnvironment nodeEnvironment, FileCacheSettings fileCacheSettings, IndicesService indicesService, FileCache fileCache) {
        super(settings, nodeEnvironment, fileCache);
        this.fileCacheSettings = fileCacheSettings;
        this.indicesService = indicesService;
        this.fileCache = fileCache;
    }

    @Override
    public FsInfo stats() {
        double dataToFileCacheSizeRatio = this.fileCacheSettings.getRemoteDataRatio();
        long nodeCacheSize = this.fileCache != null ? this.fileCache.capacity() : 0L;
        long totalBytes = (long)(dataToFileCacheSizeRatio * (double)nodeCacheSize);
        long usedBytes = 0L;
        if (this.indicesService != null) {
            for (IndexService indexService : this.indicesService) {
                for (IndexShard shard : indexService) {
                    if (shard.routingEntry() == null || !shard.routingEntry().primary() || !shard.routingEntry().active()) continue;
                    try {
                        usedBytes += shard.store().stats(0L).getSizeInBytes();
                    }
                    catch (Exception e) {
                        logger.error("Unable to get store size for shard {} with error: {}", (Object)shard.shardId(), (Object)e.getMessage());
                    }
                }
            }
        }
        long freeBytes = Math.max(0L, totalBytes - usedBytes);
        FsInfo.Path warmPath = new FsInfo.Path();
        warmPath.path = "/warm";
        warmPath.mount = "warm";
        warmPath.type = "warm";
        warmPath.total = FsProbe.adjustForHugeFilesystems(totalBytes);
        warmPath.free = FsProbe.adjustForHugeFilesystems(freeBytes);
        warmPath.available = FsProbe.adjustForHugeFilesystems(freeBytes);
        if (this.fileCache != null) {
            warmPath.fileCacheReserved = FsProbe.adjustForHugeFilesystems(this.fileCache.capacity());
            warmPath.fileCacheUtilized = FsProbe.adjustForHugeFilesystems(this.fileCache.usage());
        }
        logger.trace("Warm node disk usage - total: {}, used: {}, free: {}", (Object)totalBytes, (Object)usedBytes, (Object)freeBytes);
        FsInfo nodeFsInfo = super.stats();
        return new FsInfo(System.currentTimeMillis(), nodeFsInfo.getIoStats(), new FsInfo.Path[]{warmPath});
    }
}

